/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.sharing;

import com.inet.annotations.JsonData;
import com.inet.cache.MemoryStoreMap;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.feature.ShareAnonymLink;
import com.inet.drive.api.feature.ShareData;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.m;
import com.inet.id.GUID;
import com.inet.lib.json.Bon;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.EventDispatcher;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ShareManager
implements DriveObserver {
    private static ShareManager gg;
    private MemoryStoreMap<String, String> gh = new MemoryStoreMap(600, true);
    private MemoryStoreMap<String, String> gi = new MemoryStoreMap(600, true);
    private ConcurrentHashMap<@Nonnull GUID, EventDispatcher<c>> gj = new ConcurrentHashMap();
    private ConcurrentHashMap<@Nonnull GUID, Set<String>> gk = new ConcurrentHashMap();
    private ConcurrentHashMap<@Nonnull GUID, Set<String>> gl = new ConcurrentHashMap();
    private static final ThreadLocal<ServerLock> gm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShareManager bU() {
        if (gg != null) return gg;
        Class<ShareManager> clazz = ShareManager.class;
        synchronized (ShareManager.class) {
            if (gg != null) return gg;
            gg = new ShareManager();
            com.inet.drive.webgui.server.a.du().addObserver(gg);
            // ** MonitorExit[var0] (shouldn't be in output)
            return gg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    private HashSet<String> l(@Nonnull GUID gUID) {
        HashSet<String> hashSet = new HashSet<String>();
        if (UserManager.getRecoveryEnabledInstance().getUserAccount(gUID) == null) return hashSet;
        String string = "LOCK_KEY_SHAREMANAGER_CACHE";
        synchronized ("LOCK_KEY_SHAREMANAGER_CACHE") {
            hashSet.addAll(this.a(false, gUID));
            Set set = UserGroupManager.getInstance().getGroupsForUser(gUID);
            if (set == null) return hashSet;
            for (UserGroupInfo userGroupInfo : set) {
                hashSet.addAll(this.a(true, userGroupInfo.getID()));
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return hashSet;
        }
    }

    @Nonnull
    private Set<String> a(boolean bl, @Nonnull GUID gUID2) {
        ConcurrentHashMap<GUID, Set<String>> concurrentHashMap = bl ? this.gk : this.gl;
        String string = bl ? com.inet.drive.server.search.a.fP.getTag() : com.inet.drive.server.search.a.fO.getTag();
        return concurrentHashMap.computeIfAbsent(gUID2, gUID -> this.a(string, (GUID)gUID));
    }

    @Nonnull
    private Set<String> a(@Nonnull String string, @Nonnull GUID gUID) {
        HashSet hashSet = new HashSet();
        IndexSearchEngine<String> indexSearchEngine = ((com.inet.drive.server.a)com.inet.drive.webgui.server.a.du()).J().bM();
        SearchCondition searchCondition = new SearchCondition(string, SearchCondition.SearchTermOperator.Contains, (Object)gUID);
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{searchCondition});
        Set set = indexSearchEngine.simpleSearch(searchCommand);
        if (!set.isEmpty()) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                for (String string2 : set) {
                    DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(string2);
                    if (driveEntry == null) continue;
                    this.m(driveEntry).ifPresent(hashSet::add);
                }
            }
        }
        return Collections.synchronizedSet(hashSet);
    }

    @Nonnull
    private Optional<String> m(@Nonnull DriveEntry driveEntry) {
        ShareData shareData;
        com.inet.drive.api.feature.c c2 = driveEntry.getFeature(DriveEntry.SHARE);
        if (c2 != null && (shareData = c2.w()) != null) {
            return Optional.of(shareData.getId());
        }
        return Optional.empty();
    }

    private void a(boolean bl, @Nonnull GUID gUID, String string) {
        this.a(bl, gUID).add(string);
    }

    private void b(boolean bl, @Nonnull GUID gUID, @Nonnull String string) {
        this.a(bl, gUID).remove(string);
    }

    public void a(@Nonnull c c2) {
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getWriteLock("LOCK_KEY_SHAREMANAGER_LISTENER", 1000L);){
            EventDispatcher eventDispatcher = this.gj.computeIfAbsent(c2.getUserID(), gUID -> new EventDispatcher(false));
            eventDispatcher.registerListener((Object)c2);
        }
    }

    public void b(c c2) {
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getWriteLock("LOCK_KEY_SHAREMANAGER_LISTENER", 1000L);){
            EventDispatcher<c> eventDispatcher = this.gj.get(c2.getUserID());
            if (eventDispatcher != null) {
                eventDispatcher.unregisterListener((Object)c2);
                if (eventDispatcher.getListeners().isEmpty()) {
                    this.gj.remove(c2.getUserID());
                }
            }
        }
    }

    @Nullable
    private EventDispatcher<c> m(@Nonnull GUID gUID) {
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getReadLock("LOCK_KEY_SHAREMANAGER_LISTENER", 1000L);){
            EventDispatcher<c> eventDispatcher = this.gj.get(gUID);
            return eventDispatcher;
        }
    }

    @Nonnull
    private @Nonnull Set<@Nonnull GUID> bV() {
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getReadLock("LOCK_KEY_SHAREMANAGER_LISTENER", 1000L);){
            HashSet<GUID> hashSet = new HashSet<GUID>(this.gj.keySet());
            return hashSet;
        }
    }

    public static void bW() {
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("/drive/share/");
        for (PersistenceEntry persistenceEntry2 : persistenceEntry.getChildren()) {
            String string = persistenceEntry2.getName();
            UserAccount userAccount = UserManager.getRecoveryEnabledInstance().getUserAccount(GUID.valueOf((String)string));
            if (userAccount != null) continue;
            DrivePlugin.LOGGER.debug((Object)("User " + string + " not found so the drive share ids will be removed!"));
            persistenceEntry2.deleteValue();
        }
    }

    @Nullable
    public String I(@Nullable String string) {
        String string2 = (String)this.gh.get((Object)string);
        if (string2 == null) {
            IndexSearchEngine<String> indexSearchEngine = ((com.inet.drive.server.a)com.inet.drive.webgui.server.a.du()).J().bM();
            SearchCondition searchCondition = new SearchCondition(com.inet.drive.server.search.a.fN.getTag(), SearchCondition.SearchTermOperator.Contains, (Object)string);
            SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{searchCondition});
            Set set = indexSearchEngine.simpleSearch(searchCommand);
            if (set.isEmpty()) {
                return null;
            }
            string2 = (String)set.iterator().next();
            this.gh.put((Object)string, (Object)string2);
            this.gi.put((Object)string2, (Object)string);
        }
        return string2;
    }

    @Nullable
    public DriveEntry J(String string) {
        String string2 = this.I(string);
        if (string2 == null) {
            return null;
        }
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve(string2);
            if (driveEntry == null) {
                this.gh.remove((Object)string);
            }
            DriveEntry driveEntry2 = driveEntry;
            return driveEntry2;
        }
    }

    @Nullable
    public ShareData K(@Nonnull String string) {
        DriveEntry driveEntry = this.J(string);
        if (driveEntry != null) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                ShareData shareData;
                com.inet.drive.api.feature.c c2 = driveEntry.getFeature(DriveEntry.SHARE);
                if (c2 != null && (shareData = c2.w()) != null && shareData.getId().equals(string)) {
                    ShareData shareData2 = shareData;
                    return shareData2;
                }
            }
        }
        return null;
    }

    @Nullable
    public ShareAnonymLink L(@Nonnull String string) {
        com.inet.drive.api.feature.c c2;
        DriveEntry driveEntry = this.J(string);
        if (driveEntry != null && (c2 = driveEntry.getFeature(DriveEntry.SHARE)) != null) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                for (ShareAnonymLink shareAnonymLink : c2.y()) {
                    if (!shareAnonymLink.getId().equals(string)) continue;
                    ShareAnonymLink shareAnonymLink2 = shareAnonymLink;
                    return shareAnonymLink2;
                }
            }
        }
        return null;
    }

    public boolean M(@Nonnull String string) {
        com.inet.drive.api.feature.c c2;
        DriveEntry driveEntry;
        if (DriveIDUtils.isShareID(string) && DriveIDUtils.getSharedRootID(string) != null && DriveIDUtils.getProviderID(string) == null && (driveEntry = this.J(string)) != null && (c2 = driveEntry.getFeature(DriveEntry.SHARE)) != null) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                List<ShareAnonymLink> list = c2.y();
                for (ShareAnonymLink shareAnonymLink : list) {
                    if (!shareAnonymLink.getId().equals(string) || shareAnonymLink.isExpired()) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    @Nonnull
    public HashSet<String> n(@Nonnull GUID gUID) {
        return new HashSet<String>(ShareManager.r(gUID).getHiddenShareIDs());
    }

    @Nonnull
    public HashSet<String> o(@Nonnull GUID gUID) {
        HashSet<String> hashSet = this.l(gUID);
        ShareUserData shareUserData = ShareManager.r(gUID);
        hashSet.removeAll(shareUserData.getHiddenShareIDs());
        hashSet.addAll(shareUserData.getShareAccesses().keySet());
        return hashSet;
    }

    public void c(@Nonnull String string, @Nonnull GUID gUID, @Nullable String string2) throws AccessDeniedException {
        ShareAnonymLink shareAnonymLink = this.L(string);
        if (shareAnonymLink != null && shareAnonymLink.getPassword() != null) {
            if (!shareAnonymLink.getPassword().equals(string2)) {
                throw new AccessDeniedException("Invalid password");
            }
            this.a(gUID, string);
        }
    }

    private void a(@Nonnull GUID gUID, @Nonnull String string) {
        PersistenceEntry persistenceEntry = ShareManager.p(gUID);
        try (ServerLock serverLock = e.f(persistenceEntry);){
            ShareUserData shareUserData = ShareManager.r(gUID);
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(shareUserData.getShareAccesses());
            hashMap.put(string, Boolean.TRUE);
            shareUserData.setShareAccesses(hashMap);
            ShareManager.a(persistenceEntry, shareUserData);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException(timeoutException);
        }
    }

    @Nullable
    private static <T> T a(@Nonnull GUID gUID, @Nonnull @Nonnull Function<@Nonnull PersistenceEntry, T> function, @Nullable Supplier<T> supplier) {
        ServerLock serverLock = gm.get();
        if (serverLock != null) {
            return function.apply(ShareManager.p(gUID));
        }
        PersistenceEntry persistenceEntry = ShareManager.p(gUID);
        try {
            T t2;
            block12: {
                ServerLock serverLock2 = e.f(persistenceEntry);
                try {
                    gm.set(serverLock2);
                    t2 = function.apply(persistenceEntry);
                    if (serverLock2 == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (serverLock2 != null) {
                            try {
                                serverLock2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (TimeoutException timeoutException) {
                        throw new RuntimeException(timeoutException);
                    }
                }
                serverLock2.close();
            }
            return t2;
        }
        finally {
            gm.set(null);
        }
    }

    @Nonnull
    private static PersistenceEntry p(@Nonnull GUID gUID) {
        return Persistence.getRecoveryEnabledInstance().resolve("/drive/share/" + String.valueOf(gUID));
    }

    public boolean b(@Nonnull String string, @Nonnull GUID gUID) {
        if (this.K(string) != null) {
            return true;
        }
        ShareAnonymLink shareAnonymLink = this.L(string);
        if (shareAnonymLink == null) {
            return false;
        }
        if (shareAnonymLink.getPassword() == null) {
            return true;
        }
        Map<String, Boolean> map = ShareManager.r(gUID).getShareAccesses();
        return Boolean.TRUE.equals(map.get(string));
    }

    public void c(@Nonnull String string, @Nonnull GUID gUID) {
        ShareAnonymLink shareAnonymLink = this.L(string);
        ShareManager.a(gUID, persistenceEntry -> {
            ShareUserData shareUserData = ShareManager.r(gUID);
            if (shareAnonymLink == null) {
                HashSet<String> hashSet = new HashSet<String>(shareUserData.getHiddenShareIDs());
                hashSet.remove(string);
                shareUserData.setHiddenShareIDs(hashSet);
            } else {
                Boolean bl = null;
                if (shareAnonymLink.getPassword() != null) {
                    bl = Boolean.FALSE;
                }
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(shareUserData.getShareAccesses());
                hashMap.remove(string);
                hashMap.put(string, bl);
                shareUserData.setShareAccesses(hashMap);
            }
            ShareManager.a(persistenceEntry, shareUserData);
            return null;
        }, null);
        this.a(string, gUID, true);
    }

    public void d(@Nonnull String string, @Nonnull GUID gUID) {
        ShareManager.a(gUID, persistenceEntry -> {
            ShareUserData shareUserData = ShareManager.r(gUID);
            if (this.K(string) != null) {
                HashSet<String> hashSet = new HashSet<String>(shareUserData.getHiddenShareIDs());
                hashSet.add(string);
                shareUserData.setHiddenShareIDs(hashSet);
            } else {
                HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(shareUserData.getShareAccesses());
                hashMap.remove(string);
                shareUserData.setShareAccesses(hashMap);
            }
            ShareManager.a(persistenceEntry, shareUserData);
            return null;
        }, null);
        this.a(string, gUID, false);
    }

    private void a(String string, GUID gUID, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>(this.n(gUID));
        HashSet<String> hashSet2 = new HashSet<String>(this.o(gUID));
        HashSet<String> hashSet3 = new HashSet<String>(hashSet);
        hashSet3.addAll(hashSet2);
        boolean bl2 = bl && (hashSet3.isEmpty() || hashSet3.size() == 1 && hashSet3.contains(string));
        boolean bl3 = !bl && hashSet.isEmpty() && hashSet2.isEmpty();
        EventDispatcher<c> eventDispatcher = this.m(gUID);
        if (eventDispatcher != null) {
            eventDispatcher.dispatchEvent(c2 -> {
                try {
                    if (bl) {
                        if (bl2) {
                            c2.O("SharedWithMe");
                        }
                        c2.O(string);
                    } else {
                        c2.P(string);
                        if (bl3) {
                            c2.P("SharedWithMe");
                        }
                    }
                }
                catch (Exception exception) {
                    DrivePlugin.LOGGER.debug("Failed to notify observer: " + String.valueOf(c2), (Object)exception);
                }
            });
        }
    }

    public void q(@Nonnull GUID gUID) {
        PersistenceEntry persistenceEntry = ShareManager.p(gUID);
        if (persistenceEntry.exists()) {
            try (ServerLock serverLock = e.f(persistenceEntry);){
                persistenceEntry.deleteValue();
            }
            catch (TimeoutException timeoutException) {
                throw new RuntimeException(timeoutException);
            }
        }
    }

    @Nonnull
    private static ShareUserData r(@Nonnull GUID gUID) {
        return ShareManager.a(gUID, persistenceEntry -> {
            byte[] byArray = persistenceEntry.getBytes();
            if (byArray != null) {
                try {
                    ShareUserData shareUserData = (ShareUserData)new Bon().fromBinary(byArray, ShareUserData.class);
                    if (shareUserData != null) {
                        ShareManager.a(shareUserData, gUID);
                        return shareUserData;
                    }
                }
                catch (Throwable throwable) {
                    DrivePlugin.LOGGER.debug("Will be deleted because of wrong data format. " + persistenceEntry.getPath(), (Object)throwable);
                    persistenceEntry.deleteValue();
                }
            }
            return new ShareUserData();
        }, () -> new ShareUserData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(@Nonnull ShareUserData shareUserData, @Nonnull GUID gUID) {
        HashSet<String> hashSet = new HashSet<String>(shareUserData.getHiddenShareIDs());
        HashSet<String> hashSet2 = new HashSet<String>();
        String string = "LOCK_KEY_SHAREMANAGER_CACHE";
        synchronized ("LOCK_KEY_SHAREMANAGER_CACHE") {
            for (String string2 : hashSet) {
                boolean bl = false;
                Set<String> set = ShareManager.bU().a(false, gUID);
                if (set.contains(string2)) {
                    bl = true;
                }
                for (UserGroupInfo userGroupInfo : UserGroupManager.getInstance().getGroupsForUser(gUID)) {
                    Set<String> set2 = ShareManager.bU().a(true, userGroupInfo.getID());
                    if (!set2.contains(string2)) continue;
                    bl = true;
                }
                if (bl) continue;
                hashSet2.add(string2);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            hashSet.removeAll(hashSet2);
            shareUserData.setHiddenShareIDs(hashSet);
            return;
        }
    }

    private static void a(@Nonnull PersistenceEntry persistenceEntry, @Nonnull ShareUserData shareUserData) {
        if (shareUserData.getShareAccesses().isEmpty() && shareUserData.getHiddenShareIDs().isEmpty()) {
            persistenceEntry.deleteValue();
        } else {
            persistenceEntry.setBytes(new Bon().toBinary((Object)shareUserData));
        }
    }

    @Override
    public boolean synchronizedEvent() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public <T> void changed(@Nonnull DriveObserver.EventType<T> type, @Nonnull T eventData) {
        DriveObserver.EventType.RemoveEvent removeEvent;
        String string;
        if (type == DriveObserver.EventType.SHARE) {
            DriveObserver.EventType.a a2 = (DriveObserver.EventType.a)eventData;
            DriveEntry driveEntry = a2.getEntry();
            if (a2.h() == DriveObserver.EventType.a.a.A) {
                this.gh.remove((Object)a2.i());
                this.gi.remove((Object)driveEntry.getID());
            } else {
                this.gh.put((Object)a2.i(), (Object)driveEntry.getID());
                this.gi.put((Object)driveEntry.getID(), (Object)a2.i());
            }
            com.inet.drive.api.feature.c c2 = driveEntry.getFeature(DriveEntry.SHARE);
            if (c2 != null) {
                ShareData shareData;
                try (Object object2 = UserAccountScope.createPrivileged();){
                    for (ShareAnonymLink object3 : c2.y()) {
                        if (!a2.i().equals(object3.getId())) continue;
                        if (a2.h() == DriveObserver.EventType.a.a.A) {
                            ForkJoinPool.commonPool().execute(() -> {
                                Set<@Nonnull GUID> set = this.bV();
                                for (GUID gUID : set) {
                                    if (!this.o(gUID).contains(a2.i())) continue;
                                    this.d(a2.i(), gUID);
                                }
                            });
                        }
                        return;
                    }
                    shareData = c2.w();
                    if (shareData == null) {
                        ForkJoinPool.commonPool().execute(() -> {
                            Set<GUID> set = this.bV();
                            for (GUID gUID : set) {
                                if (!this.o(gUID).contains(a2.i())) continue;
                                this.d(a2.i(), gUID);
                            }
                        });
                    } else if (!shareData.getId().equals(a2.i())) {
                        return;
                    }
                }
                object2 = a2.k();
                Set<GUID> set = a2.j();
                Map<@Nonnull Object, Object> map = shareData == null ? new HashMap() : shareData.getPermissions(false);
                Map<@Nonnull Object, Object> map2 = shareData == null ? new HashMap() : shareData.getPermissions(true);
                ForkJoinPool.commonPool().execute(() -> this.a((Set)object2, map, a2, set, map2));
            }
        } else if (type == DriveObserver.EventType.REMOVED && (string = (String)this.gi.get((Object)(removeEvent = (DriveObserver.EventType.RemoveEvent)eventData).getId())) != null) {
            this.gh.remove((Object)string);
            this.gi.remove((Object)removeEvent.getId());
            ForkJoinPool.commonPool().execute(() -> {
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    Object object = "LOCK_KEY_SHAREMANAGER_CACHE";
                    synchronized ("LOCK_KEY_SHAREMANAGER_CACHE") {
                        Set<String> set;
                        for (GUID gUID : this.gk.keySet()) {
                            set = this.gk.get(gUID);
                            if (set == null) continue;
                            set.remove(string);
                        }
                        for (GUID gUID : this.gl.keySet()) {
                            set = this.gl.get(gUID);
                            if (set == null) continue;
                            set.remove(string);
                        }
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        object = this.bV();
                        Iterator<Object> iterator = object.iterator();
                        while (iterator.hasNext()) {
                            GUID gUID;
                            gUID = (GUID)iterator.next();
                            this.a(string, gUID, false);
                        }
                    }
                }
                catch (Throwable throwable) {
                    DrivePlugin.LOGGER.error("An event occured an error: ", throwable);
                }
                {
                    return;
                }
            });
        }
    }

    public static <T> T a(@Nonnull String string, @Nonnull a<T> a2) {
        try {
            m.C(string);
            T t2 = a2.execute();
            return t2;
        }
        finally {
            m.C(null);
        }
    }

    public static <T, E extends Throwable> T a(@Nonnull String string, @Nonnull b<T, E> b2) throws E {
        try {
            m.C(string);
            T t2 = b2.execute();
            return t2;
        }
        finally {
            m.C(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void a(Set set, Map map, DriveObserver.EventType.a a2, Set set2, Map map2) {
        Object object = "LOCK_KEY_SHAREMANAGER_CACHE";
        synchronized ("LOCK_KEY_SHAREMANAGER_CACHE") {
            for (GUID gUID : set) {
                if (map.containsKey(gUID)) continue;
                this.b(false, gUID, a2.i());
            }
            for (GUID gUID : set2) {
                if (map2.containsKey(gUID)) continue;
                this.b(true, gUID, a2.i());
            }
            for (GUID gUID : map.keySet()) {
                if (set.contains(gUID)) continue;
                this.a(false, gUID, a2.i());
            }
            for (GUID gUID : map2.keySet()) {
                if (set2.contains(gUID)) continue;
                this.a(true, gUID, a2.i());
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            object = this.bV();
            Iterator<Object> iterator = object.iterator();
            while (iterator.hasNext()) {
                GUID gUID;
                gUID = (GUID)iterator.next();
                boolean bl = set.contains(gUID);
                boolean bl2 = map.containsKey(gUID);
                Set set3 = UserGroupManager.getInstance().getGroupsForUser(gUID);
                for (UserGroupInfo userGroupInfo : set3) {
                    bl |= set2.contains(userGroupInfo.getID());
                    bl2 |= map2.containsKey(userGroupInfo.getID());
                }
                if (bl == bl2) continue;
                this.a(a2.i(), gUID, bl2);
            }
            return;
        }
    }

    static {
        gm = new ThreadLocal();
    }

    public static interface c {
        @Nonnull
        public GUID getUserID();

        public void O(@Nonnull String var1);

        public void P(@Nonnull String var1);
    }

    @JsonData
    public static class ShareUserData {
        @Nonnull
        HashSet<String> hiddenShareIDs = new HashSet();
        @Nonnull
        Map<String, Boolean> shareAccesses = new HashMap<String, Boolean>();

        private ShareUserData() {
        }

        @Nonnull
        public HashSet<String> getHiddenShareIDs() {
            return this.hiddenShareIDs;
        }

        @Nonnull
        public Map<String, Boolean> getShareAccesses() {
            return this.shareAccesses;
        }

        public void setHiddenShareIDs(@Nonnull HashSet<String> hiddenShareIDs) {
            this.hiddenShareIDs = hiddenShareIDs;
        }

        public void setShareAccesses(@Nonnull Map<String, Boolean> shareAccesses) {
            this.shareAccesses = shareAccesses;
        }
    }

    static interface a<T> {
        public T execute();
    }

    static interface b<T, E extends Throwable> {
        public T execute() throws E;
    }
}

