/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.LockException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.feature.UploadListener;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.server.persistence.c;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.f;
import com.inet.drive.server.persistence.m;
import com.inet.id.GUID;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserEventAdapter;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class r
extends f {
    public static final ConfigValue<Boolean> fz = new ConfigValue(ConfigKey.USERDIRECTORIES_ENABLED);
    public static final ConfigValue<Boolean> fA = new ConfigValue(ConfigKey.USERDIRECTORIES_GUEST_ACCOUNT_ENABLED);
    public static final UserEventAdapter fB = new UserEventAdapter(){

        public void userAccountBeforeDeleted(@Nonnull UserAccount userAccount) {
            if (!DriveUtils.hasValidLicense()) {
                return;
            }
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                this.c(userAccount);
                this.d(userAccount);
            }
        }

        private void c(UserAccount userAccount) {
            Object object;
            Object object2;
            String string = DriveUtils.getHomeFolderID(userAccount);
            Drive drive = com.inet.drive.webgui.server.a.du();
            GUID gUID = userAccount.getID();
            if (string != null && (object2 = drive.resolve(string)) != null) {
                object = new a();
                int n2 = 100;
                while (n2 > 0) {
                    try {
                        object2.delete((OperationProgressListener)object);
                        break;
                    }
                    catch (DriveOperationConflictException driveOperationConflictException) {
                        boolean bl = false;
                        for (DriveOperationConflictException.SingleEntryConflict singleEntryConflict : driveOperationConflictException.getConflicts()) {
                            if (!DriveOperationConflictException.CONFLICT.locked.equals((Object)singleEntryConflict.getConflict())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            throw new RuntimeException(DrivePlugin.MSG_SERVER.getMsg("drive.home.deletion.message.error", new Object[]{driveOperationConflictException, ((a)object).bI()}));
                        }
                        --n2;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (n2 <= 0) {
                    throw new RuntimeException(DrivePlugin.MSG_SERVER.getMsg("drive.home.deletion.message.errorlock", new Object[0]));
                }
            }
            object2 = DriveUtils.getMountsForUser(com.inet.drive.webgui.server.a.du(), gUID.toString());
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = (String)object.next();
                try {
                    DriveEntry driveEntry = drive.resolve(string2);
                    if (driveEntry == null) continue;
                    driveEntry.delete(null);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {}
            }
            object = MountManager.getInstance();
            List<MountDescription> list = ((MountManager)object).getMountDescriptions(userAccount.getID());
            for (MountDescription mountDescription : list) {
                ((MountManager)object).removeMountDescription(mountDescription);
            }
        }

        private void d(UserAccount userAccount) {
            Drive drive = com.inet.drive.webgui.server.a.du();
            IndexSearchEngine<String> indexSearchEngine = com.inet.drive.server.search.a.bK().bM();
            GUID gUID = userAccount.getID();
            SearchCondition searchCondition = new SearchCondition(com.inet.drive.server.search.a.fI.getTag(), SearchCondition.SearchTermOperator.Equals, (Object)gUID);
            Set set = indexSearchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{searchCondition}));
            for (String string : set) {
                Permissions permissions;
                DriveEntry driveEntry = drive.resolve(string);
                if (driveEntry == null || (permissions = driveEntry.getFeature(DriveEntry.PERMISSIONS)) == null) continue;
                Map<GUID, Map<String, Boolean>> map = permissions.getPermissions(true);
                Map<GUID, Map<String, Boolean>> map2 = permissions.getPermissions(false);
                if (!map.isEmpty() || map2.size() != 1 || !map2.containsKey(gUID)) continue;
                try {
                    driveEntry.delete(null);
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    DrivePlugin.LOGGER.warn((Object)DrivePlugin.MSG_SERVER.getMsg("drive.privatefolder.deletion.error", new Object[]{driveEntry.getID(), driveOperationConflictException}));
                }
            }
        }
    };

    public static PersistenceEntry bG() {
        return Persistence.getRecoveryEnabledInstance().resolve(e.ba() + "/.rootfolder");
    }

    public r(c c2) {
        super(c2);
        if (!r.bG().exists()) {
            ConcurrentHashMap<String, Object> concurrentHashMap = new ConcurrentHashMap<String, Object>();
            e.a(r.bG(), concurrentHashMap);
        }
    }

    @Override
    void f(String string, String string2) throws DriveOperationConflictException {
        if ("Home".equals(string2)) {
            UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
            if (userAccount != null) {
                this.b(userAccount.getID().toString(), string, true);
            } else {
                DrivePlugin.LOGGER.debug((Object)"No user logged in to add a child for root");
            }
        } else {
            super.f(string, string2);
        }
    }

    @Override
    boolean B(String string) {
        boolean bl = super.B(string);
        ConcurrentHashMap<String, Object> concurrentHashMap = r.bH();
        if (concurrentHashMap.containsValue(string)) {
            for (String string2 : concurrentHashMap.keySet()) {
                if (!string.equals(concurrentHashMap.get(string2))) continue;
                this.b(string2, string, false);
                return true;
            }
        }
        return bl;
    }

    private void b(String string, String string2, boolean bl) {
        try (ServerLock serverLock = e.f(r.bG());){
            ConcurrentHashMap<String, Object> concurrentHashMap = e.d(r.bG());
            boolean bl2 = false;
            if (bl) {
                bl2 = true;
                concurrentHashMap.put(string, string2);
            } else if (concurrentHashMap.containsKey(string)) {
                bl2 = true;
                concurrentHashMap.remove(string);
            }
            if (bl2) {
                e.a(r.bG(), concurrentHashMap);
            }
        }
        catch (TimeoutException timeoutException) {
            DrivePlugin.LOGGER.debug(timeoutException.getMessage(), (Object)timeoutException);
            throw new LockException();
        }
    }

    public static ConcurrentHashMap<String, Object> bH() {
        ConcurrentHashMap<String, Object> concurrentHashMap;
        block8: {
            ServerLock serverLock = e.g(r.bG());
            try {
                concurrentHashMap = e.d(r.bG());
                if (serverLock == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (serverLock != null) {
                        try {
                            serverLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TimeoutException timeoutException) {
                    DrivePlugin.LOGGER.debug(timeoutException.getMessage(), (Object)timeoutException);
                    throw new LockException();
                }
            }
            serverLock.close();
        }
        return concurrentHashMap;
    }

    @Override
    @Nonnull
    public List<DriveEntry> getChildren() {
        UserAccount userAccount;
        List<DriveEntry> list = super.getChildren();
        if ((m.a(UserManager.getInstance().getCurrentUserAccount()) || ((Boolean)fz.get()).booleanValue()) && (userAccount = UserManager.getInstance().getCurrentUserAccount()) != null) {
            if (userAccount.getAccountType() == UserAccountType.Temp) {
                return list;
            }
            if (userAccount.getAccountType() != UserAccountType.Guest || ((Boolean)fA.get()).booleanValue()) {
                GUID gUID = userAccount.getID();
                if (!UserManager.PRIVILEGED_ACCOUNT_ID.equals((Object)gUID)) {
                    DriveEntry driveEntry = this.b(userAccount);
                    if (driveEntry != null) {
                        list.add(driveEntry);
                    }
                } else {
                    ConcurrentHashMap<String, Object> concurrentHashMap = r.bH();
                    for (Object object : concurrentHashMap.values()) {
                        DriveEntry driveEntry = this.dV.C().resolve(object.toString());
                        if (driveEntry == null) continue;
                        list.add(driveEntry);
                    }
                }
            }
        }
        return list;
    }

    @Override
    public boolean a(String string, boolean bl, @Nullable String string2) throws DriveOperationConflictException {
        return this.a(string, bl, string2, true);
    }

    public boolean a(String string, boolean bl, @Nullable String string2, boolean bl2) throws DriveOperationConflictException {
        try (ServerLock serverLock = Persistence.getRecoveryEnabledInstance().getReadLock(this.ew.getPath(), 200L);){
            PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve(this.ex);
            Set<String> set = e.e(persistenceEntry);
            List<MountDescription> list = bl2 ? MountManager.getInstance().getAllMountDescriptions() : MountManager.getInstance().getMountDescriptions(UserManager.getInstance().getCurrentUserAccountID());
            for (MountDescription mountDescription : list) {
                if (!mountDescription.getName().equals(string) || mountDescription.getID().toString().equals(string2)) continue;
                this.a(DriveIDUtils.getMountRootID(mountDescription.getID()), string2, string, bl);
            }
            String string3 = this.a(set, string, string2);
            if (string3 != null) {
                this.a(string3, string2, string, bl);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DriveEntry b(UserAccount userAccount) {
        DriveEntry driveEntry;
        Object object = r.bH().get(userAccount.getID().toString());
        if (object != null && (driveEntry = this.dV.C().e(object.toString())) != null) {
            return driveEntry;
        }
        try (ServerLock serverLock = this.k(userAccount.getID());){
            DriveEntry driveEntry2;
            userAccount = UserManager.getInstance().getUserAccount(userAccount.getID());
            Object object2 = (String)userAccount.getValue(DriveUtils.USERFIELD_DRIVE_HOMEFOLDER);
            if (object2 != null && this.dV.C().e((String)object2) != null) {
                DriveEntry driveEntry3 = null;
                return driveEntry3;
            }
            object2 = r.bH().get(userAccount.getID().toString());
            if (object2 != null && (driveEntry2 = this.dV.C().e(object2.toString())) != null) {
                DriveEntry driveEntry4 = driveEntry2;
                return driveEntry4;
            }
            driveEntry = c.a(this.dV, this.dV.C(), userAccount.getID(), userAccount.getDisplayName());
        }
        catch (DriveOperationConflictException driveOperationConflictException) {
            throw new RuntimeException(driveOperationConflictException);
        }
        catch (Throwable throwable) {
            DrivePlugin.LOGGER.error("Couldn't create the user home folder for user " + String.valueOf(userAccount.getID()), throwable);
            return null;
        }
        this.dV.C().notifyObservers(DriveObserver.EventType.CREATED, driveEntry);
        return driveEntry;
    }

    private ServerLock k(GUID gUID) {
        return Persistence.getRecoveryEnabledInstance().getWriteLock(gUID.toString() + "_HOME", 1000L);
    }

    private static class a
    implements OperationProgressListener {
        private int fC;

        private a() {
        }

        public int bI() {
            return this.fC - 1;
        }

        @Override
        public void operateElements(HashSet<String> elements) {
        }

        @Override
        public void startOperationFor(@Nonnull String entryID) {
            ++this.fC;
        }

        @Override
        @Nullable
        public UploadListener getUploadListener() {
            return null;
        }
    }
}

