/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.maintenance;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.server.a;
import com.inet.id.GUID;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ThreadPool;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

public class c {
    private static ThreadPool.Work<?> di;
    private static List<Exception> errors;
    private static int deleted;
    private static int failed;
    private static int toDeleteTotal;

    public static synchronized void a(@Nonnull Drive drive, @Nonnull List<String> list) {
        if (c.aw()) {
            return;
        }
        Runnable runnable = () -> {
            Thread.currentThread().setName("Maintenance - Drive Home Folder Deletion");
            errors = new ArrayList<Exception>();
            deleted = 0;
            failed = 0;
            toDeleteTotal = 0;
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                toDeleteTotal = list.size();
                DrivePlugin.LOGGER.info((Object)("Start deletion of Drive home folders, " + toDeleteTotal + " home folders to delete."));
                for (String string : list) {
                    try {
                        DriveEntry driveEntry = drive.resolve(string);
                        if (driveEntry != null) {
                            GUID gUID = driveEntry.getMetaData(MetaData.CREATOR_ID);
                            HashSet<String> hashSet = c.a(drive, gUID);
                            hashSet.add(string);
                            driveEntry.delete(null);
                            c.a(drive, gUID, hashSet);
                        }
                        ++deleted;
                    }
                    catch (Exception exception) {
                        DrivePlugin.LOGGER.error((Throwable)exception);
                        errors.add(exception);
                        ++failed;
                    }
                }
                DrivePlugin.LOGGER.info((Object)"Deletion of Drive home folders completed");
            }
            catch (Exception exception) {
                errors.add(exception);
                DrivePlugin.LOGGER.error((Throwable)exception);
                DrivePlugin.LOGGER.error((Object)"Deletion of Drive home folders failed");
            }
        };
        di = ThreadPool.DEFAULT.startSubThread(runnable, (RunnableSession)new BaseRunnableSession());
    }

    private static HashSet<String> a(Drive drive, GUID gUID) {
        SearchCondition searchCondition = new SearchCondition(MetaData.HOMEFOLDER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)gUID);
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{searchCondition});
        SearchResult searchResult = ((a)drive).J().bM().search(searchCommand);
        HashSet<String> hashSet = new HashSet<String>();
        for (SearchResultEntry searchResultEntry : searchResult.getEntries()) {
            hashSet.add((String)searchResultEntry.getId());
        }
        return hashSet;
    }

    private static void a(Drive drive, GUID gUID, HashSet<String> hashSet) {
        SearchCondition searchCondition = new SearchCondition(MetaData.CREATOR_ID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)gUID);
        SearchCondition searchCondition2 = new SearchCondition(MetaData.LINK_INDESCRIPTIONID.getKey(), SearchCondition.SearchTermOperator.Unequals, null);
        SearchCommand searchCommand = new SearchCommand(new SearchExpression[]{searchCondition, searchCondition2});
        SearchResult searchResult = ((a)drive).J().bM().search(searchCommand);
        DrivePlugin.LOGGER.info((Object)("Looking for links with reference to deleted home folder - Founded own links " + searchResult.getEntries().size()));
        for (SearchResultEntry searchResultEntry : searchResult.getEntries()) {
            DriveEntry driveEntry = com.inet.drive.webgui.server.a.du().resolve((String)searchResultEntry.getId());
            if (driveEntry == null || !hashSet.contains(driveEntry.getMetaData(MetaData.LINK_INDESCRIPTIONID))) continue;
            try {
                driveEntry.delete(null);
            }
            catch (DriveOperationConflictException driveOperationConflictException) {
                DrivePlugin.LOGGER.info("Link could not be deleted " + driveOperationConflictException.getMessage(), (Object)driveOperationConflictException);
            }
        }
    }

    public static synchronized boolean aw() {
        return di != null && !di.isDown();
    }

    public static List<Exception> ax() {
        return errors;
    }

    public static int ay() {
        return deleted;
    }

    public static int az() {
        return failed;
    }

    public static int aA() {
        return toDeleteTotal;
    }

    static {
        errors = new ArrayList<Exception>();
    }
}

