/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.metadata;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.feature.MetaKey;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.GuidTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class UserMetaKey
extends MetaKey<GUID> {
    public UserMetaKey(@Nonnull String key, boolean useInSearch, boolean displayInDetails) {
        super(key, useInSearch, displayInDetails);
    }

    @Override
    @Nonnull
    public String getLabel() {
        return DrivePlugin.MSG_SERVER.getMsg("meta.key." + this.getKey(), new Object[0]);
    }

    @Override
    @Nullable
    public SearchTag getSearchTag() {
        if (!this.isUseInSearch() || this.searchTag != null) {
            return super.getSearchTag();
        }
        this.searchTag = new SearchTag(this.getKey(), SearchDataType.ID, false, (SearchTokenizer)new GuidTokenizer(), 0, (Supplier)new MetaKey.a(this), true);
        return this.searchTag;
    }

    @Override
    @Nonnull
    public String formatValue(@Nullable GUID modifiedBy) {
        if (modifiedBy != null) {
            GUID gUID = GUID.valueOf((String)modifiedBy.toString());
            UserAccount userAccount = UserManager.getInstance().getUserAccount(gUID);
            if (userAccount != null) {
                return userAccount.getDisplayName();
            }
            return DrivePlugin.MSG_SERVER.getMsg("drive.user.deleted", new Object[]{modifiedBy});
        }
        return DrivePlugin.MSG_SERVER.getMsg("drive.user.notset", new Object[0]);
    }
}

