/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.server.persistence.e;
import com.inet.drive.webgui.server.a;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DriveIDUtils {
    public static final char ID_SEPARATOR = '_';
    public static final String ROOT_ID_PREFIX = "m_";
    public static final String SHAREROOT_ID_PREFIX = "s_";
    @Nonnull
    private static final String m = String.valueOf('_');
    public static final int ID_LENGTH = GUID.generateNew().toString().length();
    @Nonnull
    private static final Pattern n = Pattern.compile("(?<!^[ms])_");
    @Nonnull
    private static final Pattern o = Pattern.compile("[0-9a-zA-Z_]*");

    @Nonnull
    public static String generateID() {
        String string = GUID.generateNew().toString();
        while (e.w(string).exists()) {
            string = GUID.generateNew().toString();
        }
        return string;
    }

    public static boolean isID(@Nullable String id) {
        return id != null && id.length() > 0 && (o.matcher(id).matches() && id.length() >= ID_LENGTH || "Drive".equals(id));
    }

    @Nonnull
    public static String getMountRootID(@Nonnull GUID mountdescriptionID) {
        return ROOT_ID_PREFIX + String.valueOf(mountdescriptionID);
    }

    @Nonnull
    public static String getMountRootID(@Nonnull GUID mountdescriptionID, @Nonnull String originID) {
        return ROOT_ID_PREFIX + String.valueOf(mountdescriptionID) + m + originID;
    }

    @Nullable
    public static String getMountRootID(@Nonnull String id) {
        if (id.startsWith(ROOT_ID_PREFIX)) {
            String string = id.substring(ROOT_ID_PREFIX.length());
            if (string.contains(m)) {
                string = string.split(m)[0];
            }
            return string;
        }
        return null;
    }

    @Nullable
    public static String getProviderID(@Nonnull String fullID) {
        String string = DriveIDUtils.getMountRootID(fullID);
        if (string == null) {
            string = DriveIDUtils.getSharedRootID(fullID);
        }
        if (string != null) {
            String string2;
            String string3 = string2 = fullID.split(string).length <= 1 ? "" : fullID.split(string)[1];
            if (string2.startsWith(m)) {
                string2 = string2.substring(1);
            }
            if (string2.isBlank()) {
                return null;
            }
            return string2;
        }
        return null;
    }

    @Nullable
    public static String getSharedRootID(@Nonnull String id) {
        if (id.startsWith(SHAREROOT_ID_PREFIX)) {
            String string = id.substring(SHAREROOT_ID_PREFIX.length());
            if (string.contains(m)) {
                string = string.split(m)[0];
            }
            return string;
        }
        return null;
    }

    public static boolean isIDWithPath(@Nonnull String idWithPath) {
        if (idWithPath.contains("/")) {
            String string = DriveIDUtils.extractID(idWithPath);
            return DriveIDUtils.isID(string);
        }
        return false;
    }

    public static String extractID(@Nonnull String idWithPath) {
        if (idWithPath.contains("/")) {
            return idWithPath.split("/")[0];
        }
        return idWithPath;
    }

    public static String extractPath(@Nonnull String idWithPath) {
        if (idWithPath.contains("/")) {
            return idWithPath.substring(idWithPath.indexOf("/"));
        }
        return "";
    }

    @Nonnull
    public static String generateMountID() {
        return GUID.generateNew().toString().toUpperCase();
    }

    @Nonnull
    public static String generateShareID() {
        return SHAREROOT_ID_PREFIX + String.valueOf(GUID.generateNew());
    }

    @Nullable
    public static String getMountBaseID(@Nonnull String mountID) {
        String string = mountID.length() <= ID_LENGTH ? mountID : mountID.substring(0, ID_LENGTH);
        if (DriveIDUtils.isID(string)) {
            return string;
        }
        return null;
    }

    @Nonnull
    public static String getLinkBaseID(@Nonnull String id) {
        if (!DriveIDUtils.isIDinLink(id)) {
            return id;
        }
        @Nonnull String[] stringArray = DriveIDUtils.splittID(id);
        if (stringArray.length < 2) {
            return id;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length && DriveIDUtils.isLink(stringArray[i2]); ++i2) {
            n2 += stringArray[i2].length();
            if (i2 <= 0) continue;
            ++n2;
        }
        if (n2 > 0) {
            return id.substring(0, n2);
        }
        return id;
    }

    @Nonnull
    public static String getShareBaseID(@Nonnull String id) {
        if (!DriveIDUtils.isIDinShare(id)) {
            return id;
        }
        @Nonnull String[] stringArray = DriveIDUtils.splittID(id);
        if (stringArray.length < 2) {
            return id;
        }
        return stringArray[0];
    }

    public static boolean isMountID(@Nonnull String id) {
        return id.startsWith(ROOT_ID_PREFIX) && !DriveIDUtils.hasMoreIDs(id);
    }

    public static boolean isShareID(@Nonnull String id) {
        return id.startsWith(SHAREROOT_ID_PREFIX) && !DriveIDUtils.hasMoreIDs(id);
    }

    public static boolean hasMoreIDs(@Nonnull String id) {
        if (id.startsWith(ROOT_ID_PREFIX)) {
            id = id.substring(ROOT_ID_PREFIX.length());
        }
        if (id.startsWith(SHAREROOT_ID_PREFIX)) {
            id = id.substring(SHAREROOT_ID_PREFIX.length());
        }
        return id.contains(m);
    }

    @Nonnull
    public static @Nonnull String @Nonnull [] splittID(@Nonnull String id) {
        return n.split(id);
    }

    public static boolean isIDinLink(@Nonnull String id) {
        if (id.length() < ID_LENGTH + 2) {
            return false;
        }
        if (id.charAt(ID_LENGTH) != '_') {
            return false;
        }
        for (int i2 = 0; i2 < ID_LENGTH; ++i2) {
            char c2 = id.charAt(i2);
            if (c2 >= '0' && (c2 <= '9' || c2 >= 'A') && c2 <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isLink(@Nonnull String id) {
        if (id.length() != ID_LENGTH) {
            return false;
        }
        for (int i2 = 0; i2 < ID_LENGTH; ++i2) {
            char c2 = id.charAt(i2);
            if (c2 >= '0' && (c2 <= '9' || c2 >= 'A') && c2 <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isIDinMount(@Nonnull String id) {
        if (!id.startsWith(ROOT_ID_PREFIX)) {
            return false;
        }
        return DriveIDUtils.hasMoreIDs(id);
    }

    public static boolean isIDinShare(@Nonnull String id) {
        if (!id.startsWith(SHAREROOT_ID_PREFIX)) {
            return false;
        }
        return DriveIDUtils.hasMoreIDs(id);
    }

    @Nonnull
    public static String getInMountID(@Nonnull String id) {
        if (DriveIDUtils.isIDinMount(id)) {
            int n2 = id.indexOf(95, ROOT_ID_PREFIX.length());
            return n2 >= 0 ? id.substring(n2 + 1) : id;
        }
        return id;
    }

    @Nullable
    public static String getParentMountID(@Nonnull String id) {
        int n2 = id.lastIndexOf(95);
        if (n2 < 0) {
            return DriveIDUtils.isMountID(id) ? id : null;
        }
        String string = id.substring(0, n2);
        String string2 = id.substring(n2 + 1);
        return DriveIDUtils.isMountID(string2) ? id : string;
    }

    @Nonnull
    public static String mergeID(@Nonnull String id, String ... nextIDs) {
        Object object = id;
        for (String string : nextIDs) {
            object = (String)object + "_" + string;
        }
        return object;
    }

    @Nonnull
    public static String getOriginID(@Nonnull DriveEntry entry) {
        Mount mount;
        for (mount = entry.getFeature(Mount.class); mount != null && mount.getChild() != null; mount = mount.getChild()) {
        }
        if (mount == null) {
            return entry.getID();
        }
        return mount.getOriginID();
    }

    @Nonnull
    public static String getSourceID(@Nonnull DriveEntry e2) {
        return e2.executeFeatureNN(Mount.class, mount -> {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                Object object;
                @Nonnull String string = mount.getOriginID();
                @Nonnull String string2 = mount.getProviderKey();
                if (!"PERSISTENCE_PROVIDER".equals(string2) && !"sharing".equals(string2)) {
                    String string3 = DriveIDUtils.getMountRootID(mount.getDescription().getID(), string);
                    return string3;
                }
                if (DriveIDUtils.isLink(string) && (object = a.du().resolve(string)) != null) {
                    String string4 = DriveIDUtils.getSourceID((DriveEntry)object);
                    return string4;
                }
                object = string;
                return object;
            }
        }, e2::getID);
    }
}

