/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
implements DriveEntry {
    private String dL;
    private String dM;
    private final String dN;
    private final String dO;
    private final MountDescription dP;
    private final com.inet.drive.server.a dQ;
    private final DriveEntry dB;
    private DriveEntry dR;
    private boolean dS = false;

    public a(com.inet.drive.server.a a2, DriveEntry driveEntry, MountDescription mountDescription, @Nonnull String string, @Nonnull String string2) {
        this.dQ = a2;
        this.dB = driveEntry;
        this.dP = mountDescription;
        this.dN = string;
        this.dO = string2;
    }

    private DriveEntry F() {
        if (this.dR == null && !this.dS) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                DriveEntry driveEntry = this.dQ.resolve(this.dN);
                if (driveEntry == null) {
                    DrivePlugin.LOGGER.debug((Object)("Can not resolve internal path or id for " + this.dN + " '" + this.aM() + "' and " + this.dO));
                    this.dS = true;
                    DriveEntry driveEntry2 = null;
                    return driveEntry2;
                }
                this.dR = this.aL().isBlank() || this.aL().equals("/") ? driveEntry : this.dQ.b(driveEntry, this.aL());
            }
            if (this.dR == null) {
                DrivePlugin.LOGGER.debug((Object)("Can not resolve internal link for " + this.dN + " - " + this.aM() + " and " + this.dO));
                this.dS = true;
            }
        }
        return this.dR;
    }

    private String aL() {
        if (this.dM == null && !this.dS) {
            if (this.dO.startsWith("/") || this.dO.isBlank()) {
                this.dM = this.dO;
            } else {
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    this.dR = this.dQ.d(this.dO);
                    if (this.dR == null) {
                        DrivePlugin.LOGGER.debug((Object)("Can not resolve internal link for " + this.aM() + " and " + this.dO));
                        this.dS = true;
                        this.dM = "";
                    } else {
                        if (this.aM().length() > 1 && this.dR.getPath().startsWith(this.aM())) {
                            String string = this.dR.getPath();
                            this.dM = string.substring(this.aM().length());
                        } else {
                            this.dM = this.dR.getPath();
                        }
                        if (this.dR.hasFeature(FOLDER) && !this.dM.endsWith("/")) {
                            this.dM = this.dM + "/";
                        }
                        if (!this.dM.startsWith("/")) {
                            this.dM = "/" + this.dM;
                        }
                    }
                }
            }
            if (this.F() != null && this.F().hasFeature(FOLDER) && !this.dM.endsWith("/")) {
                this.dM = this.dM + "/";
            }
        }
        return this.dM;
    }

    private String aM() {
        if (this.dL == null && !this.dS) {
            if (this.dN.startsWith("/") || this.dN.isBlank()) {
                this.dL = this.dN;
            } else {
                try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                    DriveEntry driveEntry = this.dQ.d(this.dN);
                    this.dL = driveEntry == null ? this.dN : driveEntry.getPath();
                }
            }
            if (!this.dL.endsWith("/")) {
                this.dL = this.dL + "/";
            }
        }
        return this.dL;
    }

    private void aN() {
        if (this.F() == null) {
            throw new MountManager.b(DrivePlugin.MSG_SERVER.getMsg("drive.entry.link.destinationNotFound", new Object[]{this.dN}));
        }
    }

    @Override
    @Nonnull
    public String getName() {
        this.aN();
        return this.F().getName();
    }

    @Override
    @Nonnull
    public String getPath() {
        this.aN();
        return this.aL();
    }

    @Override
    @Nonnull
    public String getID() {
        this.aN();
        return this.F().getID();
    }

    @Override
    public long getLastModified() throws DriveIOException {
        this.aN();
        return this.F().getLastModified();
    }

    @Override
    public boolean exists() {
        if (this.F() == null || this.dS) {
            return false;
        }
        return this.F().exists();
    }

    @Override
    public boolean hasFeature(@Nonnull Class<? extends DriveFeature> type) throws DriveIOException {
        this.aN();
        if (this.exists()) {
            return this.F().hasFeature(type);
        }
        return type == FOLDER || type == META_DATA;
    }

    @Override
    @Nullable
    public <T extends DriveFeature> T getFeature(@Nonnull Class<T> type) throws DriveIOException {
        this.aN();
        T t2 = this.F().getFeature(type);
        if (!this.exists() || t2 == null) {
            return null;
        }
        if (type == META_DATA) {
            final MetaData metaData = (MetaData)t2;
            return (T)new MetaData(){

                public <X> void setMetaData(@Nonnull MetaKey<X> key, @Nullable X value) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
                    try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)a.this.dP.getUserID());){
                        metaData.setMetaData(key, value);
                        if (key == NAME) {
                            a.this.dM = a.this.dR.getPath();
                        }
                    }
                }

                @Nullable
                public <X> X getMetaData(@Nonnull MetaKey<X> key) {
                    if (key == ID) {
                        return (X)a.this.getID();
                    }
                    if (key == PATH) {
                        return (X)a.this.getPath();
                    }
                    return metaData.getMetaData(key);
                }
            };
        }
        if (type == FOLDER && this.hasFeature(type)) {
            final Folder folder = (Folder)t2;
            return (T)new Folder(){

                @Override
                @Nonnull
                public List<DriveEntry> getChildren() {
                    List<DriveEntry> list;
                    ArrayList<DriveEntry> arrayList = new ArrayList<DriveEntry>();
                    try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)a.this.dP.getUserID());){
                        list = folder.getChildren();
                    }
                    for (DriveEntry driveEntry : list) {
                        if (driveEntry == a.this.F()) {
                            arrayList.add(driveEntry);
                            continue;
                        }
                        arrayList.add(new a(a.this.dQ, a.this.dB, a.this.dP, a.this.dN, a.this.getPath() + driveEntry.getName()));
                    }
                    return arrayList;
                }

                @Override
                public boolean hasChildren() {
                    try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)a.this.dP.getUserID());){
                        boolean bl = folder.hasChildren();
                        return bl;
                    }
                }

                @Override
                @Nonnull
                public DriveEntry createChild(@Nonnull String name) throws DriveOperationConflictException {
                    try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)a.this.dP.getUserID());){
                        DriveEntry driveEntry = folder.createChild(name);
                        a a2 = new a(a.this.dQ, a.this.dB, a.this.dP, a.this.dN, driveEntry.getID());
                        return a2;
                    }
                }

                @Override
                @Nonnull
                public DriveEntry createChild(@Nonnull DataEntry dataEntry) throws DriveOperationConflictException {
                    try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)a.this.dP.getUserID());){
                        DriveEntry driveEntry = folder.createChild(dataEntry);
                        a a2 = new a(a.this.dQ, a.this.dB, a.this.dP, a.this.dN, driveEntry.getID());
                        return a2;
                    }
                }
            };
        }
        return t2;
    }

    @Override
    @Nullable
    public DriveEntry getParent() {
        this.aN();
        String string = this.aL();
        String[] stringArray = DriveUtils.splitPath(string);
        if (this.dB != null && (string.isBlank() || string.equals("/") || stringArray.length == 1)) {
            return this.dB;
        }
        if (this.F() == null || this.F().getParent() == null) {
            return null;
        }
        if (this.aM().equals(this.F().getPath())) {
            return null;
        }
        return new a(this.dQ, this.dB, this.dP, this.dN, this.F().getParent().getID());
    }

    @Override
    public void delete(@Nullable OperationProgressListener listener) throws DriveOperationConflictException {
        this.aN();
        this.F().delete(listener);
    }

    @Override
    @Nonnull
    public String getExtensionName() {
        return "PERSISTENCE_PROVIDER";
    }
}

