/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.mount.file;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.Capabilities;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.RandomAccess;
import com.inet.drive.api.feature.Synchronization;
import com.inet.drive.api.mount.MountUtils;
import com.inet.drive.server.mount.file.a;
import com.inet.drive.server.mount.file.b;
import com.inet.drive.server.mount.file.d;
import com.inet.drive.server.mount.file.e;
import com.inet.drive.server.mount.file.f;
import com.inet.drive.server.mount.file.h;
import com.inet.drive.server.mount.file.i;
import com.inet.lib.util.IOFunctions;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class c
implements DriveEntry {
    @Nonnull
    private d.a dl;
    private f dm;
    private String id;
    @Nonnull
    private String dn;

    public c( @Nonnull d.a a2, @Nonnull String string) {
        this.dl = a2;
        this.dn = string;
        this.dm = new f(this, a2);
    }

    @Override
    @Nonnull
    public String getExtensionName() {
        return "file";
    }

    @Override
    @Nonnull
    public String getName() {
        return this.dl.aF().getName();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File mounts are restricted to administrator accounts")
    void p(@Nullable String string) throws DriveOperationConflictException {
        if (string == null || string.isBlank() || string.equals(".") || string.equals("..") || string.contains("/")) {
            String string2 = DrivePlugin.MSG_SERVER.getMsg("drive.entry.notallowedname", new Object[]{string});
            DriveOperationConflictException.SingleEntryConflict singleEntryConflict = new DriveOperationConflictException.SingleEntryConflict(null, this.getID(), DriveOperationConflictException.CONFLICT.invalidName, string2);
            throw DriveOperationConflictException.createSingleConflictException(false, singleEntryConflict);
        }
        if (this.dl.aF().toPath().equals(this.dl.aG().toPath())) {
            throw new IllegalArgumentException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.cannotchangename", new Object[]{this.dl.aF().getName(), string}));
        }
        File file = new File(this.dl.aF().getParentFile(), string);
        if (file.exists()) {
            String string3 = this.dl.a(file);
            DriveOperationConflictException.CONFLICT cONFLICT = file.isFile() ? DriveOperationConflictException.CONFLICT.alreadyExists : DriveOperationConflictException.CONFLICT.alreadyExistsFolder;
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(string3, this.getID(), cONFLICT));
        }
        File file2 = this.dl.aF();
        if (!file2.renameTo(file)) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.getID(), null, DriveOperationConflictException.CONFLICT.writeProtected));
        }
        @Nonnull String string4 = this.dl.b(file2);
        this.dl.aH().s(string4);
        string4 = this.dl.b(file);
        this.id = null;
        this.dl = this.dl.aH().r(string4);
    }

    @Override
    @Nonnull
    public String getPath() {
        String string = this.dl.b(this.dl.aF());
        return string.startsWith(this.dn) ? string.substring(this.dn.length()) : string;
    }

    @Override
    @Nonnull
    public String getID() {
        String string = this.id;
        if (string != null) {
            return string;
        }
        @Nonnull String string2 = this.getPath();
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        this.id = string = MountUtils.getIDForPath(string2);
        return string;
    }

    @Override
    public long getLastModified() throws DriveIOException {
        return this.dl.aF().lastModified();
    }

    @Override
    public boolean exists() {
        return this.dl.aF().exists();
    }

    @Override
    public boolean hasFeature(@Nonnull Class<? extends DriveFeature> type) throws DriveIOException {
        if (type == MetaData.class || type == Synchronization.class || type == Capabilities.class) {
            return true;
        }
        if (type == Folder.class) {
            return this.dl.aF().isDirectory();
        }
        if (type == Content.class || type == RandomAccess.class) {
            return this.dl.aF().isFile();
        }
        return false;
    }

    @Override
    @Nullable
    public <T extends DriveFeature> T getFeature(@Nonnull Class<T> type) throws DriveIOException {
        if (type == MetaData.class) {
            return (T)this.dm;
        }
        if (type == Synchronization.class) {
            return (T)new i(this.dl);
        }
        if (type == Capabilities.class) {
            return (T)new a(this.dl);
        }
        if (type == Folder.class && this.dl.aF().isDirectory()) {
            return (T)new e(this.dl, this.getID(), this.dn);
        }
        if (type == Content.class && this.dl.aF().isFile()) {
            return (T)new b(this.dl.aF(), this.getID());
        }
        if (type == RandomAccess.class && this.dl.aF().isFile()) {
            return (T)new h(this.dl.aF());
        }
        return null;
    }

    @Override
    @Nullable
    public DriveEntry getParent() {
        File file = this.dl.aF();
        if (file.equals(this.dl.aG())) {
            return null;
        }
        File file2 = file.getParentFile();
        d.a a2 = this.dl.aH().q(this.dl.b(file2));
        return new c(a2, this.dn);
    }

    @Override
    public void delete(@Nullable OperationProgressListener listener) throws DriveOperationConflictException {
        File file = this.dl.aF();
        if (!file.exists()) {
            throw DriveOperationConflictException.createSingleConflictException(true, new DriveOperationConflictException.SingleEntryConflict(this.getID(), null, DriveOperationConflictException.CONFLICT.sourceNotFound));
        }
        if (!IOFunctions.deleteDir((File)file)) {
            throw DriveOperationConflictException.createSingleConflictException(true, new DriveOperationConflictException.SingleEntryConflict(this.getID(), null, DriveOperationConflictException.CONFLICT.writeProtected));
        }
        if (file.exists()) {
            throw DriveOperationConflictException.createSingleConflictException(true, new DriveOperationConflictException.SingleEntryConflict(this.getID(), null, DriveOperationConflictException.CONFLICT.writeProtected));
        }
        this.dl.aH().s(this.dl.b(file));
    }

    @Override
    @Nullable
    public <T> T getMetaData(@Nonnull @Nonnull MetaKey<@Nonnull T> key) {
        return this.dm.getMetaData(key);
    }
}

