/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.data;

import com.inet.annotations.JsonData;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.webgui.server.a;
import com.inet.drive.webgui.server.data.ConflictResolveRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonData
public class MultipleEntriesRequest
extends ConflictResolveRequest {
    private String parentID;
    private Set<String> ids;

    protected MultipleEntriesRequest() {
    }

    @Nonnull
    public List<DriveEntry> getSelectedEntries(boolean useParentFallback, boolean ignoreConflicts) throws DriveOperationConflictException {
        Set<String> set = this.getIds();
        Drive drive = a.du();
        ArrayList<DriveEntry> arrayList = new ArrayList<DriveEntry>();
        if (set.isEmpty() && useParentFallback) {
            set.add(this.parentID);
        }
        @Nonnull ArrayList<@Nonnull DriveOperationConflictException.SingleEntryConflict> arrayList2 = new ArrayList<DriveOperationConflictException.SingleEntryConflict>();
        for (String string : set) {
            if (string == null) continue;
            DriveEntry driveEntry = drive.resolve(string);
            if (driveEntry != null) {
                arrayList.add(driveEntry);
                continue;
            }
            if (this.getSkipIDs() != null && this.getSkipIDs().contains(string)) continue;
            arrayList2.add(new DriveOperationConflictException.SingleEntryConflict(string, DriveOperationConflictException.CONFLICT.sourceNotFound));
        }
        if (!arrayList2.isEmpty() && !ignoreConflicts) {
            throw new DriveOperationConflictException(false, arrayList2);
        }
        return arrayList;
    }

    @Nonnull
    public Set<String> getIds() {
        HashSet hashSet = this.ids;
        return hashSet != null ? hashSet : new HashSet();
    }
}

