/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.maintenance.handler;

import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.server.maintenance.data.DriveCleanupPreviewRequest;
import com.inet.drive.server.maintenance.data.DriveCleanupPreviewResponse;
import com.inet.drive.server.maintenance.data.DriveHomeFolderInfo;
import com.inet.drive.server.search.a;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.maintenance.api.MaintenanceHandler;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class d
extends MaintenanceHandler<DriveCleanupPreviewRequest, DriveCleanupPreviewResponse> {
    public String getMethodName() {
        return "maintenance_drivecleanup_preview";
    }

    public DriveCleanupPreviewResponse a(DriveCleanupPreviewRequest driveCleanupPreviewRequest) throws ClientMessageException {
        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
            List<String> list = driveCleanupPreviewRequest.isAbandonedOnly() ? this.aC() : this.aB();
            int n2 = list.size();
            List<String> list2 = list.subList(Math.min(driveCleanupPreviewRequest.getOffset(), n2), Math.min(n2, driveCleanupPreviewRequest.getOffset() + driveCleanupPreviewRequest.getBlockSize()));
            List<DriveHomeFolderInfo> list3 = this.e(list2);
            DriveCleanupPreviewResponse driveCleanupPreviewResponse = new DriveCleanupPreviewResponse(list3, driveCleanupPreviewRequest.isReset(), driveCleanupPreviewRequest.getPreviewCounter(), n2);
            return driveCleanupPreviewResponse;
        }
    }

    private List<DriveHomeFolderInfo> e(List<String> list) {
        Drive drive = Drive.getInstance();
        ArrayList<DriveHomeFolderInfo> arrayList = new ArrayList<DriveHomeFolderInfo>();
        for (String string : list) {
            DriveEntry driveEntry = drive.resolve(string);
            if (driveEntry == null) continue;
            GUID gUID = null;
            MetaData metaData = driveEntry.getFeature(DriveEntry.META_DATA);
            if (metaData != null) {
                gUID = metaData.getMetaData(MetaData.HOMEFOLDER);
            }
            long l2 = this.g(gUID);
            arrayList.add(new DriveHomeFolderInfo(string, gUID, l2));
        }
        return arrayList;
    }

    private long g(@Nullable GUID gUID) {
        if (gUID == null) {
            return -1L;
        }
        Drive drive = Drive.getInstance();
        IndexSearchEngine<String> indexSearchEngine = a.bK().bM();
        SearchExpression searchExpression = this.h(gUID);
        Set set = indexSearchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{searchExpression}));
        AtomicLong atomicLong = new AtomicLong(0L);
        for (String string : set) {
            Optional.ofNullable(drive.resolve(string)).map(driveEntry -> driveEntry.getFeature(DriveEntry.META_DATA)).map(metaData -> metaData.getMetaData(MetaData.SIZE)).ifPresent(number -> atomicLong.addAndGet(number.longValue()));
        }
        return atomicLong.get();
    }

    private List<String> aB() {
        IndexSearchEngine<String> indexSearchEngine = a.bK().bM();
        ArrayList<String> arrayList = new ArrayList<String>(indexSearchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{this.aD()})));
        arrayList.sort(Comparator.naturalOrder());
        return arrayList;
    }

    private List<String> aC() {
        Drive drive = Drive.getInstance();
        IndexSearchEngine<String> indexSearchEngine = a.bK().bM();
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        IndexSearchEngine indexSearchEngine2 = userManager.getSearchEngine();
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = indexSearchEngine.simpleSearch(new SearchCommand(new SearchExpression[]{this.aD()}));
        for (String string : set) {
            Optional.ofNullable(drive.resolve(string)).map(driveEntry -> driveEntry.getFeature(DriveEntry.META_DATA)).map(metaData -> metaData.getMetaData(MetaData.HOMEFOLDER)).ifPresent(gUID -> {
                UserAccount userAccount;
                SearchCommand searchCommand = new SearchCommand("useraccountid", SearchCondition.SearchTermOperator.Equals, (Object)gUID.toString());
                Set set = indexSearchEngine2.simpleSearch(searchCommand);
                if (set.isEmpty() && (userAccount = userManager.getUserAccount(gUID)) == null) {
                    arrayList.add(string);
                }
            });
        }
        arrayList.sort(Comparator.naturalOrder());
        return arrayList;
    }

    private SearchExpression aD() {
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.HOMEFOLDER.getSearchTag().getTag(), SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.PATH.getSearchTag().getTag(), SearchCondition.SearchTermOperator.Equals, (Object)"Home/"));
        return andSearchExpression;
    }

    private SearchExpression h(@Nonnull GUID gUID) {
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.HOMEFOLDER.getSearchTag().getTag(), SearchCondition.SearchTermOperator.Equals, (Object)gUID.toString()));
        andSearchExpression.add((SearchExpression)new SearchCondition(MetaData.SIZE.getSearchTag().getTag(), SearchCondition.SearchTermOperator.GT, (Object)0));
        return andSearchExpression;
    }

    public /* synthetic */ Object invoke(Object object) throws ClientMessageException {
        return this.a((DriveCleanupPreviewRequest)object);
    }
}

