/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.google;

import com.inet.annotations.JsonData;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
class GoogleResourceResponse {
    private String id;
    private String name;
    private String mimeType;
    private String modifiedTime;
    private long size;
    private transient long parsedModifiedTime;
    private String[] parents;
    private Capabilities capabilities = new Capabilities();
    private long syncTime = System.currentTimeMillis();

    GoogleResourceResponse() {
    }

    @Nonnull
    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    @Nullable
    String getMimeType() {
        return this.mimeType;
    }

    long getModifiedTime() {
        if (this.parsedModifiedTime == 0L) {
            try {
                this.parsedModifiedTime = Instant.parse(this.modifiedTime).getEpochSecond() * 1000L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.parsedModifiedTime;
    }

    long getSize() {
        return this.size;
    }

    void setParent(@Nonnull String parent) {
        this.parents = new String[]{parent};
    }

    String getParent() {
        return this.parents != null && this.parents.length > 0 ? this.parents[0] : null;
    }

    boolean canWrite(boolean isFolder) {
        return this.capabilities != null && this.capabilities.canWrite(isFolder);
    }

    boolean canRead() {
        return this.capabilities != null && this.capabilities.canRead();
    }

    @Nonnull
    com.inet.drive.api.feature.Capabilities getCapabilities() {
        return this.capabilities;
    }

    long getSyncTime() {
        return this.syncTime;
    }

    @JsonData
    static class Capabilities
    implements com.inet.drive.api.feature.Capabilities {
        private boolean canDownload;
        private boolean canDelete;
        private boolean canRename;
        private boolean canModifyContent;
        private boolean canListChildren;
        private boolean canRemoveChildren;
        private boolean canAddChildren;

        public boolean canWrite(boolean isFolder) {
            if (isFolder) {
                return this.canDelete && this.canListChildren && this.canAddChildren && this.canRename && this.canModifyContent && this.canRemoveChildren;
            }
            return this.canDelete && this.canRename && this.canModifyContent;
        }

        public boolean canRead() {
            return this.canDownload;
        }

        @Override
        public boolean canReadContent() {
            return this.canDownload;
        }

        @Override
        public boolean canModifyContent() {
            return this.canModifyContent;
        }

        @Override
        public boolean canCopy() {
            return true;
        }

        @Override
        public boolean canMove() {
            return true;
        }

        @Override
        public boolean canRename() {
            return this.canRename;
        }

        @Override
        public boolean canShare() {
            return true;
        }

        @Override
        public boolean canDelete() {
            return this.canDelete;
        }

        @Override
        public boolean canAddChildren() {
            return this.canAddChildren;
        }

        @Override
        public boolean canListChildren() {
            return this.canListChildren;
        }

        @Override
        public boolean canDeleteChildren() {
            return this.canRemoveChildren;
        }
    }
}

