/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.feature;

import com.inet.annotations.JsonData;
import com.inet.drive.api.DriveIDUtils;
import com.inet.id.GUID;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class ShareAnonymLink {
    @Nonnull
    private String id;
    @Nonnull
    private List<String> permissions;
    private long creationTime;
    @Nullable
    private String password;
    private long expirationTime;
    @Nonnull
    private GUID owner;
    @Nonnull
    private String entryID;

    private ShareAnonymLink() {
    }

    public ShareAnonymLink(@Nonnull String linkID, @Nonnull GUID owner, @Nonnull String entryID, @Nonnull List<String> permissions, long creationTime, @Nullable String password, long expirationTime) {
        this.entryID = entryID;
        this.id = linkID;
        this.owner = owner;
        this.permissions = permissions;
        this.creationTime = creationTime;
        this.password = password;
        this.setExpirationTime(expirationTime);
        if (DriveIDUtils.getSharedRootID(this.id) == null || !DriveIDUtils.isID(DriveIDUtils.getSharedRootID(this.id))) {
            throw new RuntimeException("Shared ID is not valid -> \"" + this.id + "\"");
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public long getExpirationTime() {
        if (this.expirationTime <= 0L) {
            return 0L;
        }
        return this.expirationTime;
    }

    @Nonnull
    public List<String> getPermissions() {
        return this.permissions;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public GUID getOwner() {
        return this.owner;
    }

    public void setPermissions(@Nonnull List<String> permissions) {
        this.permissions = permissions;
    }

    public void setPassword(@Nullable String password) {
        this.password = password;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime <= 0L ? 0L : expirationTime;
    }

    @Nonnull
    public String getDriveEntryID() {
        return this.entryID;
    }

    public boolean isExpired() {
        if (this.expirationTime <= 0L) {
            return false;
        }
        return System.currentTimeMillis() > this.getExpirationTime();
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShareAnonymLink)) {
            return false;
        }
        ShareAnonymLink shareAnonymLink = (ShareAnonymLink)obj;
        return Objects.equals(this.id, shareAnonymLink.id);
    }

    public final boolean equalsObject(Object o2) {
        if (!(o2 instanceof ShareAnonymLink)) {
            return false;
        }
        ShareAnonymLink shareAnonymLink = (ShareAnonymLink)o2;
        return this.creationTime == shareAnonymLink.creationTime && this.expirationTime == shareAnonymLink.expirationTime && this.id.equals(shareAnonymLink.id) && Objects.equals(this.permissions, shareAnonymLink.permissions) && Objects.equals(this.password, shareAnonymLink.password) && this.owner.equals((Object)shareAnonymLink.owner) && this.entryID.equals(shareAnonymLink.entryID);
    }
}

