/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.events;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;

@JsonData
public class ProgressEvent {
    private int fraction;
    private int total;
    private String headingLabel;
    private String progressLabel;
    private String progressBarLabel;
    private STATE state = STATE.started;
    private String identifier;

    public ProgressEvent(String taskID, String progressLabel, String progressBarLabel, int fraction, int total, STATE state) {
        this.progressLabel = progressLabel;
        this.progressBarLabel = progressBarLabel;
        this.fraction = fraction;
        this.total = total;
        this.state = state;
        this.identifier = taskID;
    }

    public String getTaskID() {
        return this.getIdentifier();
    }

    public STATE getState() {
        return this.state;
    }

    public int getFraction() {
        return this.fraction;
    }

    public String getProgressLabel() {
        return this.progressLabel;
    }

    public String toString() {
        return String.valueOf((Object)this.state) + ", " + this.progressLabel + ", " + this.fraction + " of " + this.getTotal();
    }

    public int getTotal() {
        return this.total;
    }

    public String getProgressBarLabel() {
        return this.progressBarLabel;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @InternalApi
    public static final class STATE
    extends Enum<STATE> {
        public static final /* enum */ STATE started = new STATE();
        public static final /* enum */ STATE running = new STATE();
        public static final /* enum */ STATE finished = new STATE();
        public static final /* enum */ STATE canceled = new STATE();
        public static final /* enum */ STATE conflicts = new STATE();
        public static final /* enum */ STATE error = new STATE();
        private static final /* synthetic */ STATE[] ji;

        public static STATE[] values() {
            return (STATE[])ji.clone();
        }

        public static STATE valueOf(String name) {
            return Enum.valueOf(STATE.class, name);
        }

        private static /* synthetic */ STATE[] dN() {
            return new STATE[]{started, running, finished, canceled, conflicts, error};
        }

        static {
            ji = STATE.dN();
        }
    }
}

