/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.data;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.server.persistence.i;
import com.inet.drive.webgui.server.data.CapabilitiesData;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class DriveGuiEntry {
    @Nonnull
    private a type;
    @Nonnull
    private String name;
    @Nullable
    private String title;
    @Nonnull
    private String mimeKey;
    private boolean writable;
    @Nullable
    private CapabilitiesData capabilities;
    @Nullable
    private Long size;
    @Nonnull
    private String id;
    @Nonnull
    private String lastmodified;
    private List<Integer> activeExtensions;
    private int defaultAction = -1;
    private long thumbSmallID = -1L;
    private long thumbLargeID = -1L;
    @Nullable
    private Map<String, Object> pluginMetaData;
    @JsonExcludeNull
    private String passwordRequired = null;

    private DriveGuiEntry(@Nonnull a type, @Nonnull String name, @Nonnull String id, @Nullable Long size, @Nonnull String lastmodified, long thumbSmallID, long thumbLargeID) {
        int n2;
        this.type = type;
        this.name = name;
        this.id = id;
        this.size = size;
        this.lastmodified = lastmodified;
        this.mimeKey = type == a.iJ ? ((n2 = name.lastIndexOf(46)) >= 0 ? name.substring(n2 + 1) : type.name().toLowerCase()) : type.name().toLowerCase();
        this.thumbSmallID = thumbSmallID;
        this.thumbLargeID = thumbLargeID;
    }

    public DriveGuiEntry(@Nonnull String name, @Nonnull String id, @Nullable Long size, @Nonnull String lastmodified, long thumbSmallID, long thumbLargeID) {
        this(a.iJ, name, id, size, lastmodified, thumbSmallID, thumbLargeID);
    }

    public void setMimeKey(@Nonnull String mimeKey) {
        this.mimeKey = mimeKey;
    }

    public DriveGuiEntry(@Nonnull String name, @Nonnull String id, @Nonnull String lastmodified, @Nonnull a type, long thumbSmallID, long thumbLargeID) {
        this(type, name, id, null, lastmodified, thumbSmallID, thumbLargeID);
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public void setPasswordRequired() {
        this.passwordRequired = "true";
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    @Nonnull
    public a getType() {
        return this.type;
    }

    public void setType(@Nonnull a type) {
        this.type = type;
        if (type != a.iJ) {
            this.size = -1L;
        }
        if (type == a.iJ) {
            int n2 = this.name.lastIndexOf(46);
            if (n2 >= 0) {
                this.mimeKey = this.name.substring(n2 + 1);
            }
        } else {
            this.mimeKey = type.name().toLowerCase();
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public Long getSize() {
        return this.size;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getLastmodified() {
        return this.lastmodified;
    }

    public void setActiveExtensions(List<Integer> activeExtensions, Integer defaultAction) {
        this.activeExtensions = activeExtensions;
        this.defaultAction = defaultAction != null ? defaultAction : -1;
    }

    public void setWritable(boolean isWritable) {
        this.writable = isWritable;
    }

    public void setCapabilities(@Nullable CapabilitiesData capabilities) {
        this.capabilities = capabilities;
    }

    @Nonnull
    public String toString() {
        return String.valueOf((Object)this.type) + " " + this.name;
    }

    @Nullable
    public void setPluginMetaData(@Nullable Map<String, Object> pluginMetaData) {
        this.pluginMetaData = pluginMetaData;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a iJ = new a(5);
        public static final /* enum */ a iK = new a(2);
        public static final /* enum */ a iL = new a(3);
        public static final /* enum */ a iM = new a(2);
        public static final /* enum */ a iN = new a(4);
        public static final /* enum */ a iO = new a(4);
        public static final /* enum */ a iP = new a(3);
        public static final /* enum */ a iQ = new a(1);
        private int iR;
        private static final /* synthetic */ a[] iS;

        public static a[] values() {
            return (a[])iS.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(int n3) {
            this.iR = n3;
        }

        public int dE() {
            return this.iR;
        }

        @Nonnull
        public static a w(DriveEntry driveEntry) {
            boolean bl = false;
            @Nonnull a a2 = iJ;
            try {
                a2 = driveEntry.executeFeatureNN(Mount.class, mount -> mount.isLinkRoot() ? iN : iJ, () -> iJ);
                if (driveEntry.hasFeature(Content.class)) {
                    a2 = iJ;
                } else if (driveEntry.hasFeature(Folder.class)) {
                    Mount mount2;
                    @Nonnull String string = driveEntry.getID();
                    if ("Drive".equals(string)) {
                        return iM;
                    }
                    if ("SharedWithMe".equals(string)) {
                        return iP;
                    }
                    if (string.startsWith("s_")) {
                        return iL;
                    }
                    if ("Home".equals(driveEntry.getName()) && driveEntry.hasFeature(MetaData.class) && (mount2 = driveEntry.getMetaData(MetaData.HOMEFOLDER)) != null && mount2.equals(UserManager.getInstance().getCurrentUserAccountID()) && "Drive".equals(driveEntry.getMetaData(MetaData.PARENT_ID))) {
                        return iK;
                    }
                    for (mount2 = driveEntry.getFeature(DriveEntry.MOUNT); mount2 != null && mount2.getChild() != null; mount2 = mount2.getChild()) {
                    }
                    a2 = mount2 != null && mount2.isLinkRoot() ? iN : iL;
                }
            }
            catch (MountManager.a a3) {
                DrivePlugin.LOGGER.info((Object)a3);
                a2 = iO;
                bl = true;
            }
            catch (DriveIOException driveIOException) {
                DrivePlugin.LOGGER.info((Object)driveIOException);
                bl = true;
            }
            catch (AccessDeniedException accessDeniedException) {
                DrivePlugin.LOGGER.info((Object)accessDeniedException);
                bl = true;
                a2 = iO;
            }
            catch (Throwable throwable) {
                DrivePlugin.LOGGER.info((Object)throwable);
                a2 = iJ;
            }
            if (driveEntry instanceof i) {
                a2 = bl ? iO : iN;
            }
            return a2;
        }

        private static /* synthetic */ a[] dG() {
            return new a[]{iJ, iK, iL, iM, iN, iO, iP, iQ};
        }

        static {
            iS = a.dG();
        }
    }
}

