/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.search;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.ShareAnonymLink;
import com.inet.drive.api.feature.ShareData;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.i;
import com.inet.drive.server.search.c;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.lib.i18n.DisplayableKey;
import com.inet.lib.i18n.DisplayableMapCache;
import com.inet.plugin.NamedExtension;
import com.inet.plugin.veto.VetoPower;
import com.inet.plugin.veto.VetoType;
import com.inet.search.AbstractSearchDataCache;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.tokenizers.GuidTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.search.veto.UserSearchIndexVetoPower;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
implements DriveObserver {
    private IndexSearchEngine<String> fD;
    private final b fE = new b();
    private static a fF;
    public static final VetoType fG;
    private static SearchIndexVeto fH;
    public static final SearchTag fI;
    private static DisplayableKey<Integer> fJ;
    private static DisplayableKey<Integer> fK;
    private static DisplayableKey<Integer>[] fL;
    public static final SearchTag fM;
    public static final SearchTag fN;
    public static final SearchTag fO;
    public static final SearchTag fP;
    private static UserSearchIndexVetoPower fQ;

    public static VetoPower bJ() {
        return fQ;
    }

    public static a bK() {
        if (fF == null) {
            fF = new a();
        }
        return fF;
    }

    public a() {
        this("drive");
    }

    public a(String string) {
        try {
            this.fD = new IndexSearchEngine(string, this.bL(), true, String.class, false);
            for (MetaKey<?> metaKey : c.bR()) {
                if (metaKey.getSearchTag() == null) continue;
                this.fD.addTag(metaKey.getSearchTag());
            }
            this.fD.addTag(fI);
            this.fD.addTag(fP);
            this.fD.addTag(fO);
            this.fD.addTag(fN);
            this.fD.addTag(fM);
            this.fD.setPrimaryTag(Objects.requireNonNull(MetaData.ID.getSearchTag()));
            fH.setStatusToStartingInitOfIndex(this.fD);
            this.fD.setData((SearchDataCache)this.fE);
            fH.setStatusToFinishedInitOfIndex();
        }
        catch (IOException iOException) {
            fH.setStatusToFailedInitOfIndex();
            ErrorCode.throwAny((Throwable)iOException);
        }
    }

    public String bL() {
        StringBuilder stringBuilder = new StringBuilder();
        List<DriveFileTypeHandler> list = DriveUtils.getDriveTypeHandler();
        list.sort(Comparator.comparing(NamedExtension::getExtensionName));
        for (DriveFileTypeHandler driveFileTypeHandler : list) {
            stringBuilder.append(driveFileTypeHandler.getExtensionName());
        }
        return stringBuilder.toString();
    }

    public IndexSearchEngine<String> bM() {
        return this.fD;
    }

    @Override
    public boolean isValid() {
        return this.fE.isValid();
    }

    @Override
    public <T> void changed(@Nonnull DriveObserver.EventType<T> type, @Nonnull T eventData) {
        this.fE.changed(type, eventData);
    }

    @Nullable
    private static String b(@Nonnull com.inet.drive.api.feature.c c2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ShareData shareData = c2.w();
        if (shareData != null) {
            arrayList.add(shareData.getId());
        }
        List<ShareAnonymLink> list = c2.y();
        for (ShareAnonymLink shareAnonymLink : list) {
            arrayList.add(shareAnonymLink.getId());
        }
        Collections.sort(arrayList);
        if (arrayList.isEmpty()) {
            return null;
        }
        return Arrays.toString(arrayList.toArray(new String[0]));
    }

    static {
        fG = new VetoType("searchindex", 401);
        fH = new SearchIndexVeto("Drive Search Index");
        fI = new SearchTag("PRIVATEFOLDER", SearchDataType.ID, false, (SearchTokenizer)new GuidTokenizer(), 0);
        fJ = new DisplayableKey<Integer>(){

            public Integer bP() {
                return 1;
            }

            public String getDisplayName() {
                return DrivePlugin.MSG_SERVER.getMsg("drive.sharing.tag.yes", new Object[0]);
            }

            public /* synthetic */ Comparable getKey() {
                return this.bP();
            }
        };
        fK = new DisplayableKey<Integer>(){

            public Integer bP() {
                return 0;
            }

            public String getDisplayName() {
                return DrivePlugin.MSG_SERVER.getMsg("drive.sharing.tag.no", new Object[0]);
            }

            public /* synthetic */ Comparable getKey() {
                return this.bP();
            }
        };
        fL = new DisplayableKey[]{fK, fJ};
        fM = new SearchTag("SHARED", SearchDataType.IntegerMap, false, 0, () -> DrivePlugin.MSG_SERVER.getMsg("drive.sharing.tag", new Object[0])){

            public Map<Integer, String> getMapData() {
                return DisplayableMapCache.getMap(fL, fL, (int)fL.length);
            }
        };
        fN = new SearchTag("SHARE_IDS", SearchDataType.String, false, (SearchTokenizer)TextSearchTokenizer.DEFAULT, 0);
        fO = new SearchTag("SHARE_USER_IDS", SearchDataType.ID, false, (SearchTokenizer)new a(), 0){

            public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
                for (String string : (Collection)val) {
                    if (!super.isPhraseContainsIn(normalizePhrase, (Object)string)) continue;
                    return true;
                }
                return false;
            }
        };
        fP = new SearchTag("SHARE_GROUP_IDS", SearchDataType.ID, false, (SearchTokenizer)new a(), 0){

            public boolean isPhraseContainsIn(String normalizePhrase, Object val) {
                for (String string : (Collection)val) {
                    if (!super.isPhraseContainsIn(normalizePhrase, (Object)string)) continue;
                    return true;
                }
                return false;
            }
        };
        fQ = new UserSearchIndexVetoPower(fH, () -> a.bK()){

            @Nonnull
            public VetoType getType() {
                return fG;
            }
        };
    }

    static class b
    extends AbstractSearchDataCache<String>
    implements DriveObserver {
        private DriveEntry fR;

        @Nullable
        public Map<String, Object> F(String string) {
            try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                DriveEntry driveEntry = ((com.inet.drive.server.a)com.inet.drive.webgui.server.a.du()).e(string);
                if (driveEntry == null) {
                    Map<String, Object> map = null;
                    return map;
                }
                Map<String, Object> map = this.l(driveEntry);
                return map;
            }
        }

        private Map<String, Object> l(@Nonnull DriveEntry driveEntry) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            try {
                Collection<ShareAnonymLink> collection;
                List<MetaKey<?>> list;
                MetaData metaData = driveEntry.getFeature(MetaData.class);
                if (metaData != null) {
                    list = c.bR();
                    if (driveEntry.hasFeature(DriveEntry.MOUNT)) {
                        list = e.es;
                    }
                    for (MetaKey object : list) {
                        if (!object.isUseInSearch() || "privilegedaccount".equalsIgnoreCase((collection = metaData.getMetaData(object)) == null ? "" : collection.toString())) continue;
                        hashMap.put(object.getKey(), collection);
                    }
                }
                if ((list = driveEntry.getFeature(DriveEntry.SHARE)) != null) {
                    Set<GUID> set;
                    ArrayList arrayList = new ArrayList();
                    ShareData shareData = list.w();
                    if (shareData != null) {
                        arrayList.add(shareData.getId());
                        arrayList.add(shareData.getId());
                        collection = shareData.getPermissions(true).keySet();
                        if (!collection.isEmpty()) {
                            hashMap.put(fP.getTag(), new ArrayList<ShareAnonymLink>(collection));
                        }
                        if (!(set = shareData.getPermissions(false).keySet()).isEmpty()) {
                            hashMap.put(fO.getTag(), new ArrayList<GUID>(set));
                        }
                    }
                    collection = list.y();
                    for (ShareAnonymLink shareAnonymLink : collection) {
                        arrayList.add(shareAnonymLink.getId());
                    }
                    Collections.sort(arrayList);
                    set = a.b(list);
                    if (set != null) {
                        hashMap.put(fN.getTag(), set);
                        hashMap.put(fM.getTag(), 1);
                    } else {
                        hashMap.put(fM.getTag(), 0);
                    }
                }
            }
            catch (Throwable throwable) {
                DrivePlugin.LOGGER.debug("Search Index couldn't updated for " + String.valueOf(driveEntry), (Object)throwable);
            }
            return hashMap;
        }

        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private final ArrayDeque<DriveEntry> fS = new ArrayDeque();
                private DriveEntry fT;
                {
                    if (fR == null) {
                        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                            fR = com.inet.drive.webgui.server.a.du().resolve("Drive");
                        }
                    }
                    this.fS.add(fR);
                }

                @Override
                public boolean hasNext() {
                    if (this.fT != null) {
                        return true;
                    }
                    if (this.fS.isEmpty()) {
                        return false;
                    }
                    DriveEntry driveEntry = this.fS.pop();
                    while (driveEntry != null) {
                        try (UserAccountScope userAccountScope = UserAccountScope.createPrivileged();){
                            Folder folder;
                            com.inet.drive.api.feature.b b2 = driveEntry.getFeature(DriveEntry.INDEX);
                            if (b2 != null) {
                                b2.refreshMetaData();
                            }
                            if ((folder = driveEntry.getFeature(Folder.class)) == null || driveEntry.hasFeature(DriveEntry.MOUNT)) break;
                            this.fS.addAll(folder.getChildren());
                            break;
                        }
                        catch (Throwable throwable) {
                            DrivePlugin.LOGGER.error(throwable);
                            driveEntry = this.fS.poll();
                        }
                    }
                    this.fT = driveEntry;
                    return driveEntry != null;
                }

                public String bQ() {
                    if (this.hasNext()) {
                        try {
                            String string;
                            block10: {
                                UserAccountScope userAccountScope = UserAccountScope.createPrivileged();
                                try {
                                    string = this.fT.getID();
                                    if (userAccountScope == null) break block10;
                                }
                                catch (Throwable throwable) {
                                    if (userAccountScope != null) {
                                        try {
                                            userAccountScope.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                userAccountScope.close();
                            }
                            return string;
                        }
                        finally {
                            this.fT = null;
                        }
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.bQ();
                }
            };
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public <T> void changed(@Nonnull DriveObserver.EventType<T> type, @Nonnull T eventData) {
            block21: {
                DriveObserver.EventType.a a2;
                DriveEntry driveEntry;
                com.inet.drive.api.feature.c c2;
                block24: {
                    SearchDataCacheChangeListener[] searchDataCacheChangeListenerArray;
                    int n2;
                    int n3;
                    block23: {
                        block22: {
                            block20: {
                                SearchDataCacheChangeListener[] searchDataCacheChangeListenerArray2;
                                IndexSearchEngine.LOGGER.debug((Object)("Drive Index Receive " + type.getKey() + " Event"));
                                if (type != DriveObserver.EventType.CREATED) break block20;
                                DriveEntry driveEntry2 = (DriveEntry)eventData;
                                if (DriveIDUtils.hasMoreIDs(driveEntry2.getID())) break block21;
                                if (driveEntry2 instanceof i && !"PERSISTENCE_PROVIDER".equals((searchDataCacheChangeListenerArray2 = (SearchDataCacheChangeListener[])eventData).getDescription().getProvider())) {
                                    return;
                                }
                                for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                                    Map<String, Object> map = this.l(driveEntry2);
                                    searchDataCacheChangeListener.entryAdded((Object)driveEntry2.getID(), map);
                                }
                                break block21;
                            }
                            if (type != DriveObserver.EventType.REMOVED) break block22;
                            String string = ((DriveObserver.EventType.RemoveEvent)eventData).getId();
                            for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                                searchDataCacheChangeListener.entryRemovedCompletely((Object)string);
                            }
                            break block21;
                        }
                        if (type != DriveObserver.EventType.MODIFIED) break block23;
                        DriveObserver.EventType.MetaDataChange metaDataChange = (DriveObserver.EventType.MetaDataChange)eventData;
                        if (!e.A(metaDataChange.getID())) break block21;
                        for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                            if (metaDataChange.getNewValue() == null) {
                                searchDataCacheChangeListener.entryChanged((Object)metaDataChange.getID(), Collections.singletonMap(metaDataChange.getMetaKey().getKey(), metaDataChange.getOldValue()), Collections.EMPTY_MAP);
                                continue;
                            }
                            Map<String, Object> map = Collections.EMPTY_MAP;
                            if (metaDataChange.getOldValue() != null) {
                                map = Collections.singletonMap(metaDataChange.getMetaKey().getKey(), metaDataChange.getOldValue());
                            }
                            searchDataCacheChangeListener.entryChanged((Object)metaDataChange.getID(), map, Collections.singletonMap(metaDataChange.getMetaKey().getKey(), metaDataChange.getNewValue()));
                            if (!MetaData.CREATOR_ID.getKey().equals(metaDataChange.getMetaKey().getKey())) continue;
                            searchDataCacheChangeListener.entryRemoved((Object)metaDataChange.getID(), Collections.singletonMap(fI.getTag(), metaDataChange.getNewValue()));
                        }
                        if (MetaData.CREATOR_ID.getKey().equals(metaDataChange.getMetaKey().getKey())) {
                            this.changed(DriveObserver.EventType.PERMISSION, com.inet.drive.webgui.server.a.du().resolve(metaDataChange.getID()));
                        }
                        break block21;
                    }
                    if (type != DriveObserver.EventType.PERMISSION) break block24;
                    DriveEntry driveEntry3 = (DriveEntry)eventData;
                    if (!e.k(driveEntry3)) break block21;
                    Map<GUID, Map<String, Boolean>> map = driveEntry3.getFeature(DriveEntry.PERMISSIONS).getPermissions(true);
                    Map<GUID, Map<String, Boolean>> map2 = driveEntry3.getFeature(DriveEntry.PERMISSIONS).getPermissions(false);
                    GUID gUID = driveEntry3.getMetaData(MetaData.CREATOR_ID);
                    if (map.isEmpty() && map2.size() == 1 && map2.containsKey(gUID) && (n3 = 0) < (n2 = (searchDataCacheChangeListenerArray = this.getListeners()).length)) {
                        SearchDataCacheChangeListener searchDataCacheChangeListener = searchDataCacheChangeListenerArray[n3];
                        searchDataCacheChangeListener.entryAdded((Object)driveEntry3.getID(), Collections.singletonMap(fI.getTag(), gUID));
                        return;
                    }
                    for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                        searchDataCacheChangeListener.entryRemoved((Object)driveEntry3.getID(), Collections.singletonMap(fI.getTag(), gUID));
                    }
                    break block21;
                }
                if (type == DriveObserver.EventType.SHARE && (c2 = (driveEntry = (a2 = (DriveObserver.EventType.a)eventData).getEntry()).getFeature(DriveEntry.SHARE)) != null) {
                    Set<GUID> set;
                    Collection<ShareAnonymLink> collection;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ShareData shareData = c2.w();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                    if (shareData != null) {
                        arrayList.add(shareData.getId());
                        collection = shareData.getPermissions(true).keySet();
                        if (!collection.equals(a2.j())) {
                            hashMap.put(fP.getTag(), new ArrayList<GUID>(a2.j()));
                            hashMap2.put(fP.getTag(), new ArrayList<ShareAnonymLink>(collection));
                        }
                        if (!(set = shareData.getPermissions(false).keySet()).equals(a2.k())) {
                            hashMap.put(fO.getTag(), new ArrayList<GUID>(a2.k()));
                            hashMap2.put(fO.getTag(), new ArrayList<GUID>(set));
                        }
                    }
                    collection = c2.y();
                    for (ShareAnonymLink searchDataCacheChangeListenerArray : collection) {
                        arrayList.add(searchDataCacheChangeListenerArray.getId());
                    }
                    set = new ArrayList(arrayList);
                    if (a2.h() == DriveObserver.EventType.a.a.A) {
                        set.add((GUID)a2.i());
                    }
                    if (a2.h() == DriveObserver.EventType.a.a.z) {
                        set.remove(a2.i());
                    }
                    Collections.sort(arrayList);
                    Collections.sort(set);
                    if (arrayList.size() == 0 && set.size() > 0 || arrayList.size() > 0 && set.size() == 0) {
                        Integer n2 = set.size() == 0 ? 0 : 1;
                        Integer n3 = arrayList.size() == 0 ? 0 : 1;
                        hashMap.put(fM.getTag(), n2);
                        hashMap2.put(fM.getTag(), n3);
                        hashMap.put(fN.getTag(), Arrays.toString(set.toArray((String[])new String[0])));
                        hashMap2.put(fN.getTag(), Arrays.toString(arrayList.toArray(new String[0])));
                    } else {
                        hashMap.put(fN.getTag(), Arrays.toString(set.toArray((String[])new String[0])));
                        hashMap2.put(fN.getTag(), Arrays.toString(arrayList.toArray(new String[0])));
                    }
                    if (!hashMap.isEmpty() || !hashMap2.isEmpty()) {
                        for (SearchDataCacheChangeListener searchDataCacheChangeListener : this.getListeners()) {
                            searchDataCacheChangeListener.entryChanged((Object)driveEntry.getID(), hashMap, hashMap2);
                        }
                    }
                }
            }
        }

        @Nullable
        public /* synthetic */ Map getCacheEntry(Object object) {
            return this.F((String)object);
        }
    }

    private static class a
    extends GuidTokenizer {
        private a() {
        }

        public Set<String> tokens(Object value, int type) {
            if (value instanceof Collection) {
                HashSet<String> hashSet = new HashSet<String>();
                Collection collection = (Collection)value;
                for (Object e2 : collection) {
                    hashSet.add(e2.toString());
                }
                return hashSet;
            }
            return super.tokens(value, type);
        }
    }
}

