/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DataEntry;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.LockException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.Capabilities;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Lock;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.server.persistence.PersistencePermissions;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.f;
import com.inet.drive.server.persistence.h;
import com.inet.drive.server.persistence.j;
import com.inet.drive.server.persistence.k;
import com.inet.drive.server.persistence.m;
import com.inet.drive.server.persistence.n;
import com.inet.drive.server.persistence.o;
import com.inet.drive.server.persistence.p;
import com.inet.drive.server.persistence.q;
import com.inet.drive.server.persistence.r;
import com.inet.error.BaseErrorCode;
import com.inet.error.ErrorCode;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class c
implements DriveEntry {
    private f eg;
    private com.inet.drive.server.persistence.b eh;
    private PersistencePermissions ei;
    private k ej;
    private o ek;
    private j el;
    private q em;
    private h en;
    private p eo;
    @Nonnull
    private final String id;
    private final HashSet<Class<? extends DriveFeature>> bi = new HashSet();
    private PersistenceEntry ep;
    private com.inet.drive.server.a dQ;
    private n eq;

    com.inet.drive.server.a C() {
        return this.dQ;
    }

    String u(@Nonnull String string) {
        return "/drive/" + e.y(string) + "/";
    }

    String aT() {
        return "/drive/" + e.y(this.getID()) + "/";
    }

    @Override
    @Nonnull
    public String getExtensionName() {
        return "Persistence";
    }

    PersistenceEntry aU() {
        return this.ep;
    }

    c(@Nonnull String string) {
        this.id = string;
        this.bi.add(THUMBNAIL);
        this.bi.add(REVISON);
        this.bi.add(PERMISSIONS);
        this.bi.add(LOCK);
        this.bi.add(LINK);
        this.bi.add(INDEX);
        this.bi.add(SHARE);
        UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
        if (userAccount == null) {
            throw new AccessDeniedException("No user is login", (ErrorCode)BaseErrorCode.UserNotLoggedIn);
        }
    }

    public c(@Nonnull String string, com.inet.drive.server.a a2) {
        this(string);
        this.ep = Persistence.getRecoveryEnabledInstance().resolve("/drive/" + e.y(string));
        this.dQ = a2;
        this.bi.add(META_DATA);
        if (com.inet.drive.server.persistence.b.a(this)) {
            this.bi.add(CONTENT);
            this.bi.add(RANDOMACCESS);
        }
        if (f.b(this)) {
            this.bi.add(FOLDER);
            this.bi.add(com.inet.drive.api.feature.a.class);
        }
        if ("Drive".equals(string)) {
            this.bi.add(Capabilities.class);
        }
    }

    j aV() {
        return (j)this.getFeature(LOCK);
    }

    @Override
    @Nonnull
    public String getDislayName() {
        if ("Drive".equals(this.getID())) {
            return DrivePlugin.MSG_SERVER.getMsg("drive.entry.root", new Object[0]);
        }
        return DriveEntry.super.getDislayName();
    }

    @Override
    @Nonnull
    public String getName() {
        this.C().getPermissionChecker().hasPermission(this.getID(), false, Permissions.READ_ACCESS);
        String string = this.getMetaData(MetaData.NAME);
        if (string == null) {
            if (DrivePlugin.LOGGER.isDebug()) {
                Thread.dumpStack();
                DrivePlugin.LOGGER.debug((Object)("ERROR: ID " + this.getID() + " does not have a name."));
            }
            return "ID" + this.getID();
        }
        return string;
    }

    boolean aj() {
        return this.a(true);
    }

    boolean a(boolean bl) {
        return this.a(bl, Permissions.READ_ACCESS);
    }

    boolean aW() {
        return this.b(true);
    }

    boolean b(boolean bl) {
        return this.a(bl, "EDITOR");
    }

    boolean a(boolean bl, String ... stringArray) {
        if (this.getID().equals("Drive") && UserManager.getInstance().getCurrentUserAccountID() != null) {
            for (String string : stringArray) {
                if (!"VIEWER".equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return this.C().getPermissionChecker().hasPermission(this.getID(), bl, stringArray);
    }

    @Override
    @Nonnull
    public String getPath() {
        this.aj();
        String string = this.getMetaData(MetaData.PATH);
        if (string == null) {
            if (DrivePlugin.LOGGER.isDebug()) {
                DrivePlugin.LOGGER.debug((Object)("ERROR: ID " + this.getID() + " does not have a path."));
            }
            return "ID" + this.getID();
        }
        return string;
    }

    @Override
    @Nonnull
    public String getID() {
        return this.id;
    }

    public String toString() {
        return this.getName() + " (" + this.getID() + ")";
    }

    @Override
    public long getLastModified() {
        this.aj();
        Long l2 = this.getMetaData(MetaData.MODIFIED);
        if (l2 == null) {
            return 0L;
        }
        return l2;
    }

    @Override
    public boolean exists() {
        return this.aX().exists();
    }

    @Override
    public boolean hasFeature(@Nonnull Class<? extends DriveFeature> type) {
        return this.bi.contains(type);
    }

    @Override
    @Nullable
    public <T extends DriveFeature> T getFeature(@Nonnull Class<T> type) {
        if (!this.hasFeature(type)) {
            return null;
        }
        if (type == FOLDER && this.hasFeature(FOLDER)) {
            if (this.eg == null) {
                this.eg = this.getID().equals("Drive") ? new r(this) : new f(this);
            }
            return (T)this.eg;
        }
        if (type == CONTENT && this.hasFeature(CONTENT)) {
            if (this.eh == null) {
                this.eh = new com.inet.drive.server.persistence.b(this);
            }
            return (T)this.eh;
        }
        if (type == RANDOMACCESS && this.hasFeature(RANDOMACCESS)) {
            if (this.eq == null) {
                this.eq = new n(this);
            }
            return (T)this.eq;
        }
        if (type == META_DATA) {
            if (this.ej == null) {
                this.ej = new k(this.id, this);
            }
            return (T)this.ej;
        }
        if (type == REVISON) {
            if (this.ek == null) {
                this.ek = new o(this);
            }
            return (T)this.ek;
        }
        if (type == PERMISSIONS) {
            if (this.ei == null) {
                this.ei = new PersistencePermissions(this);
            }
            return (T)this.ei;
        }
        if (type == THUMBNAIL) {
            if (this.em == null) {
                this.em = new q(this);
            }
            return (T)this.em;
        }
        if (type == LOCK) {
            if (this.el == null) {
                this.el = new j(this.id);
            }
            return (T)this.el;
        }
        if (type == LINK) {
            if (this.en == null && this.getFeature(FOLDER) != null) {
                this.en = new h(this, (f)this.getFeature(FOLDER));
            }
            return (T)this.en;
        }
        if (type == SHARE) {
            if (this.eo == null) {
                this.eo = new p(this);
            }
            return (T)this.eo;
        }
        if (type == INDEX) {
            return (T)((com.inet.drive.api.feature.b)() -> {
                if (m.a(UserManager.getInstance().getCurrentUserAccount()) && this.hasFeature(CONTENT)) {
                    if (this.eh == null) {
                        this.eh = new com.inet.drive.server.persistence.b(this);
                    }
                    this.eh.refreshMetaData();
                }
            });
        }
        if (type == Capabilities.class && this.bi.contains(Capabilities.class)) {
            return (T)new b();
        }
        return null;
    }

    @Override
    @Nullable
    public DriveEntry getParent() {
        this.aj();
        MetaData metaData = (MetaData)this.getFeature(META_DATA);
        if (metaData == null) {
            return null;
        }
        String string = metaData.getMetaData(MetaData.PARENT_ID);
        if (string == null) {
            return null;
        }
        return this.dQ.d(string.toString());
    }

    @Override
    public void delete(OperationProgressListener listener) throws DriveOperationConflictException {
        block30: {
            j j2;
            String string;
            int n2;
            List<DriveEntry> list;
            List<DriveEntry> list2;
            com.inet.drive.server.utils.c c2;
            block29: {
                c2 = listener instanceof com.inet.drive.server.utils.c ? (com.inet.drive.server.utils.c)listener : new com.inet.drive.server.utils.c(listener);
                if (!this.b(false)) {
                    throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
                }
                if ("Drive".equals(this.getID())) {
                    throw new IllegalStateException("The root can not be deleted");
                }
                list2 = null;
                list = null;
                n2 = com.inet.drive.server.eventlog.a.d(this);
                try {
                    this.getParent();
                    string = this.getPath();
                    if (this.getFeature(FOLDER) == null) break block29;
                    list = this.eg.getChildren();
                    j2 = UserAccountScope.createPrivileged();
                    try {
                        list2 = this.eg.getChildren();
                    }
                    finally {
                        if (j2 != null) {
                            j2.close();
                        }
                    }
                }
                catch (LockException lockException) {
                    throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.getID(), DriveOperationConflictException.CONFLICT.locked));
                }
            }
            j2 = this.aV();
            if (j2 == null) {
                return;
            }
            try (ServerLock serverLock = j2.tryLock(200L);){
                String string2 = this.getName();
                String string3 = this.getMetaData(MetaData.PARENT_ID);
                @Nonnull ArrayList<@Nonnull DriveOperationConflictException.SingleEntryConflict> arrayList = new ArrayList<DriveOperationConflictException.SingleEntryConflict>();
                if (serverLock == null && list2 != null) {
                    arrayList.add(new DriveOperationConflictException.SingleEntryConflict(this.getID(), DriveOperationConflictException.CONFLICT.locked));
                    throw new DriveOperationConflictException(false, arrayList);
                }
                if (list != null && list2 != null) {
                    if (list.size() != list2.size()) {
                        arrayList.add(new DriveOperationConflictException.SingleEntryConflict(this.getID(), DriveOperationConflictException.CONFLICT.protectedChild));
                    }
                    for (DriveEntry driveEntry : list) {
                        try {
                            driveEntry.delete(c2);
                        }
                        catch (DriveOperationConflictException driveOperationConflictException) {
                            arrayList.addAll(driveOperationConflictException.getConflicts());
                        }
                        catch (AccessDeniedException accessDeniedException) {
                            arrayList.add(new DriveOperationConflictException.SingleEntryConflict(driveEntry.getID(), DriveOperationConflictException.CONFLICT.protectedChild));
                        }
                    }
                }
                if (arrayList.isEmpty()) {
                    f f2;
                    DriveEntry driveEntry;
                    String string4 = this.getID();
                    c2.startOperationFor(this.getID());
                    driveEntry = this.getParent();
                    if (driveEntry != null && (f2 = (f)driveEntry.getFeature(FOLDER)) != null) {
                        f2.B(this.getID());
                    }
                    c2.W(string);
                    this.bi.clear();
                    if (!(listener instanceof com.inet.drive.server.utils.c) && DriveUtils.getOperation() == null) {
                        com.inet.drive.server.eventlog.a.bz.a(string4, string, n2, c2.cg());
                    }
                    this.dQ.notifyObservers(DriveObserver.EventType.REMOVED, new DriveObserver.EventType.RemoveEvent(this.getID(), string3, string2));
                    try {
                        this.ep.deleteTree();
                    }
                    catch (Throwable throwable) {}
                    break block30;
                }
                throw new DriveOperationConflictException(true, arrayList);
            }
        }
    }

    private PersistenceEntry aX() {
        return Persistence.getRecoveryEnabledInstance().resolve("/drive/" + e.y(this.id));
    }

    public static c a(com.inet.drive.server.a a2) {
        c c2;
        block9: {
            if (DrivePlugin.LOGGER.isDebug()) {
                DrivePlugin.LOGGER.debug((Object)new Exception("Drive root folder created"));
            }
            UserAccountScope userAccountScope = UserAccountScope.createPrivileged();
            try {
                c c3 = new c("Drive");
                c3.dQ = a2;
                c3.ep = Persistence.getRecoveryEnabledInstance().resolve("/drive/" + e.y("Drive"));
                c3.bi.add(META_DATA);
                c3.ej = k.c(c3);
                c3.runFeature(PERMISSIONS, permissions -> {
                    permissions.addPermissions(UsersAndGroups.GROUPID_ADMIN, true, Permissions.getReadWriteAccess());
                    permissions.addPermissions(UsersAndGroups.GROUPID_ALLUSERS, true, Permissions.VIEWER_PERMISSION);
                });
                c3.bi.add(FOLDER);
                c3.eg = new f(c3);
                c2 = c3;
                if (userAccountScope == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (userAccountScope != null) {
                        try {
                            userAccountScope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    DrivePlugin.LOGGER.error(throwable3.getMessage(), throwable3);
                    return null;
                }
            }
            userAccountScope.close();
        }
        return c2;
    }

    @Nonnull
    static c a(c c2, DataEntry dataEntry, com.inet.drive.server.a a2) throws DriveOperationConflictException {
        return c.a(c2, a2, dataEntry.getName(), false, (String string, String string2) -> {
            GUID gUID = c2.getMetaData(MetaData.HOMEFOLDER);
            c c3 = new c(string, a2);
            String string3 = dataEntry.getName();
            c3.ej = (k)c3.getFeature(META_DATA);
            if (c3.ej == null) {
                c3.delete(null);
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(null, DriveOperationConflictException.CONFLICT.exception, "No Metadata available during the creation"));
            }
            c3.ej.a(c.a(string3, string2 + dataEntry.getName(), c2.getID(), gUID, null, null), false);
            c3.bi.add(CONTENT);
            c3.bi.add(RANDOMACCESS);
            c3.eh = new com.inet.drive.server.persistence.b(c3);
            c3.eh.a(dataEntry.getContent(), dataEntry.getListener());
            return c3;
        });
    }

    @Nonnull
    static c a(c c2, @Nonnull String string, com.inet.drive.server.a a2) throws DriveOperationConflictException {
        return c.a(c2, a2, string, true, (String string2, String string3) -> {
            GUID gUID = c2.getMetaData(MetaData.HOMEFOLDER);
            c c3 = new c(string2, a2);
            c3.bi.add(FOLDER);
            c3.eg = new f(c3);
            c3.ej = (k)c3.getFeature(META_DATA);
            if (c3.ej == null) {
                c3.delete(null);
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(null, DriveOperationConflictException.CONFLICT.exception, "No Metadata available during the creation"));
            }
            c3.ej.a(c.a(string, (string3 != null ? string3 : "/") + string + "/", c2.getID(), gUID, null, null), false);
            return c3;
        });
    }

    static c a(c c2, com.inet.drive.server.a a2, GUID gUID, String string) throws DriveOperationConflictException {
        return c.a(c2, a2, (String string2, String string3) -> {
            try {
                c c2 = new c(string2, a2);
                c2.bi.add(FOLDER);
                c2.eg = new f(c2);
                c2.ej = (k)c2.getFeature(META_DATA);
                if (c2.ej == null) {
                    c2.delete(null);
                    throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(null, DriveOperationConflictException.CONFLICT.exception, "No Metadata available during the creation"));
                }
                c2.ej.a(c.a("Home", "/Home/", "Drive", gUID, gUID, string), false);
                c2.ei = new PersistencePermissions(c2, gUID);
                return c2;
            }
            catch (Throwable throwable) {
                DrivePlugin.LOGGER.warn("User directory can not created " + string2, (Object)throwable);
                try {
                    Persistence.getRecoveryEnabledInstance().resolve("/drive/" + e.y(string2)).deleteTree();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        });
    }

    @Nonnull
    static <T> @Nonnull Map<@Nonnull MetaKey<?>, Object> a(@Nonnull T t2, @Nonnull T t3, @Nullable T t4, @Nullable T t5, @Nullable T t6, @Nullable T t7) {
        HashMap<@Nonnull MetaKey<?>, Object> hashMap = new HashMap();
        hashMap.put(MetaData.NAME, t2);
        hashMap.put(MetaData.PATH, t3);
        if (t4 != null) {
            hashMap.put(MetaData.PARENT_ID, t4);
        }
        if (t5 != null) {
            hashMap.put(MetaData.HOMEFOLDER, t5);
        }
        if (t6 != null) {
            hashMap.put(MetaData.CREATOR_ID, t6);
        }
        if (t7 != null) {
            hashMap.put(MetaData.CREATOR, t7);
        }
        hashMap.put(MetaData.MODIFIED, System.currentTimeMillis());
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID != null) {
            hashMap.put(MetaData.MODIFIEDBY, gUID);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static c a(c c2, com.inet.drive.server.a a2, a a3) throws DriveOperationConflictException {
        @Nonnull String string = DriveIDUtils.generateID();
        j j2 = new j(string);
        String string2 = c2.getPath();
        try (ServerLock serverLock = j2.tryLock();){
            Object object;
            if (serverLock == null) {
                c c3 = c.a(c2, a2, a3);
                return c3;
            }
            c c4 = a3.create(string, string2);
            try {
                object = ((Lock)c2.getFeature(LOCK)).tryLock(200L);
                try {
                    if (object != null) {
                        ((r)c2.getFeature(FOLDER)).f(string, c4.getName());
                    }
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (c4 != null) {
                        c4.delete(null);
                    }
                }
                finally {
                    ErrorCode.throwAny((Throwable)throwable);
                }
            }
            if (c4 == null) {
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(string, DriveOperationConflictException.CONFLICT.locked));
            }
            object = c4;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static c a(c c2, com.inet.drive.server.a a2, String string, boolean bl, a a3) throws DriveOperationConflictException {
        @Nonnull String string2 = DriveIDUtils.generateID();
        j j2 = new j(string2);
        String string3 = c2.getPath();
        try (ServerLock serverLock = j2.tryLock();){
            Object object;
            if (serverLock == null) {
                c c3 = c.a(c2, a2, string, bl, a3);
                return c3;
            }
            c c4 = a3.create(string2, string3);
            try {
                object = ((Lock)c2.getFeature(LOCK)).tryLock(200L);
                try {
                    ((f)c2.getFeature(FOLDER)).f(string2, string);
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (c4 != null) {
                        c4.delete(null);
                    }
                }
                finally {
                    ErrorCode.throwAny((Throwable)throwable);
                }
            }
            if (c4 == null) {
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(string2, DriveOperationConflictException.CONFLICT.locked));
            }
            object = c4;
            return object;
        }
    }

    private static class b
    extends com.inet.drive.server.utils.b {
        public b() {
            super(com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission("Drive", false, "EDITOR"));
        }

        @Override
        public boolean canMove() {
            return false;
        }

        @Override
        public boolean canRename() {
            return false;
        }

        @Override
        public boolean canDelete() {
            return false;
        }
    }

    private static interface a {
        public c create(@Nonnull String var1, String var2) throws DriveOperationConflictException;
    }
}

