/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.api.mount;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.DriveIOException;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.OperationProgressListener;
import com.inet.drive.api.feature.DriveFeature;
import com.inet.drive.api.feature.Folder;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Mount;
import com.inet.drive.api.feature.Permission;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.api.mount.BrokenMountDriveEntry;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.server.linked.c;
import com.inet.drive.server.persistence.l;
import com.inet.drive.server.persistence.m;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
implements DriveEntry {
    private final List<Class<? extends DriveFeature>> at;
    private MetaData au;
    private Folder av;
    private Mount aw;
    @Nonnull
    private final MountDescription ax;

    @Nonnull
    private MetaData D() {
        if (this.au == null) {
            this.au = new MetaData(){

                @Override
                public <T> void setMetaData(@Nonnull @Nonnull MetaKey<@Nonnull T> key, @Nullable T value) throws DriveEntry.UnmodifiableEntryException, DriveOperationConflictException {
                    UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                    if (userAccount == null || !userAccount.getID().equals((Object)b.this.ax.getUserID())) {
                        throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(b.this.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
                    }
                }

                @Override
                @Nullable
                public <T> T getMetaData(@Nonnull @Nonnull MetaKey<@Nonnull T> key) {
                    Object object;
                    if (key != MetaData.ID && key != MetaData.NAME && key != MetaData.CREATOR_ID && key != MetaData.PARENT_ID && key != MetaData.HOMEFOLDER && ((object = UserManager.getInstance().getCurrentUserAccount()) == null || !m.a((UserAccount)object) && !object.getID().equals((Object)b.this.ax.getUserID()))) {
                        throw new AccessDeniedException(DrivePlugin.MSG_SERVER.getMsg("drive.entry.accessdenied", new Object[]{"VIEWER"}));
                    }
                    if (key == MetaData.ID) {
                        return (T)b.this.getID();
                    }
                    if (key == MetaData.NAME) {
                        return (T)b.this.getName();
                    }
                    if (key == MetaData.PATH) {
                        return (T)b.this.getPath();
                    }
                    if (key == MetaData.CREATOR_ID) {
                        return (T)b.this.ax.getUserID();
                    }
                    if (key == MetaData.CREATOR) {
                        object = UserManager.getInstance().getUserAccount(b.this.ax.getUserID());
                        if (object != null) {
                            return (T)object.getDisplayName();
                        }
                    } else {
                        if (key == MetaData.MOUNT_PROVIDER) {
                            return (T)b.this.ax.getProvider();
                        }
                        if (key == MetaData.MOUNT_CONNECTION_STATUS) {
                            object = b.this.F();
                            if (object == null || "broken".equals(object.getExtensionName())) {
                                String string = "";
                                if (object != null) {
                                    string = ((BrokenMountDriveEntry)object).getTh().getMessage();
                                }
                                return (T)DrivePlugin.MSG_SERVER.getMsg("drive.mount.connection.noconnection", new Object[]{string});
                            }
                            try {
                                object.hasFeature(DriveEntry.FOLDER);
                            }
                            catch (Exception exception) {
                                return (T)DrivePlugin.MSG_SERVER.getMsg("drive.mount.connection.noconnection", new Object[]{exception.getMessage()});
                            }
                            return (T)DrivePlugin.MSG_SERVER.getMsg("drive.mount.connection.connected", new Object[0]);
                        }
                    }
                    return null;
                }
            };
        }
        return this.au;
    }

    private Folder E() {
        return new c(this, this.ax){

            @Override
            protected Folder G() {
                if (b.this.av == null) {
                    DriveEntry driveEntry = b.this.F();
                    if (driveEntry != null) {
                        b.this.av = driveEntry.getFeature(Folder.class);
                    } else {
                        DrivePlugin.LOGGER.warn((Object)("Could not resolve folder for MountRootEntry " + String.valueOf(b.this.ax.getID())));
                    }
                }
                return b.this.av;
            }
        };
    }

    b(@Nonnull MountDescription mountDescription) {
        this.ax = mountDescription;
        this.at = new ArrayList<Class<? extends DriveFeature>>();
        this.at.add(MetaData.class);
        this.at.add(Folder.class);
        this.at.add(Permissions.class);
        this.at.add(Mount.class);
    }

    @Override
    @Nonnull
    public String getPath() {
        return "/" + this.getName() + "/";
    }

    @Override
    @Nonnull
    public String getName() {
        return this.ax.getName();
    }

    @Override
    @Nonnull
    public String getID() {
        return DriveIDUtils.getMountRootID(this.ax.getID());
    }

    @Override
    public long getLastModified() throws DriveIOException {
        return this.ax.getModified();
    }

    @Override
    public boolean exists() {
        return MountManager.getInstance().getMountDescription(this.ax.getID()) != null;
    }

    @Override
    public boolean hasFeature(@Nonnull Class<? extends DriveFeature> type) throws DriveIOException {
        if (this.at.contains(type)) {
            return true;
        }
        if (type == com.inet.drive.api.feature.a.class) {
            return false;
        }
        DriveEntry driveEntry = this.F();
        if (driveEntry != null) {
            return driveEntry.hasFeature(type);
        }
        return false;
    }

    @Override
    @Nullable
    public <T extends DriveFeature> T getFeature(@Nonnull Class<T> type) throws DriveIOException {
        if (!this.exists() || !this.hasFeature(type)) {
            return null;
        }
        if (type == MetaData.class) {
            return (T)this.D();
        }
        if (type == Folder.class) {
            return (T)this.E();
        }
        if (type == Mount.class) {
            if (this.aw == null) {
                this.aw = new l(this, this.ax, "/", this.getID(), true);
            }
            return (T)this.aw;
        }
        if (type == Permissions.class) {
            return (T)new a();
        }
        DriveEntry driveEntry = this.F();
        if (driveEntry != null) {
            return driveEntry.getFeature(type);
        }
        return null;
    }

    @Override
    @Nullable
    public DriveEntry getParent() {
        return null;
    }

    @Override
    public void delete(@Nullable OperationProgressListener listener) throws DriveOperationConflictException {
        MountManager.getInstance().removeMountDescription(this.ax);
    }

    @Override
    @Nonnull
    public String getExtensionName() {
        return "MountRoot";
    }

    @Nullable
    private DriveEntry F() {
        return this.ax.resolve(this, "/");
    }

    private class a
    implements Permissions {
        private a() {
        }

        @Override
        public boolean hasPermission(@Nonnull String permissionType) {
            return com.inet.drive.webgui.server.a.du().getPermissionChecker().hasPermission(b.this.getID(), false, permissionType);
        }

        @Override
        public void addPermissions(@Nonnull GUID userOrGroupId, boolean isGroup, Permission ... permissions) {
        }

        @Override
        public void removePermission(@Nonnull GUID userOrGroupId, boolean isGroup, String ... permissionTypes) {
        }

        @Override
        public void setPermissions(boolean isGroup, @Nonnull Map<GUID, Map<String, Boolean>> permissions) {
        }

        @Override
        public void clearPermission() {
        }

        @Override
        @Nonnull
        public @Nonnull Map<@Nonnull GUID, Map<String, Boolean>> getPermissions(boolean isGroup) {
            return Map.of();
        }

        @Override
        @Nonnull
        public List<String> getAvailablePermissions() {
            return List.of();
        }
    }
}

