/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.server.actions.permissions;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.Drive;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.Permissions;
import com.inet.drive.webgui.pluginapi.AbstractContextMenuExtension;
import com.inet.drive.webgui.pluginapi.ContextMenuExtension;
import com.inet.drive.webgui.server.a;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.user.UserManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
extends AbstractContextMenuExtension {
    public b() {
        super("permissions", "drive.permissions", 300, new String[0]);
    }

    @Override
    public ContextMenuExtension.AddType addForEntry(@Nonnull DriveEntry e2) {
        if (!e2.hasFeature(Permissions.class)) {
            return ContextMenuExtension.AddType.none;
        }
        if (e2.hasFeature(DriveEntry.MOUNT) && !e2.getID().startsWith("s_")) {
            GUID gUID;
            if (e2.getID().startsWith("m_")) {
                return ContextMenuExtension.AddType.none;
            }
            if (e2.hasFeature(MetaData.class) && ((gUID = e2.getMetaData(MetaData.CREATOR_ID)) == null || !gUID.equals((Object)UserManager.getInstance().getCurrentUserAccountID()))) {
                return ContextMenuExtension.AddType.none;
            }
        }
        if (e2.hasFeature(DriveEntry.FOLDER)) {
            if (b.u(e2)) {
                return ContextMenuExtension.AddType.none;
            }
            return ContextMenuExtension.AddType.from(a.du().getPermissionChecker().hasPermission(e2.getID(), false, "EDITOR"));
        }
        return ContextMenuExtension.AddType.none;
    }

    @Override
    public boolean addForMultiSelection(@Nullable DriveEntry folder) {
        if (folder == null) {
            return false;
        }
        if (!Drive.getInstance().getPermissionChecker().hasPermission(folder.getID(), false, "VIEWER")) {
            return false;
        }
        return this.addForEntry(folder) != ContextMenuExtension.AddType.none;
    }

    public static boolean u(DriveEntry driveEntry) {
        try {
            GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
            if (driveEntry == null || gUID == null) {
                return false;
            }
            String string = driveEntry.getPath();
            if (string.startsWith("/Home/")) {
                SearchCondition searchCondition = new SearchCondition(MetaData.HOMEFOLDER.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)gUID.toString());
                SearchCondition searchCondition2 = new SearchCondition(MetaData.ID.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)driveEntry.getID().toString());
                SearchResult<String> searchResult = a.du().search(new SearchCommand(new SearchExpression[]{searchCondition, searchCondition2}));
                if (!searchResult.getEntries().isEmpty()) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            DrivePlugin.LOGGER.warn((Object)exception);
        }
        return false;
    }

    static boolean dx() {
        return ServerPluginManager.getInstance().isPluginLoaded("usersandgroupsmanager") && SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
    }
}

