/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.webgui.pluginapi;

import com.inet.annotations.InternalApi;
import com.inet.drive.DrivePlugin;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.id.GUID;
import com.inet.lib.util.Encryption;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class MountUIHelper {
    @Nonnull
    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="This password is a placeholder to not send the original password to the UI")
    public static Map<String, String> mockPasswordForUI(@Nonnull MountDescription desc) {
        @Nonnull HashMap<String, String> hashMap = new HashMap<String, String>(desc.getProviderConfig());
        if (hashMap.get("password") != null) {
            hashMap.put("password", "THIS_CONNECTION_HAS_A_PASSWORD");
            hashMap.put("mountDescriptionID", desc.getID().toString());
        }
        return hashMap;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="This password is a placeholder to not send the original password to the UI")
    public static void resolvePassword(Map<String, String> properties) {
        String string = properties.get("password");
        if (string == null) {
            return;
        }
        if ("THIS_CONNECTION_HAS_A_PASSWORD".equals(string)) {
            String string2 = properties.get("mountDescriptionID");
            if (string2 != null) {
                @Nullable MountDescription mountDescription = MountManager.getInstance().getMountDescription(GUID.valueOf((String)string2));
                if (mountDescription != null) {
                    properties.put("password", mountDescription.getProviderConfig().get("password"));
                } else {
                    properties.remove("password");
                }
            } else {
                DrivePlugin.LOGGER.debug((Object)"Missing reference to existing mount configuration. The password used for the mount may be incorrect");
                properties.remove("password");
            }
        } else {
            try {
                properties.put("password", Encryption.encodePassword((String)string));
            }
            catch (IOException iOException) {
                DrivePlugin.LOGGER.debug((Object)iOException);
                properties.put("password", string);
            }
        }
    }
}

