/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.maintenance;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveIDUtils;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.mount.MountDescription;
import com.inet.drive.api.mount.MountManager;
import com.inet.drive.server.maintenance.DriveCacheAction;
import com.inet.drive.server.persistence.e;
import com.inet.drive.server.persistence.r;
import com.inet.drive.webgui.pluginapi.ResolveRenameHandler;
import com.inet.id.GUID;
import com.inet.maintenance.api.backup.BackupContentInformation;
import com.inet.maintenance.api.backup.BackupHelper;
import com.inet.maintenance.api.backup.BackupRunningStatus;
import com.inet.maintenance.api.backup.BackupTask;
import com.inet.maintenance.api.backup.FileProgress;
import com.inet.maintenance.api.backup.ProgressUpdater;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.plugin.ApplicationDescription;
import com.inet.shared.utils.Version;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class a
implements BackupTask {
    private static final List<String> cK = List.of(".thumbnail-px96", ".thumbnail-px512");
    private final DriveCacheAction cL;

    public a(DriveCacheAction driveCacheAction) {
        this.cL = driveCacheAction;
    }

    public String getKey() {
        return "drive";
    }

    public String getTitle() {
        return DrivePlugin.MSG_SERVER.getMsg("backup.drive.title", new Object[0]);
    }

    public String getDescription() {
        return DrivePlugin.MSG_SERVER.getMsg("backup.drive.description", new Object[0]);
    }

    public URL getIconURL() {
        return DrivePlugin.class.getResource("/com/inet/drive/structure/drive_32.png");
    }

    public void execute(Path taskPath, BackupRunningStatus runningStatus, final BackupContentInformation contentInformation, final ProgressUpdater progressUpdater) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        for (String string : cK) {
            if (BackupHelper.SYSTEM_FILES.contains(string)) continue;
            BackupHelper.SYSTEM_FILES.add(string);
        }
        PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("drive/mountmanager");
        final int n2 = Math.max(0, persistenceEntry.getChildren().size() - 1);
        backupHelper.createZipFromFolderContent(Persistence.getRecoveryEnabledInstance().resolve("drive"), taskPath.resolve("drive.zip"), new FileProgress(){

            public void progressUpdate(int progress, int files) {
                final String string = DrivePlugin.MSG_SERVER.getMsg("backup.drive.taskdetail", new Object[]{files});
                final String string2 = DrivePlugin.MSG_SERVER.getMsg("backup.drive.taskdetail.connections", new Object[]{n2});
                contentInformation.putTaskDetails(a.this.getKey(), (ArrayList)new ArrayList<String>(){
                    {
                        this.add(string);
                        this.add(string2);
                    }
                });
                progressUpdater.updateProgress(progress);
            }
        });
        progressUpdater.updateProgress(100);
    }

    public void restore(Path taskPath, BackupRunningStatus runningStatus, ProgressUpdater progressUpdater, @Nonnull Version backupVersion) throws Throwable {
        Persistence persistence = Persistence.getRecoveryEnabledInstance();
        Path path = taskPath.resolve("drive.zip");
        PersistenceEntry persistenceEntry = persistence.resolve("/drive");
        if (persistenceEntry.exists()) {
            persistenceEntry.moveTo("/driveBackup");
            persistenceEntry = persistence.resolve("/drive");
            PersistenceEntry persistenceEntry2 = persistence.resolve("/driveBackup");
            this.a(path, persistenceEntry, progressUpdater, true);
            LinkedList<a> linkedList = this.a(persistence);
            this.a(persistence, linkedList);
            persistenceEntry2.deleteTree();
        } else {
            this.a(path, persistenceEntry, progressUpdater, false);
        }
        this.a(persistence, progressUpdater);
    }

    private void a(@Nonnull Path path, @Nonnull PersistenceEntry persistenceEntry, @Nonnull ProgressUpdater progressUpdater, boolean bl) throws Throwable {
        BackupHelper backupHelper = new BackupHelper();
        if (bl) {
            backupHelper.extractZipIntoFolder(path, persistenceEntry, false, (n2, n3) -> progressUpdater.updateProgress(n2 / 2));
            Thread.sleep(1000L);
        } else {
            backupHelper.extractZipIntoFolder(path, persistenceEntry, false, (n2, n3) -> progressUpdater.updateProgress(n2));
        }
    }

    private LinkedList<a> a(@Nonnull Persistence persistence) {
        c c2 = new c(persistence);
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<@Nonnull a> linkedList2 = new LinkedList<a>();
        linkedList.add("Drive");
        while (linkedList.peek() != null) {
            String string = (String)linkedList.poll();
            a a2 = c2.a(string, true);
            a a3 = c2.a(string, false);
            if (a2 == null || !a2.as()) {
                this.a(persistence, c2, linkedList, string);
                continue;
            }
            if (!a2.isFolder()) continue;
            this.a(persistence, c2, linkedList, linkedList2, a2, a3);
        }
        return linkedList2;
    }

    private void a(@Nonnull Persistence persistence, @Nonnull c c2, @Nonnull Queue<String> queue, @Nonnull String string) {
        a a2;
        if (!c2.dg.contains(string) && (a2 = c2.a(string, false)) != null) {
            DrivePlugin.LOGGER.debug((Object)("New ID adopted " + string + a2.getPath()));
            this.a(persistence, string);
            a a3 = this.a(c2, string);
            if (a3 != null) {
                queue.addAll(a3.ar());
            }
        }
    }

    private void a(@Nonnull Persistence persistence, @Nonnull c c2, @Nonnull @Nonnull Queue<@Nonnull String> queue, @Nonnull @Nonnull LinkedList<@Nonnull a> linkedList, @Nonnull a a2, @Nullable a a3) {
        HashSet<String> hashSet = a2.ar();
        if (a3 != null && a3.isFolder()) {
            this.a(c2, linkedList, hashSet, a3);
        }
        this.a(persistence, c2, queue, a2);
        hashSet = a2.ar();
        for (String string : hashSet) {
            queue.add(string);
        }
    }

    private void a(@Nonnull c c2, @Nonnull @Nonnull LinkedList<@Nonnull a> linkedList, @Nonnull @Nonnull HashSet<@Nonnull String> hashSet, @Nonnull a a2) {
        for (String string : a2.ar()) {
            a a3;
            a a4 = c2.a(string, true);
            if (hashSet.contains(string) || a4 != null && a4.as() || (a3 = c2.a(string, false)) == null) continue;
            linkedList.add(a3);
        }
    }

    private void a(@Nonnull Persistence persistence, @Nonnull c c2, @Nonnull Queue<String> queue, @Nonnull a a2) {
        a a3;
        String string = c2.a(a2.getPath(), a2.at(), false);
        if (string != null && (a3 = c2.a(string, false)) != null && a3.isFolder()) {
            DrivePlugin.LOGGER.debug((Object)("Merge f\u00fcr Folder " + a2.getPath() + " ( " + a2.getId() + " ) "));
            HashMap<String, String> hashMap = this.a(c2, a2);
            boolean bl = this.a(persistence, c2, queue, a2, a3, hashMap);
            if (bl) {
                a2.b(a2.ar());
            }
        }
    }

    private HashMap<String, String> a(@Nonnull c c2, @Nonnull a a2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : a2.ar()) {
            a a3 = c2.a(string, true);
            if (a3 == null || !a3.as()) continue;
            hashMap.put(a3.getName(), string);
        }
        return hashMap;
    }

    private boolean a(@Nonnull Persistence persistence, @Nonnull c c2, @Nonnull @Nonnull Queue<@Nonnull String> queue, @Nonnull a a2, @Nonnull a a3, @Nonnull HashMap<String, String> hashMap) {
        boolean bl = false;
        HashSet<String> hashSet = a2.ar();
        for (String string : a3.ar()) {
            a a4 = c2.a(string, false);
            if (a4 == null || !a4.as() || hashSet.contains(string)) continue;
            String string2 = a4.getName();
            if (hashMap.get(string2) != null) {
                c2.dh.remove(string);
                continue;
            }
            if (c2.dg.contains(string)) continue;
            hashSet.add(string);
            queue.add(string);
            bl = true;
            a4.b(MetaData.PARENT_ID, a2.getId());
            this.a(persistence, string);
            this.a(c2, string);
        }
        return bl;
    }

    private void a(@Nonnull Persistence persistence, @Nonnull @Nonnull LinkedList<@Nonnull a> linkedList) {
        linkedList.sort((a2, a3) -> {
            int n2 = a2.getPath().split("/").length;
            int n3 = a3.getPath().split("/").length;
            return Integer.compare(n2, n3);
        });
        c c2 = new c(persistence);
        while (linkedList.peek() != null) {
            a a4 = linkedList.poll();
            c2.a(a4, linkedList);
        }
    }

    private void a(@Nonnull Persistence persistence, @Nonnull ProgressUpdater progressUpdater) {
        this.b(persistence);
        this.c(persistence);
        if (persistence.resolve("/drive").exists()) {
            ((com.inet.drive.server.a)com.inet.drive.webgui.server.a.du()).H();
            this.cL.executeAction();
        }
        progressUpdater.updateProgress(100);
    }

    @Nullable
    private a a(@Nonnull c c2, @Nonnull String string) {
        a a2 = c2.a(string, true);
        if (a2 != null && a2.isFolder()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : a2.ar()) {
                a a3 = c2.a(string2, true);
                if (a3 != null && a3.as()) continue;
                hashSet.add(string2);
            }
            a2.b(hashSet);
        }
        return a2;
    }

    private void b(@Nonnull Persistence persistence) {
        DrivePlugin.LOGGER.debug((Object)"Restore successful: Result is now ->");
        String string = "/Home/".substring(0, "/Home/".length() - 1);
        PersistenceEntry persistenceEntry = persistence.resolve("/drive");
        HashSet<a> hashSet = new HashSet<a>();
        HashMap<String, Object> hashMap = this.a(persistenceEntry, string, hashSet);
        this.a(hashMap);
        DrivePlugin.LOGGER.debug((Object)("After the restore " + hashSet.size() + " Entry"));
    }

    @Nonnull
    private HashMap<String, Object> a(PersistenceEntry persistenceEntry, String string, HashSet<a> hashSet) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (PersistenceEntry persistenceEntry2 : persistenceEntry.getChildren()) {
            String string2 = persistenceEntry2.getName();
            if (string2.length() != 2) continue;
            this.a(persistenceEntry2, string2, string, hashSet, hashMap);
        }
        return hashMap;
    }

    private void a(@Nonnull PersistenceEntry persistenceEntry, @Nonnull String string, @Nonnull String string2, @Nonnull @Nonnull HashSet<@Nonnull a> hashSet, @Nonnull HashMap<String, Object> hashMap) {
        for (PersistenceEntry persistenceEntry2 : persistenceEntry.getChildren()) {
            String string3 = string + persistenceEntry2.getName();
            a a2 = new a(string3, Persistence.getRecoveryEnabledInstance().resolve("drive/" + e.y(string3)));
            DrivePlugin.LOGGER.debug((Object)("Restored = " + String.valueOf(a2)));
            hashSet.add(a2);
            if (!string2.equals(a2.getPath()) || a2.at() == null) continue;
            hashMap.put(a2.at().toString(), string3);
        }
    }

    private void a(@Nonnull HashMap<String, Object> hashMap) {
        if (!hashMap.isEmpty()) {
            DrivePlugin.LOGGER.debug((Object)("Restored has " + hashMap.size() + " Homedirectories"));
            e.a(r.bG(), hashMap);
        }
    }

    private void c(@Nonnull Persistence persistence) {
        PersistenceEntry persistenceEntry = persistence.resolve("/drive");
        HashSet<String> hashSet = this.a(persistenceEntry);
        this.a(hashSet);
    }

    private HashSet<String> a(@Nonnull PersistenceEntry persistenceEntry) {
        HashSet<String> hashSet = new HashSet<String>();
        for (PersistenceEntry persistenceEntry2 : persistenceEntry.getChildren()) {
            String string = persistenceEntry2.getName();
            if (string.length() != 2) continue;
            this.b(persistenceEntry2, string, hashSet);
        }
        return hashSet;
    }

    private void b(@Nonnull PersistenceEntry persistenceEntry, @Nonnull String string, @Nonnull HashSet<String> hashSet) {
        for (PersistenceEntry persistenceEntry2 : persistenceEntry.getChildren()) {
            String string2 = string + persistenceEntry2.getName();
            a a2 = new a(string2, Persistence.getRecoveryEnabledInstance().resolve("drive/" + e.y(string2)));
            if (!"Drive".equals(a2.getParentID())) continue;
            hashSet.add(a2.getName());
        }
    }

    private void a(@Nonnull HashSet<String> hashSet) {
        List<MountDescription> list = MountManager.getInstance().getAllMountDescriptions();
        for (MountDescription mountDescription : list) {
            if ("PERSISTENCE_PROVIDER".equals(mountDescription.getProvider())) continue;
            if (hashSet.contains(mountDescription.getName())) {
                this.a(mountDescription, hashSet);
            }
            hashSet.add(mountDescription.getName());
        }
    }

    private void a(@Nonnull MountDescription mountDescription, @Nonnull HashSet<String> hashSet) {
        String string = ResolveRenameHandler.getRenameName(mountDescription.getName(), hashSet);
        if (!string.equals(mountDescription.getName())) {
            try {
                String string2 = mountDescription.getName();
                mountDescription.setNameSilent(string);
                DrivePlugin.LOGGER.debug((Object)("Mountdescription with the name " + string2 + " was renamed because of name conflict to " + mountDescription.getName()));
            }
            catch (Throwable throwable) {
                DrivePlugin.LOGGER.error("Error for rename the mount description " + String.valueOf(mountDescription.getID()), throwable);
            }
        }
    }

    private void a(@Nonnull Persistence persistence, @Nonnull String string) {
        if (DriveIDUtils.isLink(string)) {
            string = this.b(persistence, string);
        }
        this.c(persistence, string);
    }

    private String b(@Nonnull Persistence persistence, @Nonnull String string) {
        DrivePlugin.LOGGER.debug((Object)("Copy the linkID " + string + " from the newdata"));
        PersistenceEntry persistenceEntry = persistence.resolve("/driveBackup" + e.z(string));
        PersistenceEntry persistenceEntry2 = persistence.resolve("/drive" + e.z(string));
        this.a(persistenceEntry, persistenceEntry2);
        e.a a2 = e.h(persistenceEntry);
        return a2.bc();
    }

    private void a(@Nonnull PersistenceEntry persistenceEntry, @Nonnull PersistenceEntry persistenceEntry2) {
        PersistenceEntry persistenceEntry3 = persistenceEntry.getParent();
        if (persistenceEntry3 != null && persistenceEntry2.getParent() != null) {
            this.b(persistenceEntry3, persistenceEntry2.getParent());
        } else {
            DrivePlugin.LOGGER.warn((Object)"Copy not possible because no parent available");
        }
    }

    private void c(@Nonnull Persistence persistence, @Nonnull String string) {
        DrivePlugin.LOGGER.debug((Object)("Copy the id " + string + " from the newdata"));
        PersistenceEntry persistenceEntry = persistence.resolve("/driveBackup/" + e.y(string));
        PersistenceEntry persistenceEntry2 = persistence.resolve("/drive/" + e.y(string));
        this.b(persistenceEntry, persistenceEntry2);
    }

    private void b(@Nonnull PersistenceEntry persistenceEntry, @Nonnull PersistenceEntry persistenceEntry2) {
        for (PersistenceEntry persistenceEntry3 : persistenceEntry.getChildren()) {
            byte[] byArray = persistenceEntry3.getBytes();
            if (byArray == null) {
                this.b(persistenceEntry3, persistenceEntry2.resolve(persistenceEntry3.getName()));
                continue;
            }
            persistenceEntry2.resolve(persistenceEntry3.getName()).setBytes(byArray);
        }
    }

    public boolean isVersionSupportedForRestore(@Nonnull Version backupVersion) {
        return backupVersion.isHigherOrEquals(new Version("25.4")) && ApplicationDescription.get().getVersion().isHigherOrEquals(backupVersion);
    }

    private class c {
        private PersistenceEntry cY;
        private PersistenceEntry cZ;
        private HashMap<String, a> da = new HashMap();
        private HashMap<String, a> db = new HashMap();
        private HashMap<String, String> dc = new HashMap();
        private HashMap<String, String> dd = new HashMap();
        private HashMap<String, HashMap<String, String>> de = new HashMap();
        private HashMap<String, HashMap<String, String>> df = new HashMap();
        private HashSet<String> dg = new HashSet();
        private HashSet<String> dh = new HashSet();

        private void a(@Nonnull a a2, boolean bl) {
            if (a2.at() == null) {
                HashMap<String, String> hashMap = bl ? this.dc : this.dd;
                hashMap.put(a2.getPath(), a2.getId());
            } else {
                HashMap<String, HashMap<String, String>> hashMap = bl ? this.de : this.df;
                HashMap hashMap2 = hashMap.computeIfAbsent(a2.at(), string -> new HashMap());
                hashMap2.put(a2.getPath(), a2.getId());
            }
        }

        private String a(@Nonnull String string, @Nullable String string2, boolean bl) {
            HashMap<String, String> hashMap;
            if (string2 == null) {
                hashMap = bl ? this.dc : this.dd;
            } else {
                HashMap<String, String> hashMap2 = hashMap = bl ? this.de.get(string2) : this.df.get(string2);
            }
            if (hashMap == null) {
                return null;
            }
            return hashMap.get(string);
        }

        public c(Persistence persistence) {
            a a3;
            String string;
            Object object2;
            this.cY = persistence.resolve("/drive");
            this.cZ = persistence.resolve("/driveBackup");
            this.da.put("Drive", new a("Drive", this.cY.resolve(e.y("Drive"))));
            this.db.put("Drive", new a("Drive", this.cZ.resolve(e.y("Drive"))));
            PersistenceEntry persistenceEntry = this.cZ.resolve("mountmanager");
            PersistenceEntry persistenceEntry2 = this.cY.resolve("mountmanager");
            if (persistenceEntry.exists() && persistenceEntry2.exists()) {
                Iterator<String> iterator = new HashSet();
                for (Object object2 : persistenceEntry2.getChildren()) {
                    ((HashSet)((Object)iterator)).add(object2.getName());
                }
                for (Object object2 : persistenceEntry.getChildren()) {
                    if (((HashSet)((Object)iterator)).contains(object2.getName())) continue;
                    DrivePlugin.LOGGER.debug((Object)("Connection restore = " + object2.getName()));
                    a.this.b((PersistenceEntry)object2, this.cY.resolve("mountmanager/" + object2.getName()));
                }
            } else {
                a.this.b(this.cZ.resolve("mountmanager"), this.cY.resolve("mountmanager"));
            }
            MountManager.getInstance().reset();
            for (PersistenceEntry persistenceEntry3 : this.cY.getChildren()) {
                object2 = persistenceEntry3.getName();
                if (((String)object2).length() != 2) continue;
                for (PersistenceEntry persistenceEntry4 : persistenceEntry3.getChildren()) {
                    string = (String)object2 + persistenceEntry4.getName();
                    a3 = this.a(string, true);
                    if (a3 == null) continue;
                    DrivePlugin.LOGGER.debug((Object)("Backudata = " + String.valueOf(a3)));
                    this.dg.add((String)object2 + persistenceEntry4.getName());
                    this.a(a3, true);
                }
            }
            DrivePlugin.LOGGER.debug((Object)("In the backup were " + this.dg.size() + " Entry"));
            for (PersistenceEntry persistenceEntry3 : this.cZ.getChildren()) {
                object2 = persistenceEntry3.getName();
                if (((String)object2).length() != 2) continue;
                for (PersistenceEntry persistenceEntry4 : persistenceEntry3.getChildren()) {
                    string = (String)object2 + persistenceEntry4.getName();
                    a3 = this.a(string, false);
                    DrivePlugin.LOGGER.debug((Object)("Newdata = " + string + " -> " + String.valueOf(a3)));
                    if (a3 == null) continue;
                    this.a(a3, false);
                    if (this.dg.contains(string)) continue;
                    this.dh.add((String)object2 + persistenceEntry4.getName());
                }
            }
            DrivePlugin.LOGGER.debug((Object)("In the current drive were " + this.dh.size() + " new entries"));
        }

        @Nullable
        private a a(@Nonnull String string, boolean bl) {
            HashMap<String, a> hashMap = bl ? this.da : this.db;
            a a2 = hashMap.get(string);
            if (a2 == null) {
                if (DriveIDUtils.isLink(string)) {
                    PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve((bl ? "drive" : "driveBackup") + e.z(string));
                    if (persistenceEntry.exists()) {
                        e.a a3 = e.h(persistenceEntry);
                        a2 = new b(string, a3.bc(), Persistence.getRecoveryEnabledInstance().resolve((bl ? "drive" : "driveBackup") + "/" + e.y(a3.bc())));
                    }
                } else {
                    a2 = new a(string, Persistence.getRecoveryEnabledInstance().resolve((bl ? "drive" : "driveBackup") + "/" + e.y(string)));
                }
                hashMap.put(string, a2);
            }
            if (a2 == null) {
                DrivePlugin.LOGGER.debug((Object)("Not found Current ID = " + string));
            }
            return a2;
        }

        public void a(@Nonnull a a2, @Nonnull @Nonnull LinkedList<@Nonnull a> linkedList) {
            List<String> list = a2.aq();
            list.sort(Comparator.comparingInt(String::length));
            if (this.a(a2.getPath(), a2.at(), true) != null) {
                return;
            }
            String string = "Drive";
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string2 = list.get(i2);
                String string3 = this.a(string2, a2.at(), true);
                if (string3 == null) {
                    if (i2 == list.size() - 1) {
                        string = this.a(string2, a2, string, linkedList);
                        continue;
                    }
                    string = this.a(string2, a2, string);
                    continue;
                }
                string = string3;
            }
        }

        @Nonnull
        private String a(@Nonnull String string, @Nonnull a a2, @Nonnull String string2, @Nonnull @Nonnull LinkedList<@Nonnull a> linkedList) {
            DrivePlugin.LOGGER.debug((Object)("LastElement = " + string + " ( User " + a2.at() + " )"));
            a a3 = this.db.get(this.a(string, a2.at(), false));
            if (a3 == null) {
                return string2;
            }
            this.d(string2, a3.getId());
            String string3 = this.a(a3, string2);
            this.b(a3, linkedList);
            return string3;
        }

        private void d(String string, @Nonnull String string2) {
            a a2 = this.da.get(string);
            if (a2 != null) {
                HashSet<String> hashSet = a2.ar();
                hashSet.add(string2);
                a2.b(hashSet);
            }
        }

        @Nonnull
        private String a(@Nonnull a a2, @Nonnull String string) {
            PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("drive/" + e.y(a2.getId()));
            a.this.b(a2.cT, persistenceEntry);
            a a3 = new a(a2.getId(), persistenceEntry);
            a3.b(MetaData.PARENT_ID, string);
            this.da.put(a2.getId(), a3);
            this.a(a3, true);
            return a2.getId();
        }

        private void b(@Nonnull a a2, @Nonnull @Nonnull LinkedList<@Nonnull a> linkedList) {
            for (String string : a2.ar()) {
                a a3 = this.a(string, false);
                if (a3 == null) continue;
                linkedList.add(a3);
            }
        }

        private String a(@Nonnull String string, @Nonnull a a2, String string2) {
            DrivePlugin.LOGGER.debug((Object)("Need to Add the middle Part Element " + string + " from " + a2.getPath()));
            String string3 = this.a(string, a2.at(), false);
            a a3 = string3 == null ? null : this.a(string3, false);
            String string4 = this.av();
            this.e(string2, string4);
            if (a3 != null) {
                this.b(a3, string4);
                return string4;
            }
            return string2;
        }

        @Nonnull
        private String av() {
            String string = GUID.generateNew().toString();
            while (this.da.containsKey(string)) {
                string = GUID.generateNew().toString();
            }
            return string;
        }

        private void e(@Nonnull String string, @Nonnull String string2) {
            a a2 = this.a(string, true);
            if (a2 != null) {
                HashSet<String> hashSet = a2.ar();
                HashSet<String> hashSet2 = new HashSet<String>(hashSet);
                for (String string3 : hashSet2) {
                    a a3 = this.a(string3, true);
                    if (a3 != null && a3.as() && a2.getPath().startsWith(a3.getPath())) continue;
                    hashSet.remove(string3);
                }
                hashSet.add(string2);
                a2.b(hashSet);
            }
        }

        private void b(@Nonnull a a2, @Nonnull String string) {
            PersistenceEntry persistenceEntry = Persistence.getRecoveryEnabledInstance().resolve("drive/" + e.y(string));
            a.this.b(a2.cT, persistenceEntry);
            a a3 = new a(string, persistenceEntry);
            a3.b(new HashSet<String>());
            this.da.put(string, a3);
            this.a(a3, true);
        }
    }

    private static class a {
        private final String id;
        private final PersistenceEntry cT;
        private boolean cU;
        private String name;
        private String path;
        private String parentID;
        private String cV;
        private boolean am;
        private boolean cW;
        private HashSet<String> cX = new HashSet();

        public a(@Nonnull String string, @Nonnull PersistenceEntry persistenceEntry) {
            this.id = string;
            this.cT = persistenceEntry;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            if (!this.cU) {
                this.au();
            }
            return this.name;
        }

        public String getPath() {
            if (!this.cU) {
                this.au();
            }
            return this.path;
        }

        public List<String> aq() {
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = this.getPath().split("/");
            Object object = "";
            for (String string : stringArray) {
                if (string.isBlank()) continue;
                object = string.startsWith("/") ? (String)object + string : (String)object + "/" + string;
                arrayList.add((String)object);
            }
            return arrayList;
        }

        public String getParentID() {
            if (!this.cU) {
                this.au();
            }
            return this.parentID;
        }

        public HashSet<String> ar() {
            if (!this.cU) {
                this.au();
            }
            return this.cX;
        }

        public boolean isFolder() {
            if (!this.cU) {
                this.au();
            }
            return this.am;
        }

        public boolean as() {
            if (!this.cU) {
                this.au();
            }
            return this.cW;
        }

        public String at() {
            if (!this.cU) {
                this.au();
            }
            return this.cV;
        }

        public void b(HashSet<String> hashSet) {
            PersistenceEntry persistenceEntry = this.cT.resolve(".folder");
            e.a(persistenceEntry, hashSet);
            this.cX = new HashSet<String>(hashSet);
        }

        public void b(MetaKey<?> metaKey, Object object) {
            PersistenceEntry persistenceEntry = this.cT.resolve(".metadata");
            ConcurrentHashMap<String, Object> concurrentHashMap = e.d(persistenceEntry);
            concurrentHashMap.put(metaKey.getKey(), object);
            e.a(persistenceEntry, concurrentHashMap);
            this.cU = false;
        }

        protected void au() {
            if (!this.cU) {
                Object object;
                if (!this.cT.exists() || !this.cT.resolve(".metadata").exists()) {
                    this.cW = false;
                    return;
                }
                this.cW = true;
                PersistenceEntry persistenceEntry = this.cT.resolve(".folder");
                if (persistenceEntry.exists()) {
                    this.cX = new HashSet<String>(e.e(persistenceEntry));
                    this.am = true;
                    if ("Drive".equals(this.getId()) && (persistenceEntry = this.cT.resolve(".rootfolder")).exists()) {
                        object = e.d(persistenceEntry);
                        for (Object e2 : ((ConcurrentHashMap)object).values()) {
                            this.cX.add(e2.toString());
                        }
                    }
                } else {
                    this.am = false;
                }
                if ((object = this.cT.resolve(".metadata")).exists()) {
                    ConcurrentHashMap<String, Object> concurrentHashMap = e.d((PersistenceEntry)object);
                    this.name = (String)concurrentHashMap.get(MetaData.NAME.getKey());
                    this.path = (String)concurrentHashMap.get(MetaData.PATH.getKey());
                    if (this.path != null && this.path.endsWith("/")) {
                        this.path = this.path.substring(0, this.path.length() - 1);
                    }
                    this.parentID = (String)concurrentHashMap.get(MetaData.PARENT_ID.getKey());
                    this.cV = (String)concurrentHashMap.get(MetaData.HOMEFOLDER.getKey());
                }
                this.cU = true;
            }
        }

        public String toString() {
            if (!this.cU) {
                this.au();
            }
            Object object = "";
            for (PersistenceEntry persistenceEntry : this.cT.getChildren()) {
                object = (String)object + persistenceEntry.getPath() + " (" + persistenceEntry.size() + ") ,";
            }
            if (this.cV != null) {
                return "BackupEntryData{id='" + this.getId() + "', path='" + this.path + "', userID='" + this.cV + "', children=" + Arrays.toString(this.cX.toArray()) + ", parentID=" + this.parentID + "}";
            }
            return "BackupEntryData{id='" + this.getId() + "', path='" + this.path + "', children=" + Arrays.toString(this.cX.toArray()) + ", parentID=" + this.parentID + ", p_files=" + (String)object + " (" + this.cT.getChildren().size() + ")}";
        }
    }

    private static class b
    extends a {
        private final String cv;

        public b(String string, String string2, PersistenceEntry persistenceEntry) {
            super(string2, persistenceEntry);
            this.cv = string;
        }

        @Override
        public String getId() {
            return this.cv;
        }
    }
}

