/*
 * Decompiled with CFR 0.152.
 */
package com.inet.drive.server.persistence;

import com.inet.drive.DrivePlugin;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.DriveFileTypeHandler;
import com.inet.drive.api.DriveObserver;
import com.inet.drive.api.DriveOperationConflictException;
import com.inet.drive.api.DriveUtils;
import com.inet.drive.api.LockException;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.MetaData;
import com.inet.drive.api.feature.MetaKey;
import com.inet.drive.api.feature.Thumbnail;
import com.inet.drive.api.feature.UploadListener;
import com.inet.drive.server.eventlog.a;
import com.inet.drive.server.persistence.c;
import com.inet.drive.server.persistence.k;
import com.inet.id.GUID;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.RunnableSession;
import com.inet.thread.ServerLock;
import com.inet.thread.ThreadPool;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class b
implements Content {
    private c dV;
    private final String dW = ".tmp";

    public static boolean a(c c2) {
        return Persistence.getRecoveryEnabledInstance().resolve(c2.aT() + ".content").exists();
    }

    public b(c c2) {
        this.dV = c2;
        this.aQ();
    }

    private PersistenceEntry aO() {
        return Persistence.getRecoveryEnabledInstance().resolve(this.dV.aT());
    }

    private PersistenceEntry aP() {
        this.aQ();
        return Persistence.getRecoveryEnabledInstance().resolve(this.dV.aT() + System.currentTimeMillis() + ".tmp");
    }

    private boolean b(PersistenceEntry persistenceEntry) {
        String string = persistenceEntry.getName().replace(".tmp", "");
        if (string.matches("^[0-9]+$")) {
            long l2 = Long.parseLong(string);
            PersistenceEntry persistenceEntry2 = this.aO();
            if (persistenceEntry2.exists()) {
                for (PersistenceEntry persistenceEntry3 : persistenceEntry2.getChildren()) {
                    long l3;
                    string = persistenceEntry3.getName();
                    if (!string.endsWith(".tmp") || !(string = string.replace(".tmp", "")).matches("^[0-9]+$") || l2 >= (l3 = Long.parseLong(string))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void aQ() {
        PersistenceEntry persistenceEntry = this.aO();
        if (persistenceEntry.exists()) {
            for (PersistenceEntry persistenceEntry2 : persistenceEntry.getChildren()) {
                String string = persistenceEntry2.getName();
                if (!string.endsWith(".tmp")) continue;
                if ((string = string.replace(".tmp", "")).matches("^[0-9]+$")) {
                    long l2 = Long.parseLong(string);
                    if (l2 + 86400000L >= System.currentTimeMillis()) continue;
                    persistenceEntry2.deleteValue();
                    continue;
                }
                DrivePlugin.LOGGER.warn((Object)("In der Persistence von Drive wurde eine \u00c4nderung festgestellt, daher wird die Datei gel\u00f6scht. " + persistenceEntry2.getPath()));
                persistenceEntry2.deleteValue();
            }
        }
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        this.dV.aj();
        if (!this.dV.exists()) {
            return null;
        }
        try (final ServerLock serverLock = this.dV.aV().bl();){
            if (serverLock == null) {
                throw new LockException();
            }
            FilterInputStream filterInputStream = new FilterInputStream(this.aR().getInputStream()){
                private boolean dX;

                @Override
                public void close() throws IOException {
                    if (!this.dX) {
                        this.dX = true;
                        super.close();
                        serverLock.close();
                    }
                }

                protected void finalize() throws Throwable {
                    this.close();
                }
            };
            return filterInputStream;
        }
    }

    @Override
    public void setInputStream(@Nonnull InputStream value, UploadListener listener) throws DriveOperationConflictException {
        if (!this.dV.b(false)) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.dV.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
        }
        if (this.dV.exists()) {
            this.b(value, listener, true);
        }
    }

    void a(@Nonnull InputStream inputStream, UploadListener uploadListener) throws DriveOperationConflictException {
        this.b(inputStream, uploadListener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(final @Nonnull InputStream inputStream, final UploadListener uploadListener, boolean bl) throws DriveOperationConflictException {
        try (ServerLock serverLock = this.dV.aV().tryLock();){
            if (serverLock == null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.dV.getID(), DriveOperationConflictException.CONFLICT.locked));
            }
            PersistenceEntry persistenceEntry = this.aP();
            try {
                persistenceEntry.setInputStream(new InputStream(){
                    private long ea = System.currentTimeMillis();
                    private long eb;

                    private void aS() {
                        if (uploadListener != null && System.currentTimeMillis() - this.ea > 200L) {
                            this.ea = System.currentTimeMillis();
                            uploadListener.uploadSize(this.eb);
                        }
                    }

                    @Override
                    public int read() throws IOException {
                        ++this.eb;
                        this.aS();
                        return inputStream.read();
                    }

                    @Override
                    public int read(byte[] b2) throws IOException {
                        int n2 = inputStream.read(b2);
                        if (n2 >= 0) {
                            this.eb += (long)n2;
                        }
                        this.aS();
                        return n2;
                    }

                    @Override
                    public int read(byte[] b2, int off, int len) throws IOException {
                        int n2 = inputStream.read(b2, off, len);
                        if (n2 >= 0) {
                            this.eb += (long)n2;
                        }
                        this.aS();
                        return n2;
                    }
                });
                this.c(persistenceEntry);
                inputStream.close();
                this.a(persistenceEntry, bl, true);
            }
            catch (Exception exception) {
                DrivePlugin.LOGGER.error(this.dV.getID() + " - ", (Throwable)exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void refreshMetaData() {
        try {
            PersistenceEntry persistenceEntry = this.aP();
            this.c(persistenceEntry, this.aR());
            this.a(persistenceEntry, false, false);
        }
        catch (DriveOperationConflictException driveOperationConflictException) {
            DrivePlugin.LOGGER.warn((Object)driveOperationConflictException);
        }
    }

    private void a(PersistenceEntry persistenceEntry, boolean bl, boolean bl2) throws DriveOperationConflictException {
        String string;
        k k2;
        if (bl) {
            this.dV.C().notifyObservers(DriveObserver.EventType.CONTENT_CHANGE, this.dV);
        }
        if ((k2 = (k)this.dV.getFeature(DriveEntry.META_DATA)) == null) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(null, DriveOperationConflictException.CONFLICT.exception, "No internal metadata available, probably the entry already deleted"));
        }
        HashMap<@Nonnull MetaKey<?>, Object> hashMap = new HashMap();
        hashMap.put(MetaData.MODIFIED, System.currentTimeMillis());
        GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
        if (gUID != null) {
            hashMap.put(MetaData.MODIFIEDBY, gUID);
        } else {
            DrivePlugin.LOGGER.warn((Object)("No login User change meta data for key " + String.valueOf(hashMap.get("PATH"))));
        }
        hashMap.put(MetaData.MODIFIED, System.currentTimeMillis());
        if (bl2) {
            hashMap.put(MetaData.SIZE, this.aR().size());
        }
        if ((string = this.dV.getMetaData(MetaData.NAME)) != null) {
            hashMap.put(MetaData.FILETYPE, DriveFileTypeHandler.getSuffix(string));
        }
        this.a(k2, hashMap, bl);
        this.dV.runFeature(Thumbnail.class, object -> ((Thumbnail)object).resetThumbnails(new Thumbnail.Size[0]));
        ThreadPool.DEFAULT.startSubThread(() -> {
            List<DriveFileTypeHandler> list = DriveUtils.getDriveTypeHandler();
            for (DriveFileTypeHandler driveFileTypeHandler : list) {
                DriveFileTypeHandler.FileTypeDriveEntryHandler fileTypeDriveEntryHandler;
                Map<MetaKey<?>, Object> map;
                if (!driveFileTypeHandler.acceptFileTyp(this.dV, DriveFileTypeHandler.FEATURE.metaData) || (map = (fileTypeDriveEntryHandler = driveFileTypeHandler.getFileTypeHandler(persistenceEntry, this.dV)).getMetaData()) == null) continue;
                HashMap<@Nonnull MetaKey<?>, Object> hashMap = new HashMap();
                Object object = map.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<MetaKey<?>, Object> entry = object.next();
                    if (!this.b(persistenceEntry)) break;
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                if ((object = fileTypeDriveEntryHandler.getTextForSearch()) != null) {
                    if (!this.b(persistenceEntry)) break;
                    hashMap.put(MetaData.TEXT, object);
                }
                if (hashMap.isEmpty()) break;
                try {
                    this.a(k2, hashMap, bl);
                    break;
                }
                catch (DriveOperationConflictException driveOperationConflictException) {
                    DrivePlugin.LOGGER.warn((Object)driveOperationConflictException);
                    break;
                }
            }
            persistenceEntry.deleteValue();
        }, (RunnableSession)new BaseRunnableSession(UserManager.getInstance().getCurrentUserAccountID()));
    }

    private void a(k k2, @Nonnull @Nonnull Map<@Nonnull MetaKey<?>, Object> map, boolean bl) throws DriveOperationConflictException {
        k2.a(map, bl);
    }

    @Override
    @Nullable
    public OutputStream getOutputStream() throws DriveOperationConflictException {
        if (!this.dV.b(false)) {
            throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.dV.getID(), DriveOperationConflictException.CONFLICT.writeProtected));
        }
        if (!this.dV.exists()) {
            return null;
        }
        try (final ServerLock serverLock = this.dV.aV().tryLock();){
            if (serverLock == null) {
                throw DriveOperationConflictException.createSingleConflictException(false, new DriveOperationConflictException.SingleEntryConflict(this.dV.getID(), DriveOperationConflictException.CONFLICT.locked));
            }
            final PersistenceEntry persistenceEntry = this.aP();
            final OutputStream outputStream = persistenceEntry.getOutputStream();
            final GUID gUID = UserManager.getInstance().getCurrentUserAccountID();
            OutputStream outputStream2 = new OutputStream(){

                @Override
                public void write(int b2) throws IOException {
                    outputStream.write(b2);
                }

                @Override
                public void write(byte[] b2) throws IOException {
                    outputStream.write(b2);
                }

                @Override
                public void write(byte[] b2, int off, int len) throws IOException {
                    outputStream.write(b2, off, len);
                }

                @Override
                public void close() throws IOException {
                    outputStream.close();
                    b.this.c(persistenceEntry);
                    try (UserAccountScope userAccountScope = UserAccountScope.create((GUID)gUID);){
                        b.this.a(persistenceEntry, true, true);
                    }
                    b.this.dV.C().notifyObservers(DriveObserver.EventType.CONTENT_CHANGE, b.this.dV);
                    serverLock.close();
                }
            };
            return outputStream2;
        }
    }

    private void c(@Nonnull PersistenceEntry persistenceEntry) {
        this.c(this.aR(), persistenceEntry);
    }

    private void c(@Nonnull PersistenceEntry persistenceEntry, @Nonnull PersistenceEntry persistenceEntry2) {
        boolean bl = persistenceEntry.exists();
        try (InputStream inputStream = persistenceEntry2.getInputStream();){
            if (inputStream == null) {
                throw new IOException("InputStream is null");
            }
            persistenceEntry.setInputStream(inputStream);
            if (bl && DriveUtils.getOperation() == null) {
                a.bB.a(this.dV, new Object[0]);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public long getSize() {
        this.dV.aj();
        if (this.dV.exists()) {
            return this.aR().size();
        }
        return 0L;
    }

    private PersistenceEntry aR() {
        return Persistence.getRecoveryEnabledInstance().resolve(this.dV.aT() + ".content");
    }
}

