/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.interaction;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.ApplicationCommandData;
import discord4j.discordjson.json.ApplicationCommandRequest;
import discord4j.rest.RestClient;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class GuildCommandRegistrar {
    private static final Logger log = Loggers.getLogger(GuildCommandRegistrar.class);
    private final RestClient restClient;
    private final List<ApplicationCommandRequest> commandRequests;
    private final Mono<Long> applicationId;

    private GuildCommandRegistrar(RestClient restClient, List<ApplicationCommandRequest> commandRequests) {
        this.restClient = restClient;
        this.commandRequests = commandRequests;
        this.applicationId = restClient.getApplicationId().cache();
    }

    public static GuildCommandRegistrar create(RestClient restClient, List<ApplicationCommandRequest> commandRequests) {
        return new GuildCommandRegistrar(restClient, commandRequests);
    }

    public Flux<ApplicationCommandData> registerCommands(Snowflake guildId) {
        return this.bulkOverwriteCommands(guildId, this.commandRequests);
    }

    private Flux<ApplicationCommandData> bulkOverwriteCommands(Snowflake guildId, List<ApplicationCommandRequest> requests) {
        return this.applicationId.flatMapMany(id -> this.restClient.getApplicationService().bulkOverwriteGuildApplicationCommand((long)id, guildId.asLong(), requests).doOnNext(it -> log.debug("Registered command {} at guild {}", new Object[]{it.name(), guildId.asLong()})));
    }
}

