/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice.crypto;

import com.google.crypto.tink.aead.internal.InsecureNonceXChaCha20Poly1305;
import discord4j.voice.crypto.EncryptionAdapter;
import java.security.GeneralSecurityException;

public class Xchacha20Poly1305EncryptionAdapter
implements EncryptionAdapter {
    private static final int NONCE_BYTES = 24;
    private final InsecureNonceXChaCha20Poly1305 cipher;

    public Xchacha20Poly1305EncryptionAdapter(byte[] secretKey) throws GeneralSecurityException {
        this.cipher = new InsecureNonceXChaCha20Poly1305(secretKey);
    }

    @Override
    public int getNonceLength() {
        return 24;
    }

    @Override
    public byte[] encrypt(byte[] header, byte[] audio, byte[] nonce) throws GeneralSecurityException {
        return this.cipher.encrypt(nonce, audio, header);
    }

    @Override
    public byte[] decrypt(byte[] header, byte[] audio, byte[] nonce) throws GeneralSecurityException {
        return this.cipher.decrypt(nonce, audio, header);
    }
}

