/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.util;

import discord4j.discordjson.json.gateway.RequestGuildMembers;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.intent.Intent;
import discord4j.gateway.intent.IntentSet;

public class ValidationUtil {
    public static void validateRequestGuildMembers(RequestGuildMembers request, Possible<IntentSet> possibleIntents) {
        if (request.query().isAbsent() == request.userIds().isAbsent()) {
            throw new IllegalArgumentException("One of query or user ids is required.");
        }
        if (possibleIntents.isAbsent()) {
            return;
        }
        IntentSet intents = (IntentSet)possibleIntents.get();
        boolean requestingPresences = request.presences().toOptional().orElse(false);
        if (requestingPresences && !intents.contains((Object)Intent.GUILD_PRESENCES)) {
            throw new IllegalArgumentException("GUILD_PRESENCES intent is required to set presences = true.");
        }
        if (ValidationUtil.isRequestingEntireList(request) && !intents.contains((Object)Intent.GUILD_MEMBERS)) {
            throw new IllegalArgumentException("GUILD_MEMBERS intent is required to request the entire member list");
        }
    }

    public static boolean isRequestingEntireList(RequestGuildMembers request) {
        return request.query().toOptional().map(String::isEmpty).orElse(false) != false && request.limit() == 0;
    }
}

