/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.annotations.Experimental;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.legacy.LegacyEmbedCreateSpec;
import discord4j.core.spec.legacy.LegacySpec;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Experimental
public class LegacyInteractionApplicationCommandCallbackSpec
implements LegacySpec<InteractionApplicationCommandCallbackData> {
    @Nullable
    private String content;
    private boolean tts;
    private List<EmbedData> embeds;
    private AllowedMentionsData allowedMentionsData;
    private int flags;
    private List<LayoutComponent> components;

    public LegacyInteractionApplicationCommandCallbackSpec setContent(String content) {
        this.content = content;
        return this;
    }

    public LegacyInteractionApplicationCommandCallbackSpec setTts(boolean tts) {
        this.tts = tts;
        return this;
    }

    public LegacyInteractionApplicationCommandCallbackSpec setEphemeral(boolean ephemeral) {
        this.flags = ephemeral ? Message.Flag.EPHEMERAL.getFlag() : 0;
        return this;
    }

    public LegacyInteractionApplicationCommandCallbackSpec addEmbed(Consumer<? super LegacyEmbedCreateSpec> spec) {
        if (this.embeds == null) {
            this.embeds = new ArrayList<EmbedData>(1);
        }
        LegacyEmbedCreateSpec mutatedSpec = new LegacyEmbedCreateSpec();
        spec.accept(mutatedSpec);
        this.embeds.add(mutatedSpec.asRequest());
        return this;
    }

    public LegacyInteractionApplicationCommandCallbackSpec setAllowedMentions(@Nullable AllowedMentions allowedMentions) {
        this.allowedMentionsData = allowedMentions != null ? allowedMentions.toData() : null;
        return this;
    }

    public LegacyInteractionApplicationCommandCallbackSpec setComponents(LayoutComponent ... components) {
        return this.setComponents(Arrays.asList(components));
    }

    public LegacyInteractionApplicationCommandCallbackSpec setComponents(List<LayoutComponent> components) {
        this.components = components;
        return this;
    }

    @Override
    public InteractionApplicationCommandCallbackData asRequest() {
        return InteractionApplicationCommandCallbackData.builder().content(this.content == null ? Possible.absent() : Possible.of((Object)this.content)).tts(Boolean.valueOf(this.tts)).flags(this.flags == 0 ? Possible.absent() : Possible.of((Object)this.flags)).embeds(this.embeds == null ? Possible.absent() : Possible.of(this.embeds)).allowedMentions(this.allowedMentionsData == null ? Possible.absent() : Possible.of((Object)this.allowedMentionsData)).components(this.components == null ? Possible.absent() : Possible.of(this.components.stream().map(MessageComponent::getData).collect(Collectors.toList()))).build();
    }
}

