/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Webhook;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.WebhookExecuteMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class WebhookExecuteMono
extends WebhookExecuteMonoGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final String username_value;
    private final boolean username_absent;
    private final String avatarUrl_value;
    private final boolean avatarUrl_absent;
    private final boolean tts;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final List<EmbedCreateSpec> embeds;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<TopLevelMessageComponent> components_value;
    private final boolean components_absent;
    private final String threadName_value;
    private final boolean threadName_absent;
    private final Snowflake threadId_value;
    private final boolean threadId_absent;
    private final List<Message.Flag> flags_value;
    private final boolean flags_absent;
    private final boolean waitForMessage;
    private final boolean allowComponents;
    private final Webhook webhook;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private WebhookExecuteMono(boolean waitForMessage, boolean allowComponents, Webhook webhook) {
        this.waitForMessage = waitForMessage;
        this.allowComponents = allowComponents;
        this.webhook = Objects.requireNonNull(webhook, "webhook");
        Possible content$impl = Possible.absent();
        Possible username$impl = Possible.absent();
        Possible avatarUrl$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        Possible threadName$impl = Possible.absent();
        Possible threadId$impl = Possible.absent();
        Possible flags$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.threadName_value = threadName$impl.toOptional().orElse(null);
        this.threadName_absent = threadName$impl.isAbsent();
        this.threadId_value = threadId$impl.toOptional().orElse(null);
        this.threadId_absent = threadId$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookExecuteMono(Possible<String> content, Possible<String> username, Possible<String> avatarUrl, boolean tts, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, List<EmbedCreateSpec> embeds, Possible<AllowedMentions> allowedMentions, Possible<List<TopLevelMessageComponent>> components, Possible<String> threadName, Possible<Snowflake> threadId, Possible<List<Message.Flag>> flags, boolean waitForMessage, boolean allowComponents, Webhook webhook) {
        Possible<String> content$impl = content;
        Possible<String> username$impl = username;
        Possible<String> avatarUrl$impl = avatarUrl;
        this.initShim.tts(tts);
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        this.initShim.embeds(embeds);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<List<TopLevelMessageComponent>> components$impl = components;
        Possible<String> threadName$impl = threadName;
        Possible<Snowflake> threadId$impl = threadId;
        Possible<List<Message.Flag>> flags$impl = flags;
        this.waitForMessage = waitForMessage;
        this.allowComponents = allowComponents;
        this.webhook = webhook;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.threadName_value = threadName$impl.toOptional().orElse(null);
        this.threadName_absent = threadName$impl.isAbsent();
        this.threadId_value = threadId$impl.toOptional().orElse(null);
        this.threadId_absent = threadId$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<String> username() {
        return this.username_absent ? Possible.absent() : Possible.of((Object)this.username_value);
    }

    @Override
    public Possible<String> avatarUrl() {
        return this.avatarUrl_absent ? Possible.absent() : Possible.of((Object)this.avatarUrl_value);
    }

    @Override
    public boolean tts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tts() : this.tts;
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public List<EmbedCreateSpec> embeds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeds() : this.embeds;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<List<TopLevelMessageComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public Possible<String> threadName() {
        return this.threadName_absent ? Possible.absent() : Possible.of((Object)this.threadName_value);
    }

    @Override
    public Possible<Snowflake> threadId() {
        return this.threadId_absent ? Possible.absent() : Possible.of((Object)this.threadId_value);
    }

    @Override
    public Possible<List<Message.Flag>> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of(this.flags_value);
    }

    @Override
    public boolean waitForMessage() {
        return this.waitForMessage;
    }

    @Override
    public boolean allowComponents() {
        return this.allowComponents;
    }

    @Override
    public Webhook webhook() {
        return this.webhook;
    }

    public WebhookExecuteMono withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new WebhookExecuteMono(newValue, this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookExecuteMono((Possible<String>)newValue, this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withUsername(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new WebhookExecuteMono(this.content(), newValue, this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withUsername(String value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookExecuteMono(this.content(), (Possible<String>)newValue, this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withAvatarUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new WebhookExecuteMono(this.content(), this.username(), newValue, this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withAvatarUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookExecuteMono(this.content(), this.username(), (Possible<String>)newValue, this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withTts(boolean value) {
        if (this.tts == value) {
            return this;
        }
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), value, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(Arrays.asList(elements), true, false));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(elements, true, false));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(Arrays.asList(elements), true, false));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, newValue, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(elements, true, false));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, newValue, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withEmbeds(EmbedCreateSpec ... elements) {
        List<EmbedCreateSpec> newValue = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(Arrays.asList(elements), true, false));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
        if (this.embeds == elements) {
            return this;
        }
        List<EmbedCreateSpec> newValue = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(elements, true, false));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, newValue, this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, (Possible<AllowedMentions>)newValue, this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withComponents(Possible<List<TopLevelMessageComponent>> possible) {
        Possible<List<TopLevelMessageComponent>> newValue = Objects.requireNonNull(possible);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue, this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withComponents(Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue, this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    @SafeVarargs
    public final WebhookExecuteMono withComponents(TopLevelMessageComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue, this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withThreadName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), newValue, this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withThreadName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), (Possible<String>)newValue, this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withThreadId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), newValue, this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withThreadId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), (Possible<Snowflake>)newValue, this.flags(), this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withFlags(Possible<List<Message.Flag>> possible) {
        Possible<List<Message.Flag>> newValue = Objects.requireNonNull(possible);
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), newValue, this.waitForMessage, this.allowComponents, this.webhook);
    }

    public WebhookExecuteMono withFlags(Iterable<Message.Flag> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), (Possible<List<Message.Flag>>)newValue, this.waitForMessage, this.allowComponents, this.webhook);
    }

    @SafeVarargs
    public final WebhookExecuteMono withFlags(Message.Flag ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), (Possible<List<Message.Flag>>)newValue, this.waitForMessage, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withWaitForMessage(boolean value) {
        if (this.waitForMessage == value) {
            return this;
        }
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), value, this.allowComponents, this.webhook);
    }

    public final WebhookExecuteMono withAllowComponents(boolean value) {
        if (this.allowComponents == value) {
            return this;
        }
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, value, this.webhook);
    }

    public final WebhookExecuteMono withWebhook(Webhook value) {
        if (this.webhook == value) {
            return this;
        }
        Webhook newValue = Objects.requireNonNull(value, "webhook");
        return new WebhookExecuteMono(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags(), this.waitForMessage, this.allowComponents, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookExecuteMono && this.equalTo(0, (WebhookExecuteMono)another);
    }

    private boolean equalTo(int synthetic, WebhookExecuteMono another) {
        return this.content().equals(another.content()) && this.username().equals(another.username()) && this.avatarUrl().equals(another.avatarUrl()) && this.tts == another.tts && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.embeds.equals(another.embeds) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value) && this.threadName().equals(another.threadName()) && this.threadId().equals(another.threadId()) && Objects.equals(this.flags_value, another.flags_value) && this.waitForMessage == another.waitForMessage && this.allowComponents == another.allowComponents && this.webhook.equals(another.webhook);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.username().hashCode();
        h += (h << 5) + this.avatarUrl().hashCode();
        h += (h << 5) + Boolean.hashCode(this.tts);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.embeds.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + this.threadName().hashCode();
        h += (h << 5) + this.threadId().hashCode();
        h += (h << 5) + Objects.hashCode(this.flags_value);
        h += (h << 5) + Boolean.hashCode(this.waitForMessage);
        h += (h << 5) + Boolean.hashCode(this.allowComponents);
        h += (h << 5) + this.webhook.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "WebhookExecuteMono{content=" + this.content().toString() + ", username=" + this.username().toString() + ", avatarUrl=" + this.avatarUrl().toString() + ", tts=" + this.tts + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", embeds=" + this.embeds + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + ", threadName=" + this.threadName().toString() + ", threadId=" + this.threadId().toString() + ", flags=" + Objects.toString(this.flags_value) + ", waitForMessage=" + this.waitForMessage + ", allowComponents=" + this.allowComponents + ", webhook=" + this.webhook + "}";
    }

    public static WebhookExecuteMono of(boolean waitForMessage, boolean allowComponents, Webhook webhook) {
        return new WebhookExecuteMono(waitForMessage, allowComponents, webhook);
    }

    static WebhookExecuteMono copyOf(WebhookExecuteMonoGenerator instance) {
        if (instance instanceof WebhookExecuteMono) {
            return (WebhookExecuteMono)instance;
        }
        return WebhookExecuteMono.of(instance.waitForMessage(), instance.allowComponents(), instance.webhook()).withContent((Possible<String>)instance.content()).withUsername((Possible<String>)instance.username()).withAvatarUrl((Possible<String>)instance.avatarUrl()).withTts(instance.tts()).withFiles(instance.files()).withFileSpoilers(instance.fileSpoilers()).withEmbeds(instance.embeds()).withAllowedMentions((Possible<AllowedMentions>)instance.allowedMentions()).withComponents((Possible<List<TopLevelMessageComponent>>)instance.components()).withThreadName((Possible<String>)instance.threadName()).withThreadId((Possible<Snowflake>)instance.threadId()).withFlags((Possible<List<Message.Flag>>)instance.flags());
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isUsernamePresent() {
        return !this.username_absent;
    }

    public String usernameOrElse(String defaultValue) {
        return !this.username_absent ? this.username_value : defaultValue;
    }

    public boolean isAvatarUrlPresent() {
        return !this.avatarUrl_absent;
    }

    public String avatarUrlOrElse(String defaultValue) {
        return !this.avatarUrl_absent ? this.avatarUrl_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<TopLevelMessageComponent> componentsOrElse(List<TopLevelMessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isThreadNamePresent() {
        return !this.threadName_absent;
    }

    public String threadNameOrElse(String defaultValue) {
        return !this.threadName_absent ? this.threadName_value : defaultValue;
    }

    public boolean isThreadIdPresent() {
        return !this.threadId_absent;
    }

    public Snowflake threadIdOrElse(Snowflake defaultValue) {
        return !this.threadId_absent ? this.threadId_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public List<Message.Flag> flagsOrElse(List<Message.Flag> defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private final class InitShim {
        private byte ttsBuildStage = 0;
        private boolean tts;
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;
        private byte embedsBuildStage = 0;
        private List<EmbedCreateSpec> embeds;

        private InitShim() {
        }

        boolean tts() {
            if (this.ttsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ttsBuildStage == 0) {
                this.ttsBuildStage = (byte)-1;
                this.tts = WebhookExecuteMono.super.tts();
                this.ttsBuildStage = 1;
            }
            return this.tts;
        }

        void tts(boolean tts) {
            this.tts = tts;
            this.ttsBuildStage = 1;
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(WebhookExecuteMono.super.files(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(WebhookExecuteMono.super.fileSpoilers(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        List<EmbedCreateSpec> embeds() {
            if (this.embedsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embedsBuildStage == 0) {
                this.embedsBuildStage = (byte)-1;
                this.embeds = WebhookExecuteMono.createUnmodifiableList(false, WebhookExecuteMono.createSafeList(WebhookExecuteMono.super.embeds(), true, false));
                this.embedsBuildStage = 1;
            }
            return this.embeds;
        }

        void embeds(List<EmbedCreateSpec> embeds) {
            this.embeds = embeds;
            this.embedsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ttsBuildStage == -1) {
                attributes.add("tts");
            }
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            if (this.embedsBuildStage == -1) {
                attributes.add("embeds");
            }
            return "Cannot build WebhookExecuteMono, attribute initializers form cycle " + attributes;
        }
    }
}

