/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.SoundboardSound;
import discord4j.core.spec.SoundboardSoundEditMonoGenerator;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class SoundboardSoundEditMono
extends SoundboardSoundEditMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final String sound_value;
    private final boolean sound_absent;
    private final Double volume_value;
    private final boolean volume_absent;
    private final EmojiData emoji_value;
    private final boolean emoji_absent;
    private final SoundboardSound soundboardSound;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SoundboardSoundEditMono(SoundboardSound soundboardSound) {
        this.soundboardSound = Objects.requireNonNull(soundboardSound, "soundboardSound");
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible sound$impl = Possible.absent();
        Possible volume$impl = Possible.absent();
        Possible emoji$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.sound_value = sound$impl.toOptional().orElse(null);
        this.sound_absent = sound$impl.isAbsent();
        this.volume_value = Possible.flatOpt((Possible)volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emoji_value = Possible.flatOpt((Possible)emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    private SoundboardSoundEditMono(@reactor.util.annotation.Nullable String reason, Possible<String> name, Possible<String> sound, Possible<Optional<Double>> volume, Possible<Optional<EmojiData>> emoji, SoundboardSound soundboardSound) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<String> sound$impl = sound;
        Possible<Optional<Double>> volume$impl = volume;
        Possible<Optional<EmojiData>> emoji$impl = emoji;
        this.soundboardSound = soundboardSound;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.sound_value = sound$impl.toOptional().orElse(null);
        this.sound_absent = sound$impl.isAbsent();
        this.volume_value = Possible.flatOpt(volume$impl).orElse(null);
        this.volume_absent = volume$impl.isAbsent();
        this.emoji_value = Possible.flatOpt(emoji$impl).orElse(null);
        this.emoji_absent = emoji$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<String> sound() {
        return this.sound_absent ? Possible.absent() : Possible.of((Object)this.sound_value);
    }

    @Override
    public Possible<Optional<Double>> volume() {
        return this.volume_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.volume_value));
    }

    @Override
    public Possible<Optional<EmojiData>> emoji() {
        return this.emoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.emoji_value));
    }

    @Override
    public SoundboardSound soundboardSound() {
        return this.soundboardSound;
    }

    public final SoundboardSoundEditMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new SoundboardSoundEditMono(value, this.name(), this.sound(), this.volume(), this.emoji(), this.soundboardSound);
    }

    public SoundboardSoundEditMono withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditMono(this.reason, newValue, this.sound(), this.volume(), this.emoji(), this.soundboardSound);
    }

    public SoundboardSoundEditMono withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new SoundboardSoundEditMono(this.reason, (Possible<String>)newValue, this.sound(), this.volume(), this.emoji(), this.soundboardSound);
    }

    public SoundboardSoundEditMono withSound(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditMono(this.reason, this.name(), newValue, this.volume(), this.emoji(), this.soundboardSound);
    }

    public SoundboardSoundEditMono withSound(String value) {
        Possible newValue = Possible.of((Object)value);
        return new SoundboardSoundEditMono(this.reason, this.name(), (Possible<String>)newValue, this.volume(), this.emoji(), this.soundboardSound);
    }

    public SoundboardSoundEditMono withVolume(Possible<Optional<Double>> value) {
        Possible<Optional<Double>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditMono(this.reason, this.name(), this.sound(), newValue, this.emoji(), this.soundboardSound);
    }

    @Deprecated
    public SoundboardSoundEditMono withVolume(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditMono(this.reason, this.name(), this.sound(), (Possible<Optional<Double>>)newValue, this.emoji(), this.soundboardSound);
    }

    public SoundboardSoundEditMono withVolumeOrNull(@Nullable Double value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditMono(this.reason, this.name(), this.sound(), (Possible<Optional<Double>>)newValue, this.emoji(), this.soundboardSound);
    }

    public SoundboardSoundEditMono withEmoji(Possible<Optional<EmojiData>> value) {
        Possible<Optional<EmojiData>> newValue = Objects.requireNonNull(value);
        return new SoundboardSoundEditMono(this.reason, this.name(), this.sound(), this.volume(), newValue, this.soundboardSound);
    }

    @Deprecated
    public SoundboardSoundEditMono withEmoji(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditMono(this.reason, this.name(), this.sound(), this.volume(), (Possible<Optional<EmojiData>>)newValue, this.soundboardSound);
    }

    public SoundboardSoundEditMono withEmojiOrNull(@Nullable EmojiData value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new SoundboardSoundEditMono(this.reason, this.name(), this.sound(), this.volume(), (Possible<Optional<EmojiData>>)newValue, this.soundboardSound);
    }

    public final SoundboardSoundEditMono withSoundboardSound(SoundboardSound value) {
        if (this.soundboardSound == value) {
            return this;
        }
        SoundboardSound newValue = Objects.requireNonNull(value, "soundboardSound");
        return new SoundboardSoundEditMono(this.reason, this.name(), this.sound(), this.volume(), this.emoji(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SoundboardSoundEditMono && this.equalTo(0, (SoundboardSoundEditMono)another);
    }

    private boolean equalTo(int synthetic, SoundboardSoundEditMono another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.sound().equals(another.sound()) && this.volume().equals(another.volume()) && this.emoji().equals(another.emoji()) && this.soundboardSound.equals(another.soundboardSound);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.sound().hashCode();
        h += (h << 5) + this.volume().hashCode();
        h += (h << 5) + this.emoji().hashCode();
        h += (h << 5) + this.soundboardSound.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "SoundboardSoundEditMono{reason=" + this.reason + ", name=" + this.name().toString() + ", sound=" + this.sound().toString() + ", volume=" + this.volume().toString() + ", emoji=" + this.emoji().toString() + ", soundboardSound=" + this.soundboardSound + "}";
    }

    public static SoundboardSoundEditMono of(SoundboardSound soundboardSound) {
        return new SoundboardSoundEditMono(soundboardSound);
    }

    static SoundboardSoundEditMono copyOf(SoundboardSoundEditMonoGenerator instance) {
        if (instance instanceof SoundboardSoundEditMono) {
            return (SoundboardSoundEditMono)instance;
        }
        return SoundboardSoundEditMono.of(instance.soundboardSound()).withReason(instance.reason()).withName((Possible<String>)instance.name()).withSound((Possible<String>)instance.sound()).withVolume((Possible<Optional<Double>>)instance.volume()).withEmoji((Possible<Optional<EmojiData>>)instance.emoji());
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isSoundPresent() {
        return !this.sound_absent;
    }

    public String soundOrElse(String defaultValue) {
        return !this.sound_absent ? this.sound_value : defaultValue;
    }

    public boolean isVolumePresent() {
        return !this.volume_absent;
    }

    public Double volumeOrElse(Double defaultValue) {
        return !this.volume_absent ? this.volume_value : defaultValue;
    }

    public boolean isEmojiPresent() {
        return !this.emoji_absent;
    }

    public EmojiData emojiOrElse(EmojiData defaultValue) {
        return !this.emoji_absent ? this.emoji_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SoundboardSoundEditMono, attribute initializers form cycle " + attributes;
        }
    }
}

