/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.MessageCreateSpecGenerator;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.json.PollCreateData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class MessageCreateSpec
implements MessageCreateSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final String nonce_value;
    private final boolean nonce_absent;
    private final Boolean enforceNonce_value;
    private final boolean enforceNonce_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final Snowflake messageReferenceId_value;
    private final boolean messageReferenceId_absent;
    private final MessageReferenceData messageReference_value;
    private final boolean messageReference_absent;
    private final List<TopLevelMessageComponent> components_value;
    private final boolean components_absent;
    private final List<Snowflake> stickersIds_value;
    private final boolean stickersIds_absent;
    private final PollCreateData poll_value;
    private final boolean poll_absent;
    private final List<Message.Flag> flags_value;
    private final boolean flags_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final MessageCreateSpec INSTANCE = MessageCreateSpec.validate(new MessageCreateSpec());

    private MessageCreateSpec() {
        Possible content$impl = Possible.absent();
        Possible nonce$impl = Possible.absent();
        Possible enforceNonce$impl = Possible.absent();
        Possible tts$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible messageReferenceId$impl = Possible.absent();
        Possible messageReference$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        Possible stickersIds$impl = Possible.absent();
        Possible poll$impl = Possible.absent();
        Possible flags$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.enforceNonce_value = enforceNonce$impl.toOptional().orElse(null);
        this.enforceNonce_absent = enforceNonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReferenceId_value = messageReferenceId$impl.toOptional().orElse(null);
        this.messageReferenceId_absent = messageReferenceId$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.stickersIds_value = stickersIds$impl.toOptional().orElse(null);
        this.stickersIds_absent = stickersIds$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageCreateSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible nonce$impl = builder.nonce_build();
        Possible enforceNonce$impl = builder.enforceNonce_build();
        Possible tts$impl = builder.tts_build();
        Possible embeds$impl = builder.embeds_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible messageReferenceId$impl = builder.messageReferenceId_build();
        Possible messageReference$impl = builder.messageReference_build();
        Possible components$impl = builder.components_build();
        Possible stickersIds$impl = builder.stickersIds_build();
        Possible poll$impl = builder.poll_build();
        Possible flags$impl = builder.flags_build();
        if (builder.filesIsSet()) {
            this.initShim.files(MessageCreateSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(MessageCreateSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.enforceNonce_value = enforceNonce$impl.toOptional().orElse(null);
        this.enforceNonce_absent = enforceNonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReferenceId_value = messageReferenceId$impl.toOptional().orElse(null);
        this.messageReferenceId_absent = messageReferenceId$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.stickersIds_value = stickersIds$impl.toOptional().orElse(null);
        this.stickersIds_absent = stickersIds$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageCreateSpec(Possible<String> content, Possible<String> nonce, Possible<Boolean> enforceNonce, Possible<Boolean> tts, Possible<List<EmbedCreateSpec>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<AllowedMentions> allowedMentions, Possible<Snowflake> messageReferenceId, Possible<MessageReferenceData> messageReference, Possible<List<TopLevelMessageComponent>> components, Possible<List<Snowflake>> stickersIds, Possible<PollCreateData> poll, Possible<List<Message.Flag>> flags) {
        Possible<String> content$impl = content;
        Possible<String> nonce$impl = nonce;
        Possible<Boolean> enforceNonce$impl = enforceNonce;
        Possible<Boolean> tts$impl = tts;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<Snowflake> messageReferenceId$impl = messageReferenceId;
        Possible<MessageReferenceData> messageReference$impl = messageReference;
        Possible<List<TopLevelMessageComponent>> components$impl = components;
        Possible<List<Snowflake>> stickersIds$impl = stickersIds;
        Possible<PollCreateData> poll$impl = poll;
        Possible<List<Message.Flag>> flags$impl = flags;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.enforceNonce_value = enforceNonce$impl.toOptional().orElse(null);
        this.enforceNonce_absent = enforceNonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReferenceId_value = messageReferenceId$impl.toOptional().orElse(null);
        this.messageReferenceId_absent = messageReferenceId$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.stickersIds_value = stickersIds$impl.toOptional().orElse(null);
        this.stickersIds_absent = stickersIds$impl.isAbsent();
        this.poll_value = poll$impl.toOptional().orElse(null);
        this.poll_absent = poll$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return MessageCreateSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return MessageCreateSpecGenerator.super.fileSpoilers();
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<String> nonce() {
        return this.nonce_absent ? Possible.absent() : Possible.of((Object)this.nonce_value);
    }

    @Override
    public Possible<Boolean> enforceNonce() {
        return this.enforceNonce_absent ? Possible.absent() : Possible.of((Object)this.enforceNonce_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    @Deprecated
    public Possible<Snowflake> messageReferenceId() {
        return this.messageReferenceId_absent ? Possible.absent() : Possible.of((Object)this.messageReferenceId_value);
    }

    @Override
    public Possible<MessageReferenceData> messageReference() {
        return this.messageReference_absent ? Possible.absent() : Possible.of((Object)this.messageReference_value);
    }

    @Override
    public Possible<List<TopLevelMessageComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public Possible<List<Snowflake>> stickersIds() {
        return this.stickersIds_absent ? Possible.absent() : Possible.of(this.stickersIds_value);
    }

    @Override
    public Possible<PollCreateData> poll() {
        return this.poll_absent ? Possible.absent() : Possible.of((Object)this.poll_value);
    }

    @Override
    public Possible<List<Message.Flag>> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of(this.flags_value);
    }

    public MessageCreateSpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(newValue, this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec((Possible<String>)newValue, this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withNonce(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), newValue, this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withNonce(String value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), (Possible<String>)newValue, this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withEnforceNonce(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withEnforceNonce(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), (Possible<Boolean>)newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), (Possible<Boolean>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    @SafeVarargs
    public final MessageCreateSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public final MessageCreateSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public final MessageCreateSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(elements, true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public final MessageCreateSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public final MessageCreateSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(elements, true, false));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, newValue, this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, (Possible<AllowedMentions>)newValue, this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withMessageReferenceId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withMessageReferenceId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Snowflake>)newValue, this.messageReference(), this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withMessageReference(Possible<MessageReferenceData> value) {
        Possible<MessageReferenceData> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), newValue, this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withMessageReference(MessageReferenceData value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), (Possible<MessageReferenceData>)newValue, this.components(), this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withComponents(Possible<List<TopLevelMessageComponent>> possible) {
        Possible<List<TopLevelMessageComponent>> newValue = Objects.requireNonNull(possible);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), newValue, this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withComponents(Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), (Possible<List<TopLevelMessageComponent>>)newValue, this.stickersIds(), this.poll(), this.flags()));
    }

    @SafeVarargs
    public final MessageCreateSpec withComponents(TopLevelMessageComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), (Possible<List<TopLevelMessageComponent>>)newValue, this.stickersIds(), this.poll(), this.flags()));
    }

    public MessageCreateSpec withStickersIds(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), newValue, this.poll(), this.flags()));
    }

    public MessageCreateSpec withStickersIds(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), (Possible<List<Snowflake>>)newValue, this.poll(), this.flags()));
    }

    @SafeVarargs
    public final MessageCreateSpec withStickersIds(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), (Possible<List<Snowflake>>)newValue, this.poll(), this.flags()));
    }

    public MessageCreateSpec withPoll(Possible<PollCreateData> value) {
        Possible<PollCreateData> newValue = Objects.requireNonNull(value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), newValue, this.flags()));
    }

    public MessageCreateSpec withPoll(PollCreateData value) {
        Possible newValue = Possible.of((Object)value);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), (Possible<PollCreateData>)newValue, this.flags()));
    }

    public MessageCreateSpec withFlags(Possible<List<Message.Flag>> possible) {
        Possible<List<Message.Flag>> newValue = Objects.requireNonNull(possible);
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), newValue));
    }

    public MessageCreateSpec withFlags(Iterable<Message.Flag> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), (Possible<List<Message.Flag>>)newValue));
    }

    @SafeVarargs
    public final MessageCreateSpec withFlags(Message.Flag ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return MessageCreateSpec.validate(new MessageCreateSpec(this.content(), this.nonce(), this.enforceNonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReferenceId(), this.messageReference(), this.components(), this.stickersIds(), this.poll(), (Possible<List<Message.Flag>>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageCreateSpec && this.equalTo(0, (MessageCreateSpec)another);
    }

    private boolean equalTo(int synthetic, MessageCreateSpec another) {
        return this.content().equals(another.content()) && this.nonce().equals(another.nonce()) && this.enforceNonce().equals(another.enforceNonce()) && this.tts().equals(another.tts()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && this.messageReferenceId().equals(another.messageReferenceId()) && this.messageReference().equals(another.messageReference()) && Objects.equals(this.components_value, another.components_value) && Objects.equals(this.stickersIds_value, another.stickersIds_value) && this.poll().equals(another.poll()) && Objects.equals(this.flags_value, another.flags_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.enforceNonce().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + this.messageReferenceId().hashCode();
        h += (h << 5) + this.messageReference().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + Objects.hashCode(this.stickersIds_value);
        h += (h << 5) + this.poll().hashCode();
        h += (h << 5) + Objects.hashCode(this.flags_value);
        return h;
    }

    public String toString() {
        return "MessageCreateSpec{content=" + this.content().toString() + ", nonce=" + this.nonce().toString() + ", enforceNonce=" + this.enforceNonce().toString() + ", tts=" + this.tts().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", messageReferenceId=" + this.messageReferenceId().toString() + ", messageReference=" + this.messageReference().toString() + ", components=" + Objects.toString(this.components_value) + ", stickersIds=" + Objects.toString(this.stickersIds_value) + ", poll=" + this.poll().toString() + ", flags=" + Objects.toString(this.flags_value) + "}";
    }

    public static MessageCreateSpec create() {
        return INSTANCE;
    }

    private static MessageCreateSpec validate(MessageCreateSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static MessageCreateSpec copyOf(MessageCreateSpecGenerator instance) {
        if (instance instanceof MessageCreateSpec) {
            return (MessageCreateSpec)instance;
        }
        return MessageCreateSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isNoncePresent() {
        return !this.nonce_absent;
    }

    public String nonceOrElse(String defaultValue) {
        return !this.nonce_absent ? this.nonce_value : defaultValue;
    }

    public boolean isEnforceNoncePresent() {
        return !this.enforceNonce_absent;
    }

    public Boolean enforceNonceOrElse(Boolean defaultValue) {
        return !this.enforceNonce_absent ? this.enforceNonce_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isMessageReferenceIdPresent() {
        return !this.messageReferenceId_absent;
    }

    public Snowflake messageReferenceIdOrElse(Snowflake defaultValue) {
        return !this.messageReferenceId_absent ? this.messageReferenceId_value : defaultValue;
    }

    public boolean isMessageReferencePresent() {
        return !this.messageReference_absent;
    }

    public MessageReferenceData messageReferenceOrElse(MessageReferenceData defaultValue) {
        return !this.messageReference_absent ? this.messageReference_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<TopLevelMessageComponent> componentsOrElse(List<TopLevelMessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isStickersIdsPresent() {
        return !this.stickersIds_absent;
    }

    public List<Snowflake> stickersIdsOrElse(List<Snowflake> defaultValue) {
        return !this.stickersIds_absent ? this.stickersIds_value : defaultValue;
    }

    public boolean isPollPresent() {
        return !this.poll_absent;
    }

    public PollCreateData pollOrElse(PollCreateData defaultValue) {
        return !this.poll_absent ? this.poll_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public List<Message.Flag> flagsOrElse(List<Message.Flag> defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_FILES = 1L;
        private static final long OPT_BIT_FILE_SPOILERS = 2L;
        private long optBits;
        private Possible<String> content_possible = Possible.absent();
        private Possible<String> nonce_possible = Possible.absent();
        private Possible<Boolean> enforceNonce_possible = Possible.absent();
        private Possible<Boolean> tts_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
        private Possible<Snowflake> messageReferenceId_possible = Possible.absent();
        private Possible<MessageReferenceData> messageReference_possible = Possible.absent();
        private List<TopLevelMessageComponent> components_list = null;
        private List<Snowflake> stickersIds_list = null;
        private Possible<PollCreateData> poll_possible = Possible.absent();
        private List<Message.Flag> flags_list = null;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();

        private Builder() {
        }

        public final Builder from(MessageCreateSpec instance) {
            return this.from((MessageCreateSpecGenerator)instance);
        }

        final Builder from(MessageCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.nonce(instance.nonce());
            this.enforceNonce(instance.enforceNonce());
            this.tts(instance.tts());
            this.embeds(instance.embeds());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.allowedMentions(instance.allowedMentions());
            this.messageReferenceId(instance.messageReferenceId());
            this.messageReference(instance.messageReference());
            this.components(instance.components());
            this.stickersIds(instance.stickersIds());
            this.poll(instance.poll());
            this.flags(instance.flags());
            return this;
        }

        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        public Builder content(String value) {
            this.content_possible = Possible.of((Object)value);
            return this;
        }

        public Builder nonce(Possible<String> value) {
            this.nonce_possible = value;
            return this;
        }

        public Builder nonce(String value) {
            this.nonce_possible = Possible.of((Object)value);
            return this;
        }

        public Builder enforceNonce(Possible<Boolean> value) {
            this.enforceNonce_possible = value;
            return this;
        }

        public Builder enforceNonce(Boolean value) {
            this.enforceNonce_possible = Possible.of((Object)value);
            return this;
        }

        public Builder tts(Possible<Boolean> value) {
            this.tts_possible = value;
            return this;
        }

        public Builder tts(Boolean value) {
            this.tts_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            return this;
        }

        public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
            this.embeds_list = null;
            elements.toOptional().ifPresent(e -> this.embeds_getOrCreate().addAll((Collection<EmbedCreateSpec>)e));
            return this;
        }

        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            return this;
        }

        public Builder embeds(Iterable<EmbedCreateSpec> elements) {
            this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public Builder allowedMentions(Possible<AllowedMentions> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        public Builder allowedMentions(AllowedMentions value) {
            this.allowedMentions_possible = Possible.of((Object)value);
            return this;
        }

        public Builder messageReferenceId(Possible<Snowflake> value) {
            this.messageReferenceId_possible = value;
            return this;
        }

        public Builder messageReferenceId(Snowflake value) {
            this.messageReferenceId_possible = Possible.of((Object)value);
            return this;
        }

        public Builder messageReference(Possible<MessageReferenceData> value) {
            this.messageReference_possible = value;
            return this;
        }

        public Builder messageReference(MessageReferenceData value) {
            this.messageReference_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addComponent(TopLevelMessageComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        public Builder addAllComponents(List<TopLevelMessageComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        public Builder components(Possible<List<TopLevelMessageComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<TopLevelMessageComponent>)e));
            return this;
        }

        public Builder components(List<TopLevelMessageComponent> elements) {
            this.components_list = new ArrayList<TopLevelMessageComponent>(elements);
            return this;
        }

        public Builder components(Iterable<TopLevelMessageComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder addStickersId(Snowflake element) {
            this.stickersIds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllStickersIds(List<Snowflake> elements) {
            this.stickersIds_getOrCreate().addAll(elements);
            return this;
        }

        public Builder stickersIds(Possible<List<Snowflake>> elements) {
            this.stickersIds_list = null;
            elements.toOptional().ifPresent(e -> this.stickersIds_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        public Builder stickersIds(List<Snowflake> elements) {
            this.stickersIds_list = new ArrayList<Snowflake>(elements);
            return this;
        }

        public Builder stickersIds(Iterable<Snowflake> elements) {
            this.stickersIds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder poll(Possible<PollCreateData> value) {
            this.poll_possible = value;
            return this;
        }

        public Builder poll(PollCreateData value) {
            this.poll_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addFlag(Message.Flag element) {
            this.flags_getOrCreate().add(element);
            return this;
        }

        public Builder addAllFlags(List<Message.Flag> elements) {
            this.flags_getOrCreate().addAll(elements);
            return this;
        }

        public Builder flags(Possible<List<Message.Flag>> elements) {
            this.flags_list = null;
            elements.toOptional().ifPresent(e -> this.flags_getOrCreate().addAll((Collection<Message.Flag>)e));
            return this;
        }

        public Builder flags(List<Message.Flag> elements) {
            this.flags_list = new ArrayList<Message.Flag>(elements);
            return this;
        }

        public Builder flags(Iterable<Message.Flag> elements) {
            this.flags_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public MessageCreateSpec build() {
            return MessageCreateSpec.validate(new MessageCreateSpec(this));
        }

        private boolean filesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<String> nonce_build() {
            return this.nonce_possible;
        }

        private Possible<Boolean> enforceNonce_build() {
            return this.enforceNonce_possible;
        }

        private Possible<Boolean> tts_build() {
            return this.tts_possible;
        }

        private Possible<List<EmbedCreateSpec>> embeds_build() {
            return this.embeds_list == null ? Possible.absent() : Possible.of(this.embeds_list);
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private Possible<AllowedMentions> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<Snowflake> messageReferenceId_build() {
            return this.messageReferenceId_possible;
        }

        private Possible<MessageReferenceData> messageReference_build() {
            return this.messageReference_possible;
        }

        private Possible<List<TopLevelMessageComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<TopLevelMessageComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<TopLevelMessageComponent>();
            }
            return this.components_list;
        }

        private Possible<List<Snowflake>> stickersIds_build() {
            return this.stickersIds_list == null ? Possible.absent() : Possible.of(this.stickersIds_list);
        }

        private List<Snowflake> stickersIds_getOrCreate() {
            if (this.stickersIds_list == null) {
                this.stickersIds_list = new ArrayList<Snowflake>();
            }
            return this.stickersIds_list;
        }

        private Possible<PollCreateData> poll_build() {
            return this.poll_possible;
        }

        private Possible<List<Message.Flag>> flags_build() {
            return this.flags_list == null ? Possible.absent() : Possible.of(this.flags_list);
        }

        private List<Message.Flag> flags_getOrCreate() {
            if (this.flags_list == null) {
                this.flags_list = new ArrayList<Message.Flag>();
            }
            return this.flags_list;
        }
    }

    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(MessageCreateSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = MessageCreateSpec.createUnmodifiableList(false, MessageCreateSpec.createSafeList(MessageCreateSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build MessageCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

