/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.component.BaseMessageComponent;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.FollowupMessageRequest;
import discord4j.discordjson.json.ImmutableFollowupMessageRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
interface InteractionFollowupCreateSpecGenerator
extends Spec<MultipartRequest<FollowupMessageRequest>> {
    public Possible<String> content();

    public Possible<String> username();

    public Possible<String> avatarUrl();

    @Value.Default
    default public boolean tts() {
        return false;
    }

    @Value.Default
    default public List<MessageCreateFields.File> files() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<EmbedCreateSpec> embeds() {
        return Collections.emptyList();
    }

    public Possible<AllowedMentions> allowedMentions();

    public Possible<List<TopLevelMessageComponent>> components();

    public Possible<Boolean> ephemeral();

    @Override
    default public MultipartRequest<FollowupMessageRequest> asRequest() {
        ArrayList<Message.Flag> flagsToApply = new ArrayList<Message.Flag>();
        if (this.ephemeral().toOptional().orElse(false).booleanValue()) {
            flagsToApply.add(Message.Flag.EPHEMERAL);
        }
        if (!this.components().isAbsent() && ((List)this.components().get()).stream().anyMatch(topLevelComponent -> topLevelComponent.getType().isRequiredFlag())) {
            flagsToApply.add(Message.Flag.IS_COMPONENTS_V2);
        }
        Possible pFlagsToApply = Possible.of(flagsToApply);
        ImmutableFollowupMessageRequest request = FollowupMessageRequest.builder().content(this.content()).username(this.username()).avatarUrl(this.avatarUrl()).tts(Boolean.valueOf(this.tts())).embeds(this.embeds().stream().map(EmbedCreateSpecGenerator::asRequest).collect(Collectors.toList())).allowedMentions(InternalSpecUtils.mapPossible(this.allowedMentions(), AllowedMentions::toData)).components(InternalSpecUtils.mapPossible(this.components(), components -> components.stream().map(BaseMessageComponent::getData).collect(Collectors.toList()))).flags(InternalSpecUtils.mapPossible(pFlagsToApply, f -> f.stream().mapToInt(Message.Flag::getFlag).reduce(0, (left, right) -> left | right))).build();
        return MultipartRequest.ofRequestAndFiles((Object)request, Stream.concat(this.files().stream(), this.fileSpoilers().stream()).map(MessageCreateFields.File::asRequest).collect(Collectors.toList()));
    }
}

