/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.GuildTemplateEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class GuildTemplateEditSpec
implements GuildTemplateEditSpecGenerator {
    private final String name_value;
    private final boolean name_absent;
    private final String description_value;
    private final boolean description_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final GuildTemplateEditSpec INSTANCE = GuildTemplateEditSpec.validate(new GuildTemplateEditSpec());

    private GuildTemplateEditSpec() {
        Possible name$impl = Possible.absent();
        Possible description$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.description_value = Possible.flatOpt((Possible)description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    private GuildTemplateEditSpec(Possible<String> name, Possible<Optional<String>> description) {
        Possible<String> name$impl = name;
        Possible<Optional<String>> description$impl = description;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<Optional<String>> description() {
        return this.description_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.description_value));
    }

    public GuildTemplateEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return GuildTemplateEditSpec.validate(new GuildTemplateEditSpec(newValue, this.description()));
    }

    public GuildTemplateEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return GuildTemplateEditSpec.validate(new GuildTemplateEditSpec((Possible<String>)newValue, this.description()));
    }

    public GuildTemplateEditSpec withDescription(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return GuildTemplateEditSpec.validate(new GuildTemplateEditSpec(this.name(), newValue));
    }

    @Deprecated
    public GuildTemplateEditSpec withDescription(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return GuildTemplateEditSpec.validate(new GuildTemplateEditSpec(this.name(), (Possible<Optional<String>>)newValue));
    }

    public GuildTemplateEditSpec withDescriptionOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return GuildTemplateEditSpec.validate(new GuildTemplateEditSpec(this.name(), (Possible<Optional<String>>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildTemplateEditSpec && this.equalTo(0, (GuildTemplateEditSpec)another);
    }

    private boolean equalTo(int synthetic, GuildTemplateEditSpec another) {
        return this.name().equals(another.name()) && this.description().equals(another.description());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.description().hashCode();
        return h;
    }

    public String toString() {
        return "GuildTemplateEditSpec{name=" + this.name().toString() + ", description=" + this.description().toString() + "}";
    }

    public static GuildTemplateEditSpec create() {
        return INSTANCE;
    }

    private static GuildTemplateEditSpec validate(GuildTemplateEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static GuildTemplateEditSpec copyOf(GuildTemplateEditSpecGenerator instance) {
        if (instance instanceof GuildTemplateEditSpec) {
            return (GuildTemplateEditSpec)instance;
        }
        return GuildTemplateEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Optional<String>> description_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(GuildTemplateEditSpec instance) {
            return this.from((GuildTemplateEditSpecGenerator)instance);
        }

        final Builder from(GuildTemplateEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.description(instance.description());
            return this;
        }

        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        public Builder description(Possible<Optional<String>> value) {
            this.description_possible = value;
            return this;
        }

        @Deprecated
        public Builder description(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder descriptionOrNull(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public GuildTemplateEditSpec build() {
            return GuildTemplateEditSpec.validate(new GuildTemplateEditSpec(this.name_build(), this.description_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Optional<String>> description_build() {
            return this.description_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildTemplateEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

