/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildBanQueryMonoGenerator;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GuildBanQueryMono
extends GuildBanQueryMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    @reactor.util.annotation.Nullable
    private final Integer deleteMessageSeconds;
    @reactor.util.annotation.Nullable
    private final Integer deleteMessageDays;
    private final Snowflake userId;
    private final Guild guild;

    private GuildBanQueryMono(Snowflake userId, Guild guild) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        this.deleteMessageSeconds = null;
        this.deleteMessageDays = null;
    }

    private GuildBanQueryMono(@reactor.util.annotation.Nullable String reason, @reactor.util.annotation.Nullable Integer deleteMessageSeconds, @reactor.util.annotation.Nullable Integer deleteMessageDays, Snowflake userId, Guild guild) {
        this.reason = reason;
        this.deleteMessageSeconds = deleteMessageSeconds;
        this.deleteMessageDays = deleteMessageDays;
        this.userId = userId;
        this.guild = guild;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Integer deleteMessageSeconds() {
        return this.deleteMessageSeconds;
    }

    @Override
    @Deprecated
    @reactor.util.annotation.Nullable
    public Integer deleteMessageDays() {
        return this.deleteMessageDays;
    }

    @Override
    public Snowflake userId() {
        return this.userId;
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final GuildBanQueryMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new GuildBanQueryMono(value, this.deleteMessageSeconds, this.deleteMessageDays, this.userId, this.guild);
    }

    public final GuildBanQueryMono withDeleteMessageSeconds(@reactor.util.annotation.Nullable Integer value) {
        if (Objects.equals(this.deleteMessageSeconds, value)) {
            return this;
        }
        return new GuildBanQueryMono(this.reason, value, this.deleteMessageDays, this.userId, this.guild);
    }

    @Deprecated
    public final GuildBanQueryMono withDeleteMessageDays(@reactor.util.annotation.Nullable Integer value) {
        if (Objects.equals(this.deleteMessageDays, value)) {
            return this;
        }
        return new GuildBanQueryMono(this.reason, this.deleteMessageSeconds, value, this.userId, this.guild);
    }

    public final GuildBanQueryMono withUserId(Snowflake value) {
        if (this.userId == value) {
            return this;
        }
        Snowflake newValue = Objects.requireNonNull(value, "userId");
        return new GuildBanQueryMono(this.reason, this.deleteMessageSeconds, this.deleteMessageDays, newValue, this.guild);
    }

    public final GuildBanQueryMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new GuildBanQueryMono(this.reason, this.deleteMessageSeconds, this.deleteMessageDays, this.userId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildBanQueryMono && this.equalTo(0, (GuildBanQueryMono)another);
    }

    private boolean equalTo(int synthetic, GuildBanQueryMono another) {
        return Objects.equals(this.reason, another.reason) && Objects.equals(this.deleteMessageSeconds, another.deleteMessageSeconds) && Objects.equals(this.deleteMessageDays, another.deleteMessageDays) && this.userId.equals((Object)another.userId) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + Objects.hashCode(this.deleteMessageSeconds);
        h += (h << 5) + Objects.hashCode(this.deleteMessageDays);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "GuildBanQueryMono{reason=" + this.reason + ", deleteMessageSeconds=" + this.deleteMessageSeconds + ", deleteMessageDays=" + this.deleteMessageDays + ", userId=" + this.userId + ", guild=" + this.guild + "}";
    }

    public static GuildBanQueryMono of(Snowflake userId, Guild guild) {
        return new GuildBanQueryMono(userId, guild);
    }

    static GuildBanQueryMono copyOf(GuildBanQueryMonoGenerator instance) {
        if (instance instanceof GuildBanQueryMono) {
            return (GuildBanQueryMono)instance;
        }
        return GuildBanQueryMono.of(instance.userId(), instance.guild()).withReason(instance.reason()).withDeleteMessageSeconds(instance.deleteMessageSeconds()).withDeleteMessageDays(instance.deleteMessageDays());
    }
}

