/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.EntitlementListRequestSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class EntitlementListRequestSpec
implements EntitlementListRequestSpecGenerator {
    private final Snowflake userId_value;
    private final boolean userId_absent;
    private final List<Snowflake> skuIds_value;
    private final boolean skuIds_absent;
    private final Snowflake before_value;
    private final boolean before_absent;
    private final Snowflake after_value;
    private final boolean after_absent;
    private final Integer limit_value;
    private final boolean limit_absent;
    private final Snowflake guildId_value;
    private final boolean guildId_absent;
    private final Boolean excludeEnded_value;
    private final boolean excludeEnded_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private EntitlementListRequestSpec(Possible<Snowflake> userId, Possible<List<Snowflake>> skuIds, Possible<Snowflake> before, Possible<Snowflake> after, Possible<Integer> limit, Possible<Snowflake> guildId, Possible<Boolean> excludeEnded) {
        Possible<Snowflake> userId$impl = userId;
        Possible<List<Snowflake>> skuIds$impl = skuIds;
        Possible<Snowflake> before$impl = before;
        Possible<Snowflake> after$impl = after;
        Possible<Integer> limit$impl = limit;
        Possible<Snowflake> guildId$impl = guildId;
        Possible<Boolean> excludeEnded$impl = excludeEnded;
        this.userId_value = userId$impl.toOptional().orElse(null);
        this.userId_absent = userId$impl.isAbsent();
        this.skuIds_value = skuIds$impl.toOptional().orElse(null);
        this.skuIds_absent = skuIds$impl.isAbsent();
        this.before_value = before$impl.toOptional().orElse(null);
        this.before_absent = before$impl.isAbsent();
        this.after_value = after$impl.toOptional().orElse(null);
        this.after_absent = after$impl.isAbsent();
        this.limit_value = limit$impl.toOptional().orElse(null);
        this.limit_absent = limit$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.excludeEnded_value = excludeEnded$impl.toOptional().orElse(null);
        this.excludeEnded_absent = excludeEnded$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<Snowflake> userId() {
        return this.userId_absent ? Possible.absent() : Possible.of((Object)this.userId_value);
    }

    @Override
    public Possible<List<Snowflake>> skuIds() {
        return this.skuIds_absent ? Possible.absent() : Possible.of(this.skuIds_value);
    }

    @Override
    public Possible<Snowflake> before() {
        return this.before_absent ? Possible.absent() : Possible.of((Object)this.before_value);
    }

    @Override
    public Possible<Snowflake> after() {
        return this.after_absent ? Possible.absent() : Possible.of((Object)this.after_value);
    }

    @Override
    public Possible<Integer> limit() {
        return this.limit_absent ? Possible.absent() : Possible.of((Object)this.limit_value);
    }

    @Override
    public Possible<Snowflake> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)this.guildId_value);
    }

    @Override
    public Possible<Boolean> excludeEnded() {
        return this.excludeEnded_absent ? Possible.absent() : Possible.of((Object)this.excludeEnded_value);
    }

    public EntitlementListRequestSpec withUserId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestSpec(newValue, this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withUserId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestSpec((Possible<Snowflake>)newValue, this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withSkuIds(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new EntitlementListRequestSpec(this.userId(), newValue, this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withSkuIds(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new EntitlementListRequestSpec(this.userId(), (Possible<List<Snowflake>>)newValue, this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded());
    }

    @SafeVarargs
    public final EntitlementListRequestSpec withSkuIds(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new EntitlementListRequestSpec(this.userId(), (Possible<List<Snowflake>>)newValue, this.before(), this.after(), this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withBefore(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), newValue, this.after(), this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withBefore(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), (Possible<Snowflake>)newValue, this.after(), this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withAfter(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), newValue, this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withAfter(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), (Possible<Snowflake>)newValue, this.limit(), this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withLimit(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), this.after(), newValue, this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withLimit(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), this.after(), (Possible<Integer>)newValue, this.guildId(), this.excludeEnded());
    }

    public EntitlementListRequestSpec withGuildId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), newValue, this.excludeEnded());
    }

    public EntitlementListRequestSpec withGuildId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), (Possible<Snowflake>)newValue, this.excludeEnded());
    }

    public EntitlementListRequestSpec withExcludeEnded(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), newValue);
    }

    public EntitlementListRequestSpec withExcludeEnded(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new EntitlementListRequestSpec(this.userId(), this.skuIds(), this.before(), this.after(), this.limit(), this.guildId(), (Possible<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EntitlementListRequestSpec && this.equalTo(0, (EntitlementListRequestSpec)another);
    }

    private boolean equalTo(int synthetic, EntitlementListRequestSpec another) {
        return this.userId().equals(another.userId()) && Objects.equals(this.skuIds_value, another.skuIds_value) && this.before().equals(another.before()) && this.after().equals(another.after()) && this.limit().equals(another.limit()) && this.guildId().equals(another.guildId()) && this.excludeEnded().equals(another.excludeEnded());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId().hashCode();
        h += (h << 5) + Objects.hashCode(this.skuIds_value);
        h += (h << 5) + this.before().hashCode();
        h += (h << 5) + this.after().hashCode();
        h += (h << 5) + this.limit().hashCode();
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.excludeEnded().hashCode();
        return h;
    }

    public String toString() {
        return "EntitlementListRequestSpec{userId=" + this.userId().toString() + ", skuIds=" + Objects.toString(this.skuIds_value) + ", before=" + this.before().toString() + ", after=" + this.after().toString() + ", limit=" + this.limit().toString() + ", guildId=" + this.guildId().toString() + ", excludeEnded=" + this.excludeEnded().toString() + "}";
    }

    public static EntitlementListRequestSpec copyOf(EntitlementListRequestSpecGenerator instance) {
        if (instance instanceof EntitlementListRequestSpec) {
            return (EntitlementListRequestSpec)instance;
        }
        return EntitlementListRequestSpec.builder().from(instance).build();
    }

    public boolean isUserIdPresent() {
        return !this.userId_absent;
    }

    public Snowflake userIdOrElse(Snowflake defaultValue) {
        return !this.userId_absent ? this.userId_value : defaultValue;
    }

    public boolean isSkuIdsPresent() {
        return !this.skuIds_absent;
    }

    public List<Snowflake> skuIdsOrElse(List<Snowflake> defaultValue) {
        return !this.skuIds_absent ? this.skuIds_value : defaultValue;
    }

    public boolean isBeforePresent() {
        return !this.before_absent;
    }

    public Snowflake beforeOrElse(Snowflake defaultValue) {
        return !this.before_absent ? this.before_value : defaultValue;
    }

    public boolean isAfterPresent() {
        return !this.after_absent;
    }

    public Snowflake afterOrElse(Snowflake defaultValue) {
        return !this.after_absent ? this.after_value : defaultValue;
    }

    public boolean isLimitPresent() {
        return !this.limit_absent;
    }

    public Integer limitOrElse(Integer defaultValue) {
        return !this.limit_absent ? this.limit_value : defaultValue;
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public Snowflake guildIdOrElse(Snowflake defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isExcludeEndedPresent() {
        return !this.excludeEnded_absent;
    }

    public Boolean excludeEndedOrElse(Boolean defaultValue) {
        return !this.excludeEnded_absent ? this.excludeEnded_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<Snowflake> userId_possible = Possible.absent();
        private List<Snowflake> skuIds_list = null;
        private Possible<Snowflake> before_possible = Possible.absent();
        private Possible<Snowflake> after_possible = Possible.absent();
        private Possible<Integer> limit_possible = Possible.absent();
        private Possible<Snowflake> guildId_possible = Possible.absent();
        private Possible<Boolean> excludeEnded_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(EntitlementListRequestSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.userId(instance.userId());
            this.skuIds(instance.skuIds());
            this.before(instance.before());
            this.after(instance.after());
            this.limit(instance.limit());
            this.guildId(instance.guildId());
            this.excludeEnded(instance.excludeEnded());
            return this;
        }

        public Builder userId(Possible<Snowflake> value) {
            this.userId_possible = value;
            return this;
        }

        public Builder userId(Snowflake value) {
            this.userId_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addSkuId(Snowflake element) {
            this.skuIds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllSkuIds(List<Snowflake> elements) {
            this.skuIds_getOrCreate().addAll(elements);
            return this;
        }

        public Builder skuIds(Possible<List<Snowflake>> elements) {
            this.skuIds_list = null;
            elements.toOptional().ifPresent(e -> this.skuIds_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        public Builder skuIds(List<Snowflake> elements) {
            this.skuIds_list = new ArrayList<Snowflake>(elements);
            return this;
        }

        public Builder skuIds(Iterable<Snowflake> elements) {
            this.skuIds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder before(Possible<Snowflake> value) {
            this.before_possible = value;
            return this;
        }

        public Builder before(Snowflake value) {
            this.before_possible = Possible.of((Object)value);
            return this;
        }

        public Builder after(Possible<Snowflake> value) {
            this.after_possible = value;
            return this;
        }

        public Builder after(Snowflake value) {
            this.after_possible = Possible.of((Object)value);
            return this;
        }

        public Builder limit(Possible<Integer> value) {
            this.limit_possible = value;
            return this;
        }

        public Builder limit(Integer value) {
            this.limit_possible = Possible.of((Object)value);
            return this;
        }

        public Builder guildId(Possible<Snowflake> value) {
            this.guildId_possible = value;
            return this;
        }

        public Builder guildId(Snowflake value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        public Builder excludeEnded(Possible<Boolean> value) {
            this.excludeEnded_possible = value;
            return this;
        }

        public Builder excludeEnded(Boolean value) {
            this.excludeEnded_possible = Possible.of((Object)value);
            return this;
        }

        public EntitlementListRequestSpec build() {
            return new EntitlementListRequestSpec(this.userId_build(), this.skuIds_build(), this.before_build(), this.after_build(), this.limit_build(), this.guildId_build(), this.excludeEnded_build());
        }

        private Possible<Snowflake> userId_build() {
            return this.userId_possible;
        }

        private Possible<List<Snowflake>> skuIds_build() {
            return this.skuIds_list == null ? Possible.absent() : Possible.of(this.skuIds_list);
        }

        private List<Snowflake> skuIds_getOrCreate() {
            if (this.skuIds_list == null) {
                this.skuIds_list = new ArrayList<Snowflake>();
            }
            return this.skuIds_list;
        }

        private Possible<Snowflake> before_build() {
            return this.before_possible;
        }

        private Possible<Snowflake> after_build() {
            return this.after_possible;
        }

        private Possible<Integer> limit_build() {
            return this.limit_possible;
        }

        private Possible<Snowflake> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<Boolean> excludeEnded_build() {
            return this.excludeEnded_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build EntitlementListRequestSpec, attribute initializers form cycle " + attributes;
        }
    }
}

