/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.monetization;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.monetization.Subscription;
import discord4j.core.spec.SubscriptionListRequestFlux;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SkuData;
import discord4j.discordjson.json.SubscriptionData;
import java.util.EnumSet;
import reactor.core.publisher.Mono;

@Experimental
public class SKU
implements Entity {
    private static final String SKU_URL_SCHEME = "https://discord.com/application-directory/%s/store/%s";
    private final GatewayDiscordClient gateway;
    private final SkuData data;

    public SKU(GatewayDiscordClient gateway, SkuData data) {
        this.gateway = gateway;
        this.data = data;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public SkuData getData() {
        return this.data;
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public String getName() {
        return this.data.name();
    }

    public Snowflake getApplicationId() {
        return Snowflake.of((Id)this.data.applicationId());
    }

    public String getSlug() {
        return this.data.slug();
    }

    public EnumSet<Flag> getFlags() {
        if (this.data.flags() != 0) {
            return Flag.of(this.data.flags());
        }
        return EnumSet.noneOf(Flag.class);
    }

    public SkuData getSkuData() {
        return this.data;
    }

    public String getUrl() {
        return String.format(SKU_URL_SCHEME, this.data.applicationId().asString(), this.data.id().asString());
    }

    public SubscriptionListRequestFlux getSubscriptions() {
        return SubscriptionListRequestFlux.of(this.gateway, this.gateway.rest(), this.getId());
    }

    public Mono<Subscription> getSubscription(Snowflake subscriptionId) {
        return this.gateway.getRestClient().getMonetizationService().getSkuSubscription(this.getId().asLong(), subscriptionId.asLong()).map(subscriptionData -> new Subscription(this.gateway, (SubscriptionData)subscriptionData));
    }

    public static enum Flag {
        AVAILABLE(2),
        GUILD_SUBSCRIPTION(7),
        USER_SUBSCRIPTION(8);

        private final int value;
        private final int flag;

        private Flag(int value) {
            this.value = value;
            this.flag = 1 << value;
        }

        public int getValue() {
            return this.value;
        }

        public int getFlag() {
            return this.flag;
        }

        public static EnumSet<Flag> of(int value) {
            EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                long flagValue = flag.getFlag();
                if ((flagValue & (long)value) != flagValue) continue;
                flagSet.add(flag);
            }
            return flagSet;
        }
    }

    public static enum Type {
        UNKNOWN(-1),
        DURABLE(2),
        CONSUMABLE(3),
        SUBSCRIPTION(5),
        SUBSCRIPTION_GROUP(6);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 2: {
                    return DURABLE;
                }
                case 3: {
                    return CONSUMABLE;
                }
                case 5: {
                    return SUBSCRIPTION;
                }
                case 6: {
                    return SUBSCRIPTION_GROUP;
                }
            }
            return UNKNOWN;
        }
    }
}

