/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.core.object.entity.Entity;
import discord4j.rest.entity.RestChannel;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public interface Channel
extends Entity {
    public Type getType();

    default public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String var1);

    default public String getMention() {
        return "<#" + this.getId().asString() + '>';
    }

    public RestChannel getRestChannel();

    public static enum Type {
        UNKNOWN(-1),
        GUILD_TEXT(0),
        DM(1),
        GUILD_VOICE(2),
        GROUP_DM(3),
        GUILD_CATEGORY(4),
        GUILD_NEWS(5),
        GUILD_STORE(6),
        GUILD_STAGE_VOICE(13);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 0: {
                    return GUILD_TEXT;
                }
                case 1: {
                    return DM;
                }
                case 2: {
                    return GUILD_VOICE;
                }
                case 3: {
                    return GROUP_DM;
                }
                case 4: {
                    return GUILD_CATEGORY;
                }
                case 5: {
                    return GUILD_NEWS;
                }
                case 6: {
                    return GUILD_STORE;
                }
                case 13: {
                    return GUILD_STAGE_VOICE;
                }
            }
            return UNKNOWN;
        }
    }
}

