/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Sticker;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.GuildStickerEditMono;
import discord4j.core.spec.GuildStickerEditSpec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.StickerData;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class GuildSticker
extends Sticker {
    private final long guildId;

    public GuildSticker(GatewayDiscordClient gateway, StickerData data) {
        super(gateway, data);
        this.guildId = ((Id)data.guildId().toOptional().get()).asLong();
    }

    public GuildSticker(GatewayDiscordClient gateway, StickerData data, long guildId) {
        super(gateway, data);
        this.guildId = guildId;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public GuildStickerEditMono edit() {
        return GuildStickerEditMono.of(this);
    }

    public Mono<GuildSticker> edit(GuildStickerEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getStickerService().modifyGuildSticker(this.getGuildId().asLong(), this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> new GuildSticker(this.gateway, (StickerData)data, this.getGuildId().asLong()));
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getStickerService().deleteGuildSticker(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }
}

