/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AvatarDecorationData;
import discord4j.rest.util.Image;
import java.util.Objects;

public class AvatarDecoration
implements DiscordObject {
    private static final String AVATAR_DECORATION_IMAGE_PATH = "avatar-decoration-presets/%s";
    protected final GatewayDiscordClient gateway;
    private final AvatarDecorationData data;

    public AvatarDecoration(GatewayDiscordClient gateway, AvatarDecorationData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public Snowflake getSkuId() {
        return Snowflake.of((Id)this.data.skuId());
    }

    public String getAsset() {
        return this.data.asset();
    }

    public String getImageUrl() {
        String path = String.format(AVATAR_DECORATION_IMAGE_PATH, this.getAsset());
        return ImageUtil.getUrl(path, Image.Format.PNG);
    }

    public String toString() {
        return "AvatarDecoration{data=" + this.data + '}';
    }
}

