/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.UnfurledMediaItem;
import discord4j.discordjson.json.MediaGalleryItemData;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;

public class MediaGalleryItem {
    private final MediaGalleryItemData data;

    public static MediaGalleryItem of(UnfurledMediaItem mediaItem) {
        return new MediaGalleryItem((MediaGalleryItemData)MediaGalleryItemData.builder().media(mediaItem.getData()).build());
    }

    public static MediaGalleryItem of(UnfurledMediaItem mediaItem, String description) {
        return new MediaGalleryItem((MediaGalleryItemData)MediaGalleryItemData.builder().media(mediaItem.getData()).description(Possible.of(Optional.of(description))).build());
    }

    public static MediaGalleryItem of(UnfurledMediaItem mediaItem, boolean spoiler) {
        return new MediaGalleryItem((MediaGalleryItemData)MediaGalleryItemData.builder().media(mediaItem.getData()).spoiler(Boolean.valueOf(spoiler)).build());
    }

    public static MediaGalleryItem of(UnfurledMediaItem mediaItem, String description, boolean spoiler) {
        return new MediaGalleryItem((MediaGalleryItemData)MediaGalleryItemData.builder().media(mediaItem.getData()).description(Possible.of(Optional.of(description))).spoiler(Boolean.valueOf(spoiler)).build());
    }

    protected MediaGalleryItem(UnfurledMediaItem mediaItem, String description, boolean spoiler) {
        this((MediaGalleryItemData)MediaGalleryItemData.builder().media(mediaItem.getData()).description(Possible.of(Optional.of(description))).spoiler(Boolean.valueOf(spoiler)).build());
    }

    MediaGalleryItem(MediaGalleryItemData data) {
        this.data = data;
    }

    public MediaGalleryItemData getData() {
        return this.data;
    }

    public UnfurledMediaItem getMedia() {
        return new UnfurledMediaItem(this.getData().media());
    }

    public String getDescription() {
        return Possible.flatOpt((Possible)this.getData().description()).orElse("");
    }

    public boolean isSpoiler() {
        return this.getData().spoiler().toOptional().orElse(false);
    }
}

