/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class Container
extends LayoutComponent
implements TopLevelMessageComponent {
    @SafeVarargs
    public static <C extends MessageComponent> Container of(C ... components) {
        return new Container(null, null, false, Arrays.asList(components));
    }

    @SafeVarargs
    public static <C extends MessageComponent> Container of(@Nullable Color color, C ... components) {
        return new Container(null, color, false, Arrays.asList(components));
    }

    @SafeVarargs
    public static <C extends MessageComponent> Container of(boolean spoiler, C ... components) {
        return new Container(null, null, spoiler, Arrays.asList(components));
    }

    @SafeVarargs
    public static <C extends MessageComponent> Container of(@Nullable Color color, boolean spoiler, C ... components) {
        return new Container(null, color, spoiler, Arrays.asList(components));
    }

    public static <C extends MessageComponent> Container of(List<C> components) {
        return new Container(null, null, false, components);
    }

    public static <C extends MessageComponent> Container of(boolean spoiler, List<C> components) {
        return new Container(null, null, spoiler, components);
    }

    public static <C extends MessageComponent> Container of(@Nullable Color color, List<C> components) {
        return new Container(null, color, false, components);
    }

    public static <C extends MessageComponent> Container of(@Nullable Color color, boolean spoiler, List<C> components) {
        return new Container(null, color, spoiler, components);
    }

    @SafeVarargs
    public static <C extends MessageComponent> Container of(int id, C ... components) {
        return new Container(id, null, false, Arrays.asList(components));
    }

    @SafeVarargs
    public static <C extends MessageComponent> Container of(int id, boolean spoiler, C ... components) {
        return new Container(id, null, spoiler, Arrays.asList(components));
    }

    @SafeVarargs
    public static <C extends MessageComponent> Container of(int id, @Nullable Color color, C ... components) {
        return new Container(id, color, false, Arrays.asList(components));
    }

    @SafeVarargs
    public static <C extends MessageComponent> Container of(int id, @Nullable Color color, boolean spoiler, C ... components) {
        return new Container(id, color, spoiler, Arrays.asList(components));
    }

    public static <C extends MessageComponent> Container of(int id, List<C> components) {
        return new Container(id, null, false, components);
    }

    public static <C extends MessageComponent> Container of(int id, @Nullable Color color, List<C> components) {
        return new Container(id, color, false, components);
    }

    public static <C extends MessageComponent> Container of(int id, boolean spoiler, List<C> components) {
        return new Container(id, null, spoiler, components);
    }

    public static <C extends MessageComponent> Container of(int id, @Nullable Color color, boolean spoiler, List<C> components) {
        return new Container(id, color, spoiler, components);
    }

    protected <C extends MessageComponent> Container(@Nullable Integer id, @Nullable Color color, boolean spoiler, List<C> components) {
        this((ComponentData)MessageComponent.getBuilder(MessageComponent.Type.CONTAINER).id(Possible.ofNullable((Object)id)).spoiler(Boolean.valueOf(spoiler)).components(components.stream().map(rec$ -> ((MessageComponent)rec$).getData()).collect(Collectors.toList())).accentColor(Possible.of(Optional.ofNullable(color).map(Color::getRGB))).build());
    }

    Container(ComponentData data) {
        super(data);
    }

    public <C extends MessageComponent> Container withAddedComponent(C component) {
        ArrayList<MessageComponent> components = new ArrayList<MessageComponent>(this.getChildren());
        components.add(component);
        return new Container((ComponentData)ComponentData.builder().from(this.getData()).components(components.stream().map(MessageComponent::getData).collect(Collectors.toList())).build());
    }

    public <C extends MessageComponent> Container withAddedComponents(C ... components) {
        ArrayList<MessageComponent> componentsToAdd = new ArrayList<MessageComponent>(this.getChildren());
        componentsToAdd.addAll(Arrays.asList(components));
        return new Container((ComponentData)ComponentData.builder().from(this.getData()).components(componentsToAdd.stream().map(MessageComponent::getData).collect(Collectors.toList())).build());
    }

    public Container withRemovedComponent(int componentId) {
        ArrayList<MessageComponent> components = new ArrayList<MessageComponent>(this.getChildren());
        components.removeIf(messageComponent -> componentId == messageComponent.getId());
        return new Container((ComponentData)ComponentData.builder().from(this.getData()).components(components.stream().map(MessageComponent::getData).collect(Collectors.toList())).build());
    }

    public Container withColor(@Nullable Color color) {
        return new Container((ComponentData)ComponentData.builder().from(this.getData()).accentColor(Possible.of(Optional.ofNullable(color).map(Color::getRGB))).build());
    }

    public Optional<Color> getColor() {
        return Possible.flatOpt((Possible)this.getData().accentColor()).map(Color::of);
    }

    public boolean isSpoiler() {
        return this.getData().spoiler().toOptional().orElse(false);
    }
}

