/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.discordjson.json.RecurrenceRuleData;
import discord4j.discordjson.json.RecurrenceRuleNWeekdayData;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Month;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class RecurrenceRule {
    private final RecurrenceRuleData data;

    public RecurrenceRule(RecurrenceRuleData data) {
        this.data = data;
    }

    public RecurrenceRuleData getData() {
        return this.data;
    }

    public Instant getStartTime() {
        return this.data.start();
    }

    public Optional<Instant> getEndTime() {
        return this.data.end();
    }

    public Frequency getFrequency() {
        return Frequency.of(this.data.frequency());
    }

    public int getInterval() {
        return this.data.interval();
    }

    public Optional<List<DayOfWeek>> getByWeekday() {
        return this.data.byWeekday().map(byWeekdays -> byWeekdays.stream().map(day -> DayOfWeek.values()[day]).collect(Collectors.toList()));
    }

    public Optional<List<NWeekday>> getByNWeekday() {
        return this.data.byNWeekday().map(byNWeekdayList -> byNWeekdayList.stream().map(NWeekday::new).collect(Collectors.toList()));
    }

    public Optional<List<Month>> getByMonth() {
        return this.data.byMonth().map(byMonths -> byMonths.stream().map(Month::of).collect(Collectors.toList()));
    }

    public Optional<List<Integer>> getByMonthDay() {
        return this.data.byMonthDay();
    }

    public Optional<List<Integer>> getByYearDay() {
        return this.data.byYearDay();
    }

    public Optional<Integer> getCount() {
        return this.data.count();
    }

    public static enum Frequency {
        UNKNOWN(-1),
        YEARLY(0),
        MONTHLY(1),
        WEEKLY(2),
        DAILY(3);

        private final int value;

        private Frequency(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Frequency of(int value) {
            switch (value) {
                case 0: {
                    return YEARLY;
                }
                case 1: {
                    return MONTHLY;
                }
                case 2: {
                    return WEEKLY;
                }
                case 3: {
                    return DAILY;
                }
            }
            return UNKNOWN;
        }
    }

    public static class NWeekday {
        private final RecurrenceRuleNWeekdayData data;

        public NWeekday(RecurrenceRuleNWeekdayData data) {
            this.data = data;
        }

        public RecurrenceRuleNWeekdayData getData() {
            return this.data;
        }

        public int getN() {
            return this.data.n();
        }

        public DayOfWeek getDay() {
            return DayOfWeek.values()[this.data.day()];
        }
    }
}

