/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.Invite;
import discord4j.discordjson.json.InviteData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;

public final class ExtendedInvite
extends Invite {
    public ExtendedInvite(GatewayDiscordClient gateway, InviteData data) {
        super(gateway, data);
    }

    public int getUses() {
        return (Integer)this.getData().uses().toOptional().orElseThrow(IllegalStateException::new);
    }

    public int getMaxUses() {
        return (Integer)this.getData().maxUses().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Optional<Instant> getExpiration() {
        int maxAge = (Integer)this.getData().maxAge().toOptional().orElseThrow(IllegalStateException::new);
        return maxAge > 0 ? Optional.of(this.getCreation().plus((long)maxAge, ChronoUnit.SECONDS)) : Optional.empty();
    }

    public boolean isTemporary() {
        return (Boolean)this.getData().temporary().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Instant getCreation() {
        String createdAt = (String)this.getData().createdAt().toOptional().orElseThrow(IllegalStateException::new);
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)createdAt, Instant::from);
    }

    @Override
    public String toString() {
        return "ExtendedInvite{} " + super.toString();
    }
}

