/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.InteractionCreateEvent;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.InteractionApplicationCommandCallbackReplyMono;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import discord4j.core.spec.InteractionCallbackSpec;
import discord4j.core.spec.InteractionCallbackSpecDeferReplyMono;
import discord4j.core.spec.InteractionFollowupCreateMono;
import discord4j.core.spec.InteractionFollowupCreateSpec;
import discord4j.core.spec.InteractionFollowupEditMono;
import discord4j.core.spec.InteractionPresentModalMono;
import discord4j.core.spec.InteractionPresentModalSpec;
import discord4j.core.spec.InteractionReplyEditMono;
import discord4j.core.spec.InteractionReplyEditSpec;
import discord4j.core.spec.legacy.LegacyInteractionApplicationCommandCallbackSpec;
import discord4j.discordjson.json.ImmutableInteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.MessageData;
import discord4j.gateway.ShardInfo;
import discord4j.rest.interaction.InteractionResponse;
import discord4j.rest.util.InteractionResponseType;
import discord4j.rest.util.MultipartRequest;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

@Experimental
public class DeferrableInteractionEvent
extends InteractionCreateEvent {
    private final InteractionCreateEvent.EventInteractionResponse response;

    public DeferrableInteractionEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
        this.response = new InteractionCreateEvent.EventInteractionResponse(this.getClient().rest(), interaction.getData());
    }

    @Deprecated
    public Mono<Void> acknowledge() {
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE, (InteractionApplicationCommandCallbackData)null);
    }

    public InteractionCallbackSpecDeferReplyMono deferReply() {
        return InteractionCallbackSpecDeferReplyMono.of(this);
    }

    public Mono<Void> deferReply(InteractionCallbackSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.createInteractionResponse(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE, spec.asRequest()));
    }

    @Deprecated
    public Mono<Void> acknowledgeEphemeral() {
        ImmutableInteractionApplicationCommandCallbackData data = InteractionApplicationCommandCallbackData.builder().flags(Integer.valueOf(Message.Flag.EPHEMERAL.getFlag())).build();
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE, (InteractionApplicationCommandCallbackData)data);
    }

    @Deprecated
    public Mono<Void> reply(Consumer<? super LegacyInteractionApplicationCommandCallbackSpec> spec) {
        return Mono.defer(() -> {
            LegacyInteractionApplicationCommandCallbackSpec mutatedSpec = new LegacyInteractionApplicationCommandCallbackSpec();
            this.getClient().getRestClient().getRestResources().getAllowedMentions().ifPresent(mutatedSpec::setAllowedMentions);
            spec.accept(mutatedSpec);
            return this.createInteractionResponse(InteractionResponseType.CHANNEL_MESSAGE_WITH_SOURCE, mutatedSpec.asRequest());
        });
    }

    public InteractionApplicationCommandCallbackReplyMono reply() {
        return InteractionApplicationCommandCallbackReplyMono.of(this);
    }

    @Deprecated
    @Experimental
    public Mono<Void> replyWithPremiumRequired() {
        return Mono.defer(() -> this.createInteractionResponse(InteractionResponseType.PREMIUM_REQUIRED, (MultipartRequest<InteractionApplicationCommandCallbackData>)MultipartRequest.ofRequest((Object)InteractionApplicationCommandCallbackData.builder().build())));
    }

    public InteractionApplicationCommandCallbackReplyMono reply(String content) {
        return this.reply().withContent(content);
    }

    public Mono<Void> reply(InteractionApplicationCommandCallbackSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            InteractionApplicationCommandCallbackSpec actualSpec = this.getClient().getRestClient().getRestResources().getAllowedMentions().filter(allowedMentions -> !spec.isAllowedMentionsPresent()).map(spec::withAllowedMentions).orElse(spec);
            return this.createInteractionResponse(InteractionResponseType.CHANNEL_MESSAGE_WITH_SOURCE, actualSpec.asRequest());
        });
    }

    public InteractionPresentModalMono presentModal() {
        return InteractionPresentModalMono.of(this);
    }

    public Mono<Void> presentModal(String title, String customId, Collection<LayoutComponent> components) {
        return this.presentModal().withTitle(title).withCustomId(customId).withComponents(components);
    }

    public Mono<Void> presentModal(InteractionPresentModalSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.createInteractionResponse(InteractionResponseType.MODAL, spec.asRequest()));
    }

    public InteractionReplyEditMono editReply(String content) {
        return this.editReply().withContentOrNull(content);
    }

    public InteractionReplyEditMono editReply() {
        return InteractionReplyEditMono.of(this);
    }

    public Mono<Message> editReply(InteractionReplyEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            InteractionReplyEditSpec actualSpec = this.getClient().getRestClient().getRestResources().getAllowedMentions().filter(allowedMentions -> !spec.isAllowedMentionsPresent()).map(spec::withAllowedMentionsOrNull).orElse(spec);
            return this.getInteractionResponse().editInitialResponse(actualSpec.asRequest());
        }).map(data -> new Message(this.getClient(), (MessageData)data));
    }

    public Mono<Message> getReply() {
        return this.getInteractionResponse().getInitialResponse().map(data -> new Message(this.getClient(), (MessageData)data));
    }

    public Mono<Void> deleteReply() {
        return this.getInteractionResponse().deleteInitialResponse();
    }

    public InteractionFollowupCreateMono createFollowup() {
        return InteractionFollowupCreateMono.of(this);
    }

    public InteractionFollowupCreateMono createFollowup(String content) {
        return this.createFollowup().withContent(content);
    }

    public Mono<Message> createFollowup(InteractionFollowupCreateSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            InteractionFollowupCreateSpec actualSpec = this.getClient().getRestClient().getRestResources().getAllowedMentions().filter(allowedMentions -> !spec.isAllowedMentionsPresent()).map(spec::withAllowedMentions).orElse(spec);
            return this.getInteractionResponse().createFollowupMessage(actualSpec.asRequest());
        }).map(data -> new Message(this.getClient(), (MessageData)data));
    }

    public InteractionFollowupEditMono editFollowup(Snowflake messageId) {
        return InteractionFollowupEditMono.of(messageId, this);
    }

    public Mono<Message> editFollowup(Snowflake messageId, InteractionReplyEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            InteractionReplyEditSpec actualSpec = this.getClient().getRestClient().getRestResources().getAllowedMentions().filter(allowedMentions -> !spec.isAllowedMentionsPresent()).map(spec::withAllowedMentionsOrNull).orElse(spec);
            return this.getInteractionResponse().editFollowupMessage(messageId.asLong(), actualSpec.asRequest());
        }).map(data -> new Message(this.getClient(), (MessageData)data));
    }

    public Mono<Void> deleteFollowup(Snowflake messageId) {
        return this.getInteractionResponse().deleteFollowupMessage(messageId.asLong());
    }

    public InteractionResponse getInteractionResponse() {
        return this.response;
    }
}

