/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MemberLeaveEvent
extends GuildEvent {
    private final User user;
    private final long guildId;
    @Nullable
    private final Member member;

    public MemberLeaveEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, User user, long guildId, @Nullable Member member) {
        super(gateway, shardInfo);
        this.user = user;
        this.guildId = guildId;
        this.member = member;
    }

    public User getUser() {
        return this.user;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Optional<Member> getMember() {
        return Optional.ofNullable(this.member);
    }

    public String toString() {
        return "MemberLeaveEvent{user=" + this.user + ", guildId=" + this.guildId + '}';
    }
}

