/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event;

import discord4j.common.LogUtil;
import discord4j.common.annotations.Experimental;
import discord4j.common.sinks.EmissionStrategy;
import discord4j.core.event.EventDispatcher;
import discord4j.core.event.domain.Event;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.concurrent.Queues;
import reactor.util.context.ContextView;

@Experimental
public class SinksEventDispatcher
implements EventDispatcher {
    private static final Logger log = Loggers.getLogger(SinksEventDispatcher.class);
    private final Sinks.Many<Event> events;
    private final EmissionStrategy emissionStrategy;
    private final Scheduler eventScheduler;

    public SinksEventDispatcher(Function<Sinks.ManySpec, Sinks.Many<Event>> eventSinkFactory, EmissionStrategy emissionStrategy, Scheduler eventScheduler) {
        this.events = eventSinkFactory.apply(Sinks.many());
        this.emissionStrategy = emissionStrategy;
        this.eventScheduler = eventScheduler;
    }

    @Override
    public <E extends Event> Flux<E> on(Class<E> eventClass) {
        AtomicReference subscription = new AtomicReference();
        return this.events.asFlux().publishOn(this.eventScheduler).ofType(eventClass).handle((event, sink) -> {
            if (log.isTraceEnabled()) {
                log.trace(LogUtil.format((ContextView)sink.currentContext().put((Object)"discord4j.shard", (Object)event.getShardInfo().getIndex()), (String)"{}"), new Object[]{event.toString()});
            }
            sink.next(event);
        }).doOnSubscribe(sub -> {
            subscription.set(sub);
            if (log.isDebugEnabled()) {
                log.debug("Subscription {} to {} created", new Object[]{Integer.toHexString(sub.hashCode()), eventClass.getSimpleName()});
            }
        }).doFinally(signal -> {
            if (log.isDebugEnabled()) {
                log.debug("Subscription {} to {} disposed due to {}", new Object[]{Integer.toHexString(((Subscription)subscription.get()).hashCode()), eventClass.getSimpleName(), signal});
            }
        });
    }

    @Override
    public void publish(Event event) {
        this.emissionStrategy.emitNext(this.events, (Object)event);
    }

    @Override
    public void shutdown() {
        this.emissionStrategy.emitComplete(this.events);
    }

    public static class Builder {
        protected Function<Sinks.ManySpec, Sinks.Many<Event>> eventSinkFactory;
        protected EmissionStrategy emissionStrategy;
        protected Scheduler eventScheduler;

        protected Builder() {
        }

        public Builder eventSink(Function<Sinks.ManySpec, Sinks.Many<Event>> eventSinkFactory) {
            this.eventSinkFactory = Objects.requireNonNull(eventSinkFactory);
            return this;
        }

        public Builder emissionStrategy(EmissionStrategy emissionStrategy) {
            this.emissionStrategy = Objects.requireNonNull(emissionStrategy);
            return this;
        }

        public Builder eventScheduler(Scheduler eventScheduler) {
            this.eventScheduler = Objects.requireNonNull(eventScheduler);
            return this;
        }

        public EventDispatcher build() {
            if (this.eventSinkFactory == null) {
                this.eventSinkFactory = spec -> spec.multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false);
            }
            if (this.emissionStrategy == null) {
                this.emissionStrategy = EmissionStrategy.timeoutDrop((Duration)Duration.ofSeconds(10L));
            }
            if (this.eventScheduler == null) {
                this.eventScheduler = EventDispatcher.DEFAULT_EVENT_SCHEDULER.get();
            }
            return new SinksEventDispatcher(this.eventSinkFactory, this.emissionStrategy, this.eventScheduler);
        }
    }
}

