/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.gateway.WebhooksUpdate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableWebhooksUpdate
implements WebhooksUpdate {
    private final long guildId_value;
    private final long channelId_value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWebhooksUpdate(Id guildId, Id channelId) {
        Id guildId$impl = guildId;
        Id channelId$impl = channelId;
        this.guildId_value = guildId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableWebhooksUpdate(ImmutableWebhooksUpdate original, Id guildId, Id channelId) {
        Id guildId$impl = guildId;
        Id channelId$impl = channelId;
        this.guildId_value = guildId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    public ImmutableWebhooksUpdate withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableWebhooksUpdate(this, newValue, this.channelId());
    }

    public ImmutableWebhooksUpdate withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableWebhooksUpdate(this, newValue, this.channelId());
    }

    public ImmutableWebhooksUpdate withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableWebhooksUpdate(this, this.guildId(), newValue);
    }

    public ImmutableWebhooksUpdate withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableWebhooksUpdate(this, this.guildId(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhooksUpdate && this.equalTo(0, (ImmutableWebhooksUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableWebhooksUpdate another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && Objects.equals(this.channelId_value, another.channelId_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        return h;
    }

    public String toString() {
        return "WebhooksUpdate{guildId=" + Objects.toString(this.guildId_value) + ", channelId=" + Objects.toString(this.channelId_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhooksUpdate fromJson(Json json) {
        Builder builder = ImmutableWebhooksUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        return builder.build();
    }

    public static ImmutableWebhooksUpdate of(Id guildId, Id channelId) {
        return new ImmutableWebhooksUpdate(guildId, channelId);
    }

    public static ImmutableWebhooksUpdate copyOf(WebhooksUpdate instance) {
        if (instance instanceof ImmutableWebhooksUpdate) {
            return (ImmutableWebhooksUpdate)instance;
        }
        return ImmutableWebhooksUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Id guildId_id = null;
        private Id channelId_id = null;

        private Builder() {
        }

        public final Builder from(WebhooksUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.channelId(instance.channelId());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of((String)value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        public ImmutableWebhooksUpdate build() {
            return new ImmutableWebhooksUpdate(null, this.guildId_build(), this.channelId_build());
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Id channelId_build() {
            return this.channelId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements WebhooksUpdate {
        @Nullable
        Id guildId;
        @Nullable
        Id channelId;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhooksUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

