/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableMessageReactionRemove
implements MessageReactionRemove {
    private final long userId_value;
    private final long channelId_value;
    private final long messageId_value;
    private final long guildId_value;
    private final boolean guildId_absent;
    private final EmojiData emoji;
    private final boolean burst;
    private final int type;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReactionRemove(Id userId, Id channelId, Id messageId, Possible<Id> guildId, EmojiData emoji, boolean burst, int type) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        this.emoji = Objects.requireNonNull(emoji, "emoji");
        this.burst = burst;
        this.type = type;
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageReactionRemove(ImmutableMessageReactionRemove original, Id userId, Id channelId, Id messageId, Possible<Id> guildId, EmojiData emoji, boolean burst, int type) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        this.emoji = emoji;
        this.burst = burst;
        this.type = type;
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user_id")
    public Id userId() {
        return Id.of((long)this.userId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    @Override
    @JsonProperty(value="message_id")
    public Id messageId() {
        return Id.of((long)this.messageId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    @Override
    @JsonProperty(value="emoji")
    public EmojiData emoji() {
        return this.emoji;
    }

    @Override
    @JsonProperty(value="burst")
    public boolean burst() {
        return this.burst;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    public ImmutableMessageReactionRemove withUserId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionRemove(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.emoji, this.burst, this.type);
    }

    public ImmutableMessageReactionRemove withUserId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionRemove(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.emoji, this.burst, this.type);
    }

    public ImmutableMessageReactionRemove withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionRemove(this, this.userId(), newValue, this.messageId(), this.guildId(), this.emoji, this.burst, this.type);
    }

    public ImmutableMessageReactionRemove withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionRemove(this, this.userId(), newValue, this.messageId(), this.guildId(), this.emoji, this.burst, this.type);
    }

    public ImmutableMessageReactionRemove withMessageId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionRemove(this, this.userId(), this.channelId(), newValue, this.guildId(), this.emoji, this.burst, this.type);
    }

    public ImmutableMessageReactionRemove withMessageId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionRemove(this, this.userId(), this.channelId(), newValue, this.guildId(), this.emoji, this.burst, this.type);
    }

    public ImmutableMessageReactionRemove withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReactionRemove(this, this.userId(), this.channelId(), this.messageId(), newValue, this.emoji, this.burst, this.type);
    }

    public ImmutableMessageReactionRemove withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessageReactionRemove(this, this.userId(), this.channelId(), this.messageId(), (Possible<Id>)newValue, this.emoji, this.burst, this.type);
    }

    public final ImmutableMessageReactionRemove withEmoji(EmojiData value) {
        if (this.emoji == value) {
            return this;
        }
        EmojiData newValue = Objects.requireNonNull(value, "emoji");
        return new ImmutableMessageReactionRemove(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), newValue, this.burst, this.type);
    }

    public final ImmutableMessageReactionRemove withBurst(boolean value) {
        if (this.burst == value) {
            return this;
        }
        return new ImmutableMessageReactionRemove(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), this.emoji, value, this.type);
    }

    public final ImmutableMessageReactionRemove withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableMessageReactionRemove(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), this.emoji, this.burst, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReactionRemove && this.equalTo(0, (ImmutableMessageReactionRemove)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageReactionRemove another) {
        return Objects.equals(this.userId_value, another.userId_value) && Objects.equals(this.channelId_value, another.channelId_value) && Objects.equals(this.messageId_value, another.messageId_value) && this.guildId().equals(another.guildId()) && this.emoji.equals(another.emoji) && this.burst == another.burst && this.type == another.type;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userId_value);
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        h += (h << 5) + Objects.hashCode(this.messageId_value);
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.emoji.hashCode();
        h += (h << 5) + Boolean.hashCode(this.burst);
        h += (h << 5) + this.type;
        return h;
    }

    public String toString() {
        return "MessageReactionRemove{userId=" + Objects.toString(this.userId_value) + ", channelId=" + Objects.toString(this.channelId_value) + ", messageId=" + Objects.toString(this.messageId_value) + ", guildId=" + this.guildId().toString() + ", emoji=" + this.emoji + ", burst=" + this.burst + ", type=" + this.type + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageReactionRemove fromJson(Json json) {
        Builder builder = ImmutableMessageReactionRemove.builder();
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.messageId != null) {
            builder.messageId(json.messageId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        if (json.burstIsSet) {
            builder.burst(json.burst);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableMessageReactionRemove of(Id userId, Id channelId, Id messageId, Possible<Id> guildId, EmojiData emoji, boolean burst, int type) {
        return new ImmutableMessageReactionRemove(userId, channelId, messageId, guildId, emoji, burst, type);
    }

    public static ImmutableMessageReactionRemove copyOf(MessageReactionRemove instance) {
        if (instance instanceof ImmutableMessageReactionRemove) {
            return (ImmutableMessageReactionRemove)instance;
        }
        return ImmutableMessageReactionRemove.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_EMOJI = 1L;
        private static final long INIT_BIT_BURST = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        private Id userId_id = null;
        private Id channelId_id = null;
        private Id messageId_id = null;
        private Possible<Id> guildId_possible = Possible.absent();
        @Nullable
        private EmojiData emoji;
        private boolean burst;
        private int type;

        private Builder() {
        }

        public final Builder from(MessageReactionRemove instance) {
            Objects.requireNonNull(instance, "instance");
            this.userId(instance.userId());
            this.channelId(instance.channelId());
            this.messageId(instance.messageId());
            this.guildId(instance.guildId());
            this.emoji(instance.emoji());
            this.burst(instance.burst());
            this.type(instance.type());
            return this;
        }

        public Builder userId(String value) {
            this.userId_id = Id.of((String)value);
            return this;
        }

        public Builder userId(long value) {
            this.userId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder userId(Id value) {
            this.userId_id = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of((String)value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        public Builder messageId(String value) {
            this.messageId_id = Id.of((String)value);
            return this;
        }

        public Builder messageId(long value) {
            this.messageId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="message_id")
        public Builder messageId(Id value) {
            this.messageId_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        @JsonProperty(value="emoji")
        public final Builder emoji(EmojiData emoji) {
            this.emoji = Objects.requireNonNull(emoji, "emoji");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="burst")
        public final Builder burst(boolean burst) {
            this.burst = burst;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMessageReactionRemove build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageReactionRemove(null, this.userId_build(), this.channelId_build(), this.messageId_build(), this.guildId_build(), this.emoji, this.burst, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoji");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("burst");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build MessageReactionRemove, some of required attributes are not set " + attributes;
        }

        private Id userId_build() {
            return this.userId_id;
        }

        private Id channelId_build() {
            return this.channelId_id;
        }

        private Id messageId_build() {
            return this.messageId_id;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageReactionRemove {
        @Nullable
        Id userId;
        @Nullable
        Id channelId;
        @Nullable
        Id messageId;
        Possible<Id> guildId = Possible.absent();
        @Nullable
        EmojiData emoji;
        boolean burst;
        boolean burstIsSet;
        int type;
        boolean typeIsSet;

        Json() {
        }

        @JsonProperty(value="user_id")
        public void setUserId(Id userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(Id messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(EmojiData emoji) {
            this.emoji = emoji;
        }

        @JsonProperty(value="burst")
        public void setBurst(boolean burst) {
            this.burst = burst;
            this.burstIsSet = true;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @Override
        public Id userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id messageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmojiData emoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean burst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageReactionRemove, attribute initializers form cycle " + attributes;
        }
    }
}

