/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.WelcomeScreenChannelData;
import discord4j.discordjson.json.WelcomeScreenData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableWelcomeScreenData
implements WelcomeScreenData {
    @Nullable
    private final String description;
    private final List<WelcomeScreenChannelData> welcomeChannels;

    private ImmutableWelcomeScreenData(Optional<String> description, Iterable<? extends WelcomeScreenChannelData> welcomeChannels) {
        this.description = description.orElse(null);
        this.welcomeChannels = ImmutableWelcomeScreenData.createUnmodifiableList(false, ImmutableWelcomeScreenData.createSafeList(welcomeChannels, true, false));
    }

    private ImmutableWelcomeScreenData(ImmutableWelcomeScreenData original, @Nullable String description, List<WelcomeScreenChannelData> welcomeChannels) {
        this.description = description;
        this.welcomeChannels = welcomeChannels;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="welcome_channels")
    public List<WelcomeScreenChannelData> welcomeChannels() {
        return this.welcomeChannels;
    }

    public final ImmutableWelcomeScreenData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableWelcomeScreenData(this, newValue, this.welcomeChannels);
    }

    public final ImmutableWelcomeScreenData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableWelcomeScreenData(this, value, this.welcomeChannels);
    }

    public final ImmutableWelcomeScreenData withWelcomeChannels(WelcomeScreenChannelData ... elements) {
        List<WelcomeScreenChannelData> newValue = ImmutableWelcomeScreenData.createUnmodifiableList(false, ImmutableWelcomeScreenData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWelcomeScreenData(this, this.description, newValue);
    }

    public final ImmutableWelcomeScreenData withWelcomeChannels(Iterable<? extends WelcomeScreenChannelData> elements) {
        if (this.welcomeChannels == elements) {
            return this;
        }
        List<WelcomeScreenChannelData> newValue = ImmutableWelcomeScreenData.createUnmodifiableList(false, ImmutableWelcomeScreenData.createSafeList(elements, true, false));
        return new ImmutableWelcomeScreenData(this, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWelcomeScreenData && this.equalTo(0, (ImmutableWelcomeScreenData)another);
    }

    private boolean equalTo(int synthetic, ImmutableWelcomeScreenData another) {
        return Objects.equals(this.description, another.description) && this.welcomeChannels.equals(another.welcomeChannels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.welcomeChannels.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WelcomeScreenData{");
        if (this.description != null) {
            builder.append("description=").append(this.description);
        }
        if (builder.length() > 18) {
            builder.append(", ");
        }
        builder.append("welcomeChannels=").append(this.welcomeChannels);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWelcomeScreenData fromJson(Json json) {
        Builder builder = ImmutableWelcomeScreenData.builder();
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.welcomeChannels != null) {
            builder.addAllWelcomeChannels(json.welcomeChannels);
        }
        return builder.build();
    }

    public static ImmutableWelcomeScreenData of(Optional<String> description, List<WelcomeScreenChannelData> welcomeChannels) {
        return ImmutableWelcomeScreenData.of(description, welcomeChannels);
    }

    public static ImmutableWelcomeScreenData of(Optional<String> description, Iterable<? extends WelcomeScreenChannelData> welcomeChannels) {
        return new ImmutableWelcomeScreenData(description, welcomeChannels);
    }

    public static ImmutableWelcomeScreenData copyOf(WelcomeScreenData instance) {
        if (instance instanceof ImmutableWelcomeScreenData) {
            return (ImmutableWelcomeScreenData)instance;
        }
        return ImmutableWelcomeScreenData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        @Nullable
        private String description;
        private List<WelcomeScreenChannelData> welcomeChannels = new ArrayList<WelcomeScreenChannelData>();

        private Builder() {
        }

        public final Builder from(WelcomeScreenData instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> descriptionOptional = instance.description();
            if (descriptionOptional.isPresent()) {
                this.description(descriptionOptional);
            }
            this.addAllWelcomeChannels(instance.welcomeChannels());
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public final Builder addWelcomeChannel(WelcomeScreenChannelData element) {
            this.welcomeChannels.add(Objects.requireNonNull(element, "welcomeChannels element"));
            return this;
        }

        public final Builder addWelcomeChannels(WelcomeScreenChannelData ... elements) {
            for (WelcomeScreenChannelData element : elements) {
                this.welcomeChannels.add(Objects.requireNonNull(element, "welcomeChannels element"));
            }
            return this;
        }

        @JsonProperty(value="welcome_channels")
        public final Builder welcomeChannels(Iterable<? extends WelcomeScreenChannelData> elements) {
            this.welcomeChannels.clear();
            return this.addAllWelcomeChannels(elements);
        }

        public final Builder addAllWelcomeChannels(Iterable<? extends WelcomeScreenChannelData> elements) {
            for (WelcomeScreenChannelData welcomeScreenChannelData : elements) {
                this.welcomeChannels.add(Objects.requireNonNull(welcomeScreenChannelData, "welcomeChannels element"));
            }
            return this;
        }

        public ImmutableWelcomeScreenData build() {
            return new ImmutableWelcomeScreenData(null, this.description, ImmutableWelcomeScreenData.createUnmodifiableList(true, this.welcomeChannels));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements WelcomeScreenData {
        @Nullable
        Optional<String> description = Optional.empty();
        @Nullable
        List<WelcomeScreenChannelData> welcomeChannels = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="welcome_channels")
        public void setWelcomeChannels(List<WelcomeScreenChannelData> welcomeChannels) {
            this.welcomeChannels = welcomeChannels;
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WelcomeScreenChannelData> welcomeChannels() {
            throw new UnsupportedOperationException();
        }
    }
}

