/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.BaseOnboardingPromptOptionData;
import discord4j.discordjson.json.OnboardingEditPromptOptionData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableOnboardingEditPromptOptionData
implements OnboardingEditPromptOptionData {
    private final long[] channelsIds_value;
    private final long[] rolesIds_value;
    private final String title;
    @Nullable
    private final String description;
    private final long emojiId_value;
    private final boolean emojiId_absent;
    private final String emojiName_value;
    private final boolean emojiName_absent;
    private final Boolean emojiAnimated_value;
    private final boolean emojiAnimated_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOnboardingEditPromptOptionData(List<Id> channelsIds, List<Id> rolesIds, String title, Optional<String> description, Possible<Id> emojiId, Possible<String> emojiName, Possible<Boolean> emojiAnimated) {
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.title = Objects.requireNonNull(title, "title");
        this.description = description.orElse(null);
        Possible<Id> emojiId$impl = emojiId;
        Possible<String> emojiName$impl = emojiName;
        Possible<Boolean> emojiAnimated$impl = emojiAnimated;
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.emojiId_value = emojiId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.emojiId_absent = emojiId$impl.isAbsent();
        this.emojiName_value = emojiName$impl.toOptional().orElse(null);
        this.emojiName_absent = emojiName$impl.isAbsent();
        this.emojiAnimated_value = emojiAnimated$impl.toOptional().orElse(null);
        this.emojiAnimated_absent = emojiAnimated$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableOnboardingEditPromptOptionData(ImmutableOnboardingEditPromptOptionData original, List<Id> channelsIds, List<Id> rolesIds, String title, @Nullable String description, Possible<Id> emojiId, Possible<String> emojiName, Possible<Boolean> emojiAnimated) {
        List<Id> channelsIds$impl = channelsIds;
        List<Id> rolesIds$impl = rolesIds;
        this.title = title;
        this.description = description;
        Possible<Id> emojiId$impl = emojiId;
        Possible<String> emojiName$impl = emojiName;
        Possible<Boolean> emojiAnimated$impl = emojiAnimated;
        this.channelsIds_value = channelsIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.rolesIds_value = rolesIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.emojiId_value = emojiId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.emojiId_absent = emojiId$impl.isAbsent();
        this.emojiName_value = emojiName$impl.toOptional().orElse(null);
        this.emojiName_absent = emojiName$impl.isAbsent();
        this.emojiAnimated_value = emojiAnimated$impl.toOptional().orElse(null);
        this.emojiAnimated_absent = emojiAnimated$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="channel_ids")
    public List<Id> channelsIds() {
        return LongStream.of(this.channelsIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="role_ids")
    public List<Id> rolesIds() {
        return LongStream.of(this.rolesIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="title")
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty(value="description")
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty(value="emoji_id")
    public Possible<Id> emojiId() {
        return this.emojiId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.emojiId_value));
    }

    @Override
    @JsonProperty(value="emoji_name")
    public Possible<String> emojiName() {
        return this.emojiName_absent ? Possible.absent() : Possible.of((Object)this.emojiName_value);
    }

    @Override
    @JsonProperty(value="emoji_animated")
    public Possible<Boolean> emojiAnimated() {
        return this.emojiAnimated_absent ? Possible.absent() : Possible.of((Object)this.emojiAnimated_value);
    }

    public ImmutableOnboardingEditPromptOptionData withChannelsIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingEditPromptOptionData(this, newValue, this.rolesIds(), this.title, this.description, this.emojiId(), this.emojiName(), this.emojiAnimated());
    }

    public ImmutableOnboardingEditPromptOptionData withRolesIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), newValue, this.title, this.description, this.emojiId(), this.emojiName(), this.emojiAnimated());
    }

    public final ImmutableOnboardingEditPromptOptionData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), newValue, this.description, this.emojiId(), this.emojiName(), this.emojiAnimated());
    }

    public final ImmutableOnboardingEditPromptOptionData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (Objects.equals(this.description, newValue)) {
            return this;
        }
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, newValue, this.emojiId(), this.emojiName(), this.emojiAnimated());
    }

    public final ImmutableOnboardingEditPromptOptionData withDescription(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, value, this.emojiId(), this.emojiName(), this.emojiAnimated());
    }

    public ImmutableOnboardingEditPromptOptionData withEmojiId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, newValue, this.emojiName(), this.emojiAnimated());
    }

    public ImmutableOnboardingEditPromptOptionData withEmojiId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, (Possible<Id>)newValue, this.emojiName(), this.emojiAnimated());
    }

    public ImmutableOnboardingEditPromptOptionData withEmojiName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, this.emojiId(), newValue, this.emojiAnimated());
    }

    public ImmutableOnboardingEditPromptOptionData withEmojiName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, this.emojiId(), (Possible<String>)newValue, this.emojiAnimated());
    }

    public ImmutableOnboardingEditPromptOptionData withEmojiAnimated(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, this.emojiId(), this.emojiName(), newValue);
    }

    public ImmutableOnboardingEditPromptOptionData withEmojiAnimated(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableOnboardingEditPromptOptionData(this, this.channelsIds(), this.rolesIds(), this.title, this.description, this.emojiId(), this.emojiName(), (Possible<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingEditPromptOptionData && this.equalTo(0, (ImmutableOnboardingEditPromptOptionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingEditPromptOptionData another) {
        return Objects.equals(this.channelsIds_value, another.channelsIds_value) && Objects.equals(this.rolesIds_value, another.rolesIds_value) && this.title.equals(another.title) && Objects.equals(this.description, another.description) && this.emojiId().equals(another.emojiId()) && this.emojiName().equals(another.emojiName()) && this.emojiAnimated().equals(another.emojiAnimated());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.channelsIds_value);
        h += (h << 5) + Objects.hashCode(this.rolesIds_value);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.emojiId().hashCode();
        h += (h << 5) + this.emojiName().hashCode();
        h += (h << 5) + this.emojiAnimated().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OnboardingEditPromptOptionData{");
        builder.append("channelsIds=").append(Objects.toString(this.channelsIds_value));
        builder.append(", ");
        builder.append("rolesIds=").append(Objects.toString(this.rolesIds_value));
        builder.append(", ");
        builder.append("title=").append(this.title);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        builder.append(", ");
        builder.append("emojiId=").append(this.emojiId().toString());
        builder.append(", ");
        builder.append("emojiName=").append(this.emojiName().toString());
        builder.append(", ");
        builder.append("emojiAnimated=").append(this.emojiAnimated().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingEditPromptOptionData fromJson(Json json) {
        Builder builder = ImmutableOnboardingEditPromptOptionData.builder();
        if (json.channelsIds != null) {
            builder.channelsIds(json.channelsIds);
        }
        if (json.rolesIds != null) {
            builder.rolesIds(json.rolesIds);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.emojiId != null) {
            builder.emojiId(json.emojiId);
        }
        if (json.emojiName != null) {
            builder.emojiName(json.emojiName);
        }
        if (json.emojiAnimated != null) {
            builder.emojiAnimated(json.emojiAnimated);
        }
        return builder.build();
    }

    public static ImmutableOnboardingEditPromptOptionData of(List<Id> channelsIds, List<Id> rolesIds, String title, Optional<String> description, Possible<Id> emojiId, Possible<String> emojiName, Possible<Boolean> emojiAnimated) {
        return new ImmutableOnboardingEditPromptOptionData(channelsIds, rolesIds, title, description, emojiId, emojiName, emojiAnimated);
    }

    public static ImmutableOnboardingEditPromptOptionData copyOf(OnboardingEditPromptOptionData instance) {
        if (instance instanceof ImmutableOnboardingEditPromptOptionData) {
            return (ImmutableOnboardingEditPromptOptionData)instance;
        }
        return ImmutableOnboardingEditPromptOptionData.builder().from(instance).build();
    }

    public boolean isEmojiIdPresent() {
        return !this.emojiId_absent;
    }

    public long emojiIdOrElse(long defaultValue) {
        return !this.emojiId_absent ? this.emojiId_value : defaultValue;
    }

    public boolean isEmojiNamePresent() {
        return !this.emojiName_absent;
    }

    public String emojiNameOrElse(String defaultValue) {
        return !this.emojiName_absent ? this.emojiName_value : defaultValue;
    }

    public boolean isEmojiAnimatedPresent() {
        return !this.emojiAnimated_absent;
    }

    public Boolean emojiAnimatedOrElse(Boolean defaultValue) {
        return !this.emojiAnimated_absent ? this.emojiAnimated_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        private List<Long> channelsIds_list = null;
        private List<Long> rolesIds_list = null;
        private Possible<Id> emojiId_possible = Possible.absent();
        private Possible<String> emojiName_possible = Possible.absent();
        private Possible<Boolean> emojiAnimated_possible = Possible.absent();
        @Nullable
        private String title;
        @Nullable
        private String description;

        private Builder() {
        }

        public final Builder from(BaseOnboardingPromptOptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(OnboardingEditPromptOptionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> descriptionOptional;
            BaseOnboardingPromptOptionData instance;
            long bits = 0L;
            if (object instanceof BaseOnboardingPromptOptionData) {
                instance = (BaseOnboardingPromptOptionData)object;
                if ((bits & 1L) == 0L) {
                    descriptionOptional = instance.description();
                    if (descriptionOptional.isPresent()) {
                        this.description(descriptionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 8L) == 0L) {
                    this.rolesIds(instance.rolesIds());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.channelsIds(instance.channelsIds());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.title(instance.title());
                    bits |= 4L;
                }
            }
            if (object instanceof OnboardingEditPromptOptionData) {
                instance = (OnboardingEditPromptOptionData)object;
                this.emojiName(instance.emojiName());
                this.emojiId(instance.emojiId());
                if ((bits & 8L) == 0L) {
                    this.rolesIds(instance.rolesIds());
                    bits |= 8L;
                }
                this.emojiAnimated(instance.emojiAnimated());
                if ((bits & 1L) == 0L) {
                    descriptionOptional = instance.description();
                    if (descriptionOptional.isPresent()) {
                        this.description(descriptionOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.channelsIds(instance.channelsIds());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.title(instance.title());
                    bits |= 4L;
                }
            }
        }

        public Builder addChannelsId(long element) {
            this.channelsIds_getOrCreate().add(element);
            return this;
        }

        public Builder addChannelsId(String element) {
            this.channelsIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addChannelsId(Id element) {
            this.channelsIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllChannelsIds(List<Long> elements) {
            this.channelsIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="channel_ids")
        public Builder channelsIds(List<Id> elements) {
            this.channelsIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder channelsIds(Iterable<Id> elements) {
            this.channelsIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addRolesId(long element) {
            this.rolesIds_getOrCreate().add(element);
            return this;
        }

        public Builder addRolesId(String element) {
            this.rolesIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addRolesId(Id element) {
            this.rolesIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllRolesIds(List<Long> elements) {
            this.rolesIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="role_ids")
        public Builder rolesIds(List<Id> elements) {
            this.rolesIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder rolesIds(Iterable<Id> elements) {
            this.rolesIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="title")
        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(Optional<String> description) {
            this.description = description.orElse(null);
            return this;
        }

        public Builder emojiId(String value) {
            this.emojiId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder emojiId(long value) {
            this.emojiId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder emojiId(Id value) {
            this.emojiId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="emoji_id")
        public Builder emojiId(Possible<Id> value) {
            this.emojiId_possible = value;
            return this;
        }

        @JsonProperty(value="emoji_name")
        public Builder emojiName(Possible<String> value) {
            this.emojiName_possible = value;
            return this;
        }

        public Builder emojiName(String value) {
            this.emojiName_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="emoji_animated")
        public Builder emojiAnimated(Possible<Boolean> value) {
            this.emojiAnimated_possible = value;
            return this;
        }

        public Builder emojiAnimated(Boolean value) {
            this.emojiAnimated_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableOnboardingEditPromptOptionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingEditPromptOptionData(null, this.channelsIds_build(), this.rolesIds_build(), this.title, this.description, this.emojiId_build(), this.emojiName_build(), this.emojiAnimated_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build OnboardingEditPromptOptionData, some of required attributes are not set " + attributes;
        }

        private List<Id> channelsIds_build() {
            return this.channelsIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> channelsIds_getOrCreate() {
            if (this.channelsIds_list == null) {
                this.channelsIds_list = new ArrayList<Long>();
            }
            return this.channelsIds_list;
        }

        private List<Id> rolesIds_build() {
            return this.rolesIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> rolesIds_getOrCreate() {
            if (this.rolesIds_list == null) {
                this.rolesIds_list = new ArrayList<Long>();
            }
            return this.rolesIds_list;
        }

        private Possible<Id> emojiId_build() {
            return this.emojiId_possible;
        }

        private Possible<String> emojiName_build() {
            return this.emojiName_possible;
        }

        private Possible<Boolean> emojiAnimated_build() {
            return this.emojiAnimated_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements OnboardingEditPromptOptionData {
        @Nullable
        List<Id> channelsIds;
        @Nullable
        List<Id> rolesIds;
        @Nullable
        String title;
        @Nullable
        Optional<String> description = Optional.empty();
        Possible<Id> emojiId = Possible.absent();
        Possible<String> emojiName = Possible.absent();
        Possible<Boolean> emojiAnimated = Possible.absent();

        Json() {
        }

        @JsonProperty(value="channel_ids")
        public void setChannelsIds(List<Id> channelsIds) {
            this.channelsIds = channelsIds;
        }

        @JsonProperty(value="role_ids")
        public void setRolesIds(List<Id> rolesIds) {
            this.rolesIds = rolesIds;
        }

        @JsonProperty(value="title")
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty(value="description")
        public void setDescription(Optional<String> description) {
            this.description = description;
        }

        @JsonProperty(value="emoji_id")
        public void setEmojiId(Possible<Id> emojiId) {
            this.emojiId = emojiId;
        }

        @JsonProperty(value="emoji_name")
        public void setEmojiName(Possible<String> emojiName) {
            this.emojiName = emojiName;
        }

        @JsonProperty(value="emoji_animated")
        public void setEmojiAnimated(Possible<Boolean> emojiAnimated) {
            this.emojiAnimated = emojiAnimated;
        }

        @Override
        public List<Id> channelsIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> rolesIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> emojiId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> emojiName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> emojiAnimated() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingEditPromptOptionData, attribute initializers form cycle " + attributes;
        }
    }
}

