/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.interaction;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationCommandInteractionData;
import discord4j.discordjson.json.FollowupMessageRequest;
import discord4j.discordjson.json.ImmutableFollowupMessageRequest;
import discord4j.discordjson.json.ImmutableInteractionResponseData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.InteractionResponseData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.rest.RestClient;
import discord4j.rest.interaction.DirectInteraction;
import discord4j.rest.interaction.FollowupInteractionHandler;
import discord4j.rest.interaction.GuildInteraction;
import discord4j.rest.interaction.InteractionMember;
import discord4j.rest.interaction.InteractionMemberOperations;
import discord4j.rest.interaction.InteractionResponse;
import discord4j.rest.interaction.RestInteraction;
import discord4j.rest.util.InteractionResponseType;
import discord4j.rest.util.MultipartRequest;
import java.util.Collections;
import reactor.core.publisher.Mono;

class InteractionOperations
implements RestInteraction,
InteractionResponse,
GuildInteraction,
DirectInteraction {
    private final RestClient restClient;
    private final InteractionData interactionData;
    private final long applicationId;
    private final InteractionMemberOperations memberOperations;

    InteractionOperations(RestClient restClient, InteractionData interactionData) {
        this.restClient = restClient;
        this.interactionData = interactionData;
        this.applicationId = Snowflake.asLong((Id)interactionData.applicationId());
        this.memberOperations = new InteractionMemberOperations(restClient, interactionData);
    }

    @Override
    public Snowflake getGuildId() {
        return Snowflake.of((Id)((Id)this.interactionData.guildId().get()));
    }

    @Override
    public InteractionMember getInteractionMember() {
        return this.memberOperations;
    }

    @Override
    public UserData getUserData() {
        return (UserData)this.interactionData.user().get();
    }

    @Override
    public InteractionData getData() {
        return this.interactionData;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.interactionData.id());
    }

    @Override
    public Snowflake getChannelId() {
        return Snowflake.of((Id)((Id)this.interactionData.channelId().get()));
    }

    @Override
    public ApplicationCommandInteractionData getCommandInteractionData() {
        return (ApplicationCommandInteractionData)this.interactionData.data().get();
    }

    @Override
    public FollowupInteractionHandler acknowledge() {
        ImmutableInteractionResponseData responseData = InteractionResponseData.builder().type(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE.getValue()).data((InteractionApplicationCommandCallbackData)InteractionApplicationCommandCallbackData.builder().build()).build();
        return new FollowupInteractionHandler((InteractionResponseData)responseData, __ -> Mono.empty());
    }

    @Override
    public FollowupInteractionHandler acknowledgeEphemeral() {
        ImmutableInteractionResponseData responseData = InteractionResponseData.builder().type(InteractionResponseType.DEFERRED_CHANNEL_MESSAGE_WITH_SOURCE.getValue()).data((InteractionApplicationCommandCallbackData)InteractionApplicationCommandCallbackData.builder().flags(Integer.valueOf(64)).build()).build();
        return new FollowupInteractionHandler((InteractionResponseData)responseData, __ -> Mono.empty());
    }

    @Override
    public FollowupInteractionHandler reply(String content) {
        return this.reply((InteractionApplicationCommandCallbackData)InteractionApplicationCommandCallbackData.builder().content(content).build());
    }

    @Override
    public FollowupInteractionHandler replyEphemeral(String content) {
        return this.reply((InteractionApplicationCommandCallbackData)InteractionApplicationCommandCallbackData.builder().content(content).flags(Integer.valueOf(6)).build());
    }

    @Override
    public FollowupInteractionHandler reply(InteractionApplicationCommandCallbackData callbackData) {
        ImmutableInteractionResponseData responseData = InteractionResponseData.builder().type(InteractionResponseType.CHANNEL_MESSAGE_WITH_SOURCE.getValue()).data(callbackData).build();
        return new FollowupInteractionHandler((InteractionResponseData)responseData, __ -> Mono.empty());
    }

    @Override
    public Mono<MessageData> getInitialResponse() {
        return this.restClient.getWebhookService().getWebhookMessage(this.applicationId, this.interactionData.token(), "@original");
    }

    @Override
    public Mono<MessageData> editInitialResponse(WebhookMessageEditRequest request) {
        return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), "@original", request);
    }

    @Override
    public Mono<MessageData> editInitialResponse(MultipartRequest<WebhookMessageEditRequest> request) {
        return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), "@original", request);
    }

    @Override
    public Mono<Void> deleteInitialResponse() {
        return this.restClient.getWebhookService().deleteWebhookMessage(this.applicationId, this.interactionData.token(), "@original");
    }

    @Override
    public Mono<MessageData> createFollowupMessage(String content) {
        ImmutableFollowupMessageRequest body = FollowupMessageRequest.builder().content(content).build();
        return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, MultipartRequest.ofRequestAndFiles(body, Collections.emptyList()));
    }

    @Override
    public Mono<MessageData> createFollowupMessage(MultipartRequest<? extends WebhookExecuteRequest> request) {
        return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, request);
    }

    @Override
    public Mono<MessageData> createFollowupMessageEphemeral(String content) {
        ImmutableFollowupMessageRequest body = FollowupMessageRequest.builder().content(content).flags(Integer.valueOf(64)).build();
        return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, MultipartRequest.ofRequest(body));
    }

    @Override
    public Mono<MessageData> createFollowupMessageEphemeral(MultipartRequest<WebhookExecuteRequest> request) {
        ImmutableFollowupMessageRequest newBody = FollowupMessageRequest.builder().from(request.getJsonPayload()).flags(Integer.valueOf(64)).build();
        return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, MultipartRequest.ofRequest(newBody));
    }

    @Override
    public Mono<MessageData> editFollowupMessage(long messageId, WebhookMessageEditRequest request, boolean wait) {
        return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId), request);
    }

    @Override
    public Mono<MessageData> editFollowupMessage(long messageId, MultipartRequest<WebhookMessageEditRequest> request) {
        return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId), request);
    }

    @Override
    public Mono<Void> deleteFollowupMessage(long messageId) {
        return this.restClient.getWebhookService().deleteWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId));
    }
}

