/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.ImmutableMessageCreateFields;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.WebhookExecuteSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class WebhookExecuteSpec
implements WebhookExecuteSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final String username_value;
    private final boolean username_absent;
    private final String avatarUrl_value;
    private final boolean avatarUrl_absent;
    private final boolean tts;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final List<EmbedCreateSpec> embeds;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<TopLevelMessageComponent> components_value;
    private final boolean components_absent;
    private final String threadName_value;
    private final boolean threadName_absent;
    private final Snowflake threadId_value;
    private final boolean threadId_absent;
    private final List<Message.Flag> flags_value;
    private final boolean flags_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final WebhookExecuteSpec INSTANCE = WebhookExecuteSpec.validate(new WebhookExecuteSpec());

    private WebhookExecuteSpec() {
        Possible content$impl = Possible.absent();
        Possible username$impl = Possible.absent();
        Possible avatarUrl$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        Possible threadName$impl = Possible.absent();
        Possible threadId$impl = Possible.absent();
        Possible flags$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.threadName_value = threadName$impl.toOptional().orElse(null);
        this.threadName_absent = threadName$impl.isAbsent();
        this.threadId_value = threadId$impl.toOptional().orElse(null);
        this.threadId_absent = threadId$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookExecuteSpec(Builder builder) {
        Possible content$impl = builder.content_build();
        Possible username$impl = builder.username_build();
        Possible avatarUrl$impl = builder.avatarUrl_build();
        Possible allowedMentions$impl = builder.allowedMentions_build();
        Possible components$impl = builder.components_build();
        Possible threadName$impl = builder.threadName_build();
        Possible threadId$impl = builder.threadId_build();
        Possible flags$impl = builder.flags_build();
        if (builder.ttsIsSet()) {
            this.initShim.tts(builder.tts);
        }
        if (builder.filesIsSet()) {
            this.initShim.files(WebhookExecuteSpec.createUnmodifiableList(true, builder.files));
        }
        if (builder.fileSpoilersIsSet()) {
            this.initShim.fileSpoilers(WebhookExecuteSpec.createUnmodifiableList(true, builder.fileSpoilers));
        }
        if (builder.embedsIsSet()) {
            this.initShim.embeds(WebhookExecuteSpec.createUnmodifiableList(true, builder.embeds));
        }
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.threadName_value = threadName$impl.toOptional().orElse(null);
        this.threadName_absent = threadName$impl.isAbsent();
        this.threadId_value = threadId$impl.toOptional().orElse(null);
        this.threadId_absent = threadId$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private WebhookExecuteSpec(Possible<String> content, Possible<String> username, Possible<String> avatarUrl, boolean tts, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, List<EmbedCreateSpec> embeds, Possible<AllowedMentions> allowedMentions, Possible<List<TopLevelMessageComponent>> components, Possible<String> threadName, Possible<Snowflake> threadId, Possible<List<Message.Flag>> flags) {
        Possible<String> content$impl = content;
        Possible<String> username$impl = username;
        Possible<String> avatarUrl$impl = avatarUrl;
        this.initShim.tts(tts);
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        this.initShim.embeds(embeds);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<List<TopLevelMessageComponent>> components$impl = components;
        Possible<String> threadName$impl = threadName;
        Possible<Snowflake> threadId$impl = threadId;
        Possible<List<Message.Flag>> flags$impl = flags;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.username_value = username$impl.toOptional().orElse(null);
        this.username_absent = username$impl.isAbsent();
        this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
        this.avatarUrl_absent = avatarUrl$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.threadName_value = threadName$impl.toOptional().orElse(null);
        this.threadName_absent = threadName$impl.isAbsent();
        this.threadId_value = threadId$impl.toOptional().orElse(null);
        this.threadId_absent = threadId$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.tts = this.initShim.tts();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.embeds = this.initShim.embeds();
        this.initShim = null;
    }

    private boolean ttsInitialize() {
        return WebhookExecuteSpecGenerator.super.tts();
    }

    private List<MessageCreateFields.File> filesInitialize() {
        return WebhookExecuteSpecGenerator.super.files();
    }

    private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
        return WebhookExecuteSpecGenerator.super.fileSpoilers();
    }

    private List<EmbedCreateSpec> embedsInitialize() {
        return WebhookExecuteSpecGenerator.super.embeds();
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<String> username() {
        return this.username_absent ? Possible.absent() : Possible.of((Object)this.username_value);
    }

    @Override
    public Possible<String> avatarUrl() {
        return this.avatarUrl_absent ? Possible.absent() : Possible.of((Object)this.avatarUrl_value);
    }

    @Override
    public boolean tts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tts() : this.tts;
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public List<EmbedCreateSpec> embeds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.embeds() : this.embeds;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<List<TopLevelMessageComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public Possible<String> threadName() {
        return this.threadName_absent ? Possible.absent() : Possible.of((Object)this.threadName_value);
    }

    @Override
    public Possible<Snowflake> threadId() {
        return this.threadId_absent ? Possible.absent() : Possible.of((Object)this.threadId_value);
    }

    @Override
    public Possible<List<Message.Flag>> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of(this.flags_value);
    }

    public WebhookExecuteSpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(newValue, this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec((Possible<String>)newValue, this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withUsername(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), newValue, this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withUsername(String value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), (Possible<String>)newValue, this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withAvatarUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), newValue, this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withAvatarUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), (Possible<String>)newValue, this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public final WebhookExecuteSpec withTts(boolean value) {
        if (this.tts == value) {
            return this;
        }
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), value, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public final WebhookExecuteSpec withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public final WebhookExecuteSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(elements, true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, newValue, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public final WebhookExecuteSpec withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, newValue, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public final WebhookExecuteSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(elements, true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, newValue, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public final WebhookExecuteSpec withEmbeds(EmbedCreateSpec ... elements) {
        List<EmbedCreateSpec> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(Arrays.asList(elements), true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public final WebhookExecuteSpec withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
        if (this.embeds == elements) {
            return this;
        }
        List<EmbedCreateSpec> newValue = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(elements, true, false));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, newValue, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, newValue, this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, (Possible<AllowedMentions>)newValue, this.components(), this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withComponents(Possible<List<TopLevelMessageComponent>> possible) {
        Possible<List<TopLevelMessageComponent>> newValue = Objects.requireNonNull(possible);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue, this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withComponents(Iterable<TopLevelMessageComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue, this.threadName(), this.threadId(), this.flags()));
    }

    @SafeVarargs
    public final WebhookExecuteSpec withComponents(TopLevelMessageComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), (Possible<List<TopLevelMessageComponent>>)newValue, this.threadName(), this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withThreadName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), newValue, this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withThreadName(String value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), (Possible<String>)newValue, this.threadId(), this.flags()));
    }

    public WebhookExecuteSpec withThreadId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), newValue, this.flags()));
    }

    public WebhookExecuteSpec withThreadId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), (Possible<Snowflake>)newValue, this.flags()));
    }

    public WebhookExecuteSpec withFlags(Possible<List<Message.Flag>> possible) {
        Possible<List<Message.Flag>> newValue = Objects.requireNonNull(possible);
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), newValue));
    }

    public WebhookExecuteSpec withFlags(Iterable<Message.Flag> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), (Possible<List<Message.Flag>>)newValue));
    }

    @SafeVarargs
    public final WebhookExecuteSpec withFlags(Message.Flag ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this.content(), this.username(), this.avatarUrl(), this.tts, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components(), this.threadName(), this.threadId(), (Possible<List<Message.Flag>>)newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookExecuteSpec && this.equalTo(0, (WebhookExecuteSpec)another);
    }

    private boolean equalTo(int synthetic, WebhookExecuteSpec another) {
        return this.content().equals(another.content()) && this.username().equals(another.username()) && this.avatarUrl().equals(another.avatarUrl()) && this.tts == another.tts && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.embeds.equals(another.embeds) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value) && this.threadName().equals(another.threadName()) && this.threadId().equals(another.threadId()) && Objects.equals(this.flags_value, another.flags_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.username().hashCode();
        h += (h << 5) + this.avatarUrl().hashCode();
        h += (h << 5) + Boolean.hashCode(this.tts);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.embeds.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + this.threadName().hashCode();
        h += (h << 5) + this.threadId().hashCode();
        h += (h << 5) + Objects.hashCode(this.flags_value);
        return h;
    }

    public String toString() {
        return "WebhookExecuteSpec{content=" + this.content().toString() + ", username=" + this.username().toString() + ", avatarUrl=" + this.avatarUrl().toString() + ", tts=" + this.tts + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", embeds=" + this.embeds + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + ", threadName=" + this.threadName().toString() + ", threadId=" + this.threadId().toString() + ", flags=" + Objects.toString(this.flags_value) + "}";
    }

    public static WebhookExecuteSpec create() {
        return INSTANCE;
    }

    private static WebhookExecuteSpec validate(WebhookExecuteSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static WebhookExecuteSpec copyOf(WebhookExecuteSpecGenerator instance) {
        if (instance instanceof WebhookExecuteSpec) {
            return (WebhookExecuteSpec)instance;
        }
        return WebhookExecuteSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isUsernamePresent() {
        return !this.username_absent;
    }

    public String usernameOrElse(String defaultValue) {
        return !this.username_absent ? this.username_value : defaultValue;
    }

    public boolean isAvatarUrlPresent() {
        return !this.avatarUrl_absent;
    }

    public String avatarUrlOrElse(String defaultValue) {
        return !this.avatarUrl_absent ? this.avatarUrl_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<TopLevelMessageComponent> componentsOrElse(List<TopLevelMessageComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public boolean isThreadNamePresent() {
        return !this.threadName_absent;
    }

    public String threadNameOrElse(String defaultValue) {
        return !this.threadName_absent ? this.threadName_value : defaultValue;
    }

    public boolean isThreadIdPresent() {
        return !this.threadId_absent;
    }

    public Snowflake threadIdOrElse(Snowflake defaultValue) {
        return !this.threadId_absent ? this.threadId_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public List<Message.Flag> flagsOrElse(List<Message.Flag> defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_TTS = 1L;
        private static final long OPT_BIT_FILES = 2L;
        private static final long OPT_BIT_FILE_SPOILERS = 4L;
        private static final long OPT_BIT_EMBEDS = 8L;
        private long optBits;
        private Possible<String> content_possible = Possible.absent();
        private Possible<String> username_possible = Possible.absent();
        private Possible<String> avatarUrl_possible = Possible.absent();
        private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
        private List<TopLevelMessageComponent> components_list = null;
        private Possible<String> threadName_possible = Possible.absent();
        private Possible<Snowflake> threadId_possible = Possible.absent();
        private List<Message.Flag> flags_list = null;
        private boolean tts;
        private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
        private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();
        private List<EmbedCreateSpec> embeds = new ArrayList<EmbedCreateSpec>();

        private Builder() {
        }

        public final Builder from(WebhookExecuteSpec instance) {
            return this.from((WebhookExecuteSpecGenerator)instance);
        }

        final Builder from(WebhookExecuteSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.username(instance.username());
            this.avatarUrl(instance.avatarUrl());
            this.tts(instance.tts());
            this.addAllFiles(instance.files());
            this.addAllFileSpoilers(instance.fileSpoilers());
            this.addAllEmbeds(instance.embeds());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            this.threadName(instance.threadName());
            this.threadId(instance.threadId());
            this.flags(instance.flags());
            return this;
        }

        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        public Builder content(String value) {
            this.content_possible = Possible.of((Object)value);
            return this;
        }

        public Builder username(Possible<String> value) {
            this.username_possible = value;
            return this;
        }

        public Builder username(String value) {
            this.username_possible = Possible.of((Object)value);
            return this;
        }

        public Builder avatarUrl(Possible<String> value) {
            this.avatarUrl_possible = value;
            return this;
        }

        public Builder avatarUrl(String value) {
            this.avatarUrl_possible = Possible.of((Object)value);
            return this;
        }

        public final Builder tts(boolean tts) {
            this.tts = tts;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFile(MessageCreateFields.File element) {
            element = ImmutableMessageCreateFields.File.copyOf(element);
            this.files.add(Objects.requireNonNull(element, "files element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFile(String name, InputStream inputStream) {
            return this.addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
        }

        public final Builder addFiles(MessageCreateFields.File ... elements) {
            for (MessageCreateFields.File element : elements) {
                element = ImmutableMessageCreateFields.File.copyOf(element);
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
            for (MessageCreateFields.File file : elements) {
                ImmutableMessageCreateFields.File file2 = ImmutableMessageCreateFields.File.copyOf(file);
                this.files.add(Objects.requireNonNull(file2, "files element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
            element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
            this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            this.optBits |= 4L;
            return this;
        }

        public final Builder addFileSpoiler(String name, InputStream inputStream) {
            return this.addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
        }

        public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
            for (MessageCreateFields.FileSpoiler element : elements) {
                element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
                this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            this.fileSpoilers.clear();
            return this.addAllFileSpoilers(elements);
        }

        public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
            for (MessageCreateFields.FileSpoiler fileSpoiler : elements) {
                ImmutableMessageCreateFields.FileSpoiler fileSpoiler2 = ImmutableMessageCreateFields.FileSpoiler.copyOf(fileSpoiler);
                this.fileSpoilers.add(Objects.requireNonNull(fileSpoiler2, "fileSpoilers element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public final Builder addEmbed(EmbedCreateSpec element) {
            this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            this.optBits |= 8L;
            return this;
        }

        public final Builder addEmbeds(EmbedCreateSpec ... elements) {
            for (EmbedCreateSpec element : elements) {
                this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public final Builder embeds(Iterable<? extends EmbedCreateSpec> elements) {
            this.embeds.clear();
            return this.addAllEmbeds(elements);
        }

        public final Builder addAllEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
            for (EmbedCreateSpec embedCreateSpec : elements) {
                this.embeds.add(Objects.requireNonNull(embedCreateSpec, "embeds element"));
            }
            this.optBits |= 8L;
            return this;
        }

        public Builder allowedMentions(Possible<AllowedMentions> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        public Builder allowedMentions(AllowedMentions value) {
            this.allowedMentions_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addComponent(TopLevelMessageComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        public Builder addAllComponents(List<TopLevelMessageComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        public Builder components(Possible<List<TopLevelMessageComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<TopLevelMessageComponent>)e));
            return this;
        }

        public Builder components(List<TopLevelMessageComponent> elements) {
            this.components_list = new ArrayList<TopLevelMessageComponent>(elements);
            return this;
        }

        public Builder components(Iterable<TopLevelMessageComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder threadName(Possible<String> value) {
            this.threadName_possible = value;
            return this;
        }

        public Builder threadName(String value) {
            this.threadName_possible = Possible.of((Object)value);
            return this;
        }

        public Builder threadId(Possible<Snowflake> value) {
            this.threadId_possible = value;
            return this;
        }

        public Builder threadId(Snowflake value) {
            this.threadId_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addFlag(Message.Flag element) {
            this.flags_getOrCreate().add(element);
            return this;
        }

        public Builder addAllFlags(List<Message.Flag> elements) {
            this.flags_getOrCreate().addAll(elements);
            return this;
        }

        public Builder flags(Possible<List<Message.Flag>> elements) {
            this.flags_list = null;
            elements.toOptional().ifPresent(e -> this.flags_getOrCreate().addAll((Collection<Message.Flag>)e));
            return this;
        }

        public Builder flags(List<Message.Flag> elements) {
            this.flags_list = new ArrayList<Message.Flag>(elements);
            return this;
        }

        public Builder flags(Iterable<Message.Flag> elements) {
            this.flags_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public WebhookExecuteSpec build() {
            return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this));
        }

        private boolean ttsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean filesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean fileSpoilersIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean embedsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<String> username_build() {
            return this.username_possible;
        }

        private Possible<String> avatarUrl_build() {
            return this.avatarUrl_possible;
        }

        private Possible<AllowedMentions> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<List<TopLevelMessageComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<TopLevelMessageComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<TopLevelMessageComponent>();
            }
            return this.components_list;
        }

        private Possible<String> threadName_build() {
            return this.threadName_possible;
        }

        private Possible<Snowflake> threadId_build() {
            return this.threadId_possible;
        }

        private Possible<List<Message.Flag>> flags_build() {
            return this.flags_list == null ? Possible.absent() : Possible.of(this.flags_list);
        }

        private List<Message.Flag> flags_getOrCreate() {
            if (this.flags_list == null) {
                this.flags_list = new ArrayList<Message.Flag>();
            }
            return this.flags_list;
        }
    }

    private final class InitShim {
        private byte ttsBuildStage = 0;
        private boolean tts;
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;
        private byte embedsBuildStage = 0;
        private List<EmbedCreateSpec> embeds;

        private InitShim() {
        }

        boolean tts() {
            if (this.ttsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ttsBuildStage == 0) {
                this.ttsBuildStage = (byte)-1;
                this.tts = WebhookExecuteSpec.this.ttsInitialize();
                this.ttsBuildStage = 1;
            }
            return this.tts;
        }

        void tts(boolean tts) {
            this.tts = tts;
            this.ttsBuildStage = 1;
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(WebhookExecuteSpec.this.filesInitialize(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(WebhookExecuteSpec.this.fileSpoilersInitialize(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        List<EmbedCreateSpec> embeds() {
            if (this.embedsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.embedsBuildStage == 0) {
                this.embedsBuildStage = (byte)-1;
                this.embeds = WebhookExecuteSpec.createUnmodifiableList(false, WebhookExecuteSpec.createSafeList(WebhookExecuteSpec.this.embedsInitialize(), true, false));
                this.embedsBuildStage = 1;
            }
            return this.embeds;
        }

        void embeds(List<EmbedCreateSpec> embeds) {
            this.embeds = embeds;
            this.embedsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ttsBuildStage == -1) {
                attributes.add("tts");
            }
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            if (this.embedsBuildStage == -1) {
                attributes.add("embeds");
            }
            return "Cannot build WebhookExecuteSpec, attribute initializers form cycle " + attributes;
        }
    }
}

