/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.Webhook;
import discord4j.core.spec.WebhookEditWithTokenMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class WebhookEditWithTokenMono
extends WebhookEditWithTokenMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Image avatar_value;
    private final boolean avatar_absent;
    private final Webhook webhook;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private WebhookEditWithTokenMono(Webhook webhook) {
        this.webhook = Objects.requireNonNull(webhook, "webhook");
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible avatar$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    private WebhookEditWithTokenMono(@reactor.util.annotation.Nullable String reason, Possible<String> name, Possible<Image> avatar, Webhook webhook) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Image> avatar$impl = avatar;
        this.webhook = webhook;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<Image> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of((Object)this.avatar_value);
    }

    @Override
    public Webhook webhook() {
        return this.webhook;
    }

    public final WebhookEditWithTokenMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new WebhookEditWithTokenMono(value, this.name(), this.avatar(), this.webhook);
    }

    public WebhookEditWithTokenMono withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new WebhookEditWithTokenMono(this.reason, newValue, this.avatar(), this.webhook);
    }

    public WebhookEditWithTokenMono withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookEditWithTokenMono(this.reason, (Possible<String>)newValue, this.avatar(), this.webhook);
    }

    public WebhookEditWithTokenMono withAvatar(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return new WebhookEditWithTokenMono(this.reason, this.name(), newValue, this.webhook);
    }

    public WebhookEditWithTokenMono withAvatar(Image value) {
        Possible newValue = Possible.of((Object)value);
        return new WebhookEditWithTokenMono(this.reason, this.name(), (Possible<Image>)newValue, this.webhook);
    }

    public final WebhookEditWithTokenMono withWebhook(Webhook value) {
        if (this.webhook == value) {
            return this;
        }
        Webhook newValue = Objects.requireNonNull(value, "webhook");
        return new WebhookEditWithTokenMono(this.reason, this.name(), this.avatar(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookEditWithTokenMono && this.equalTo(0, (WebhookEditWithTokenMono)another);
    }

    private boolean equalTo(int synthetic, WebhookEditWithTokenMono another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.avatar().equals(another.avatar()) && this.webhook.equals(another.webhook);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.avatar().hashCode();
        h += (h << 5) + this.webhook.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "WebhookEditWithTokenMono{reason=" + this.reason + ", name=" + this.name().toString() + ", avatar=" + this.avatar().toString() + ", webhook=" + this.webhook + "}";
    }

    public static WebhookEditWithTokenMono of(Webhook webhook) {
        return new WebhookEditWithTokenMono(webhook);
    }

    static WebhookEditWithTokenMono copyOf(WebhookEditWithTokenMonoGenerator instance) {
        if (instance instanceof WebhookEditWithTokenMono) {
            return (WebhookEditWithTokenMono)instance;
        }
        return WebhookEditWithTokenMono.of(instance.webhook()).withReason(instance.reason()).withName((Possible<String>)instance.name()).withAvatar((Possible<Image>)instance.avatar());
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public Image avatarOrElse(Image defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookEditWithTokenMono, attribute initializers form cycle " + attributes;
        }
    }
}

