/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.LogUtil;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.VoiceServerUpdateEvent;
import discord4j.core.event.domain.VoiceStateUpdateEvent;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.core.spec.DefaultVoiceServerUpdateTask;
import discord4j.core.spec.Spec;
import discord4j.core.spec.VoiceChannelJoinSpec;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.gateway.GatewayClientGroup;
import discord4j.gateway.intent.Intent;
import discord4j.gateway.json.ShardGatewayPayload;
import discord4j.voice.AudioProvider;
import discord4j.voice.AudioReceiver;
import discord4j.voice.LocalVoiceReceiveTaskFactory;
import discord4j.voice.LocalVoiceSendTaskFactory;
import discord4j.voice.VoiceChannelRetrieveTask;
import discord4j.voice.VoiceConnection;
import discord4j.voice.VoiceDisconnectTask;
import discord4j.voice.VoiceGatewayOptions;
import discord4j.voice.VoiceReceiveTaskFactory;
import discord4j.voice.VoiceSendTaskFactory;
import discord4j.voice.VoiceServerOptions;
import discord4j.voice.VoiceStateUpdateTask;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.immutables.value.Value;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.TupleUtils;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.ContextView;
import reactor.util.retry.RetrySpec;

@Value.Immutable(singleton=true)
interface VoiceChannelJoinSpecGenerator
extends Spec<Function<VoiceChannel, Mono<VoiceConnection>>> {
    public static final int DEFAULT_TIMEOUT = 10;
    public static final int DEFAULT_DISCOVERY_TIMEOUT = 5;

    public static Flux<VoiceStateUpdateEvent> onVoiceStateUpdates(GatewayDiscordClient gateway, Snowflake guildId) {
        return gateway.getEventDispatcher().on(VoiceStateUpdateEvent.class).filter(vsu -> {
            Snowflake vsuUser = vsu.getCurrent().getUserId();
            Snowflake vsuGuild = vsu.getCurrent().getGuildId();
            return vsuUser.equals((Object)gateway.getSelfId()) && vsuGuild.equals((Object)guildId);
        });
    }

    public static Mono<VoiceServerUpdateEvent> onVoiceServerUpdate(GatewayDiscordClient gateway, Snowflake guildId) {
        return gateway.getEventDispatcher().on(VoiceServerUpdateEvent.class).filter(vsu -> vsu.getGuildId().equals((Object)guildId) && vsu.getEndpoint() != null).next();
    }

    @Value.Default
    default public Duration timeout() {
        return Duration.ofSeconds(10L);
    }

    @Value.Default
    default public AudioProvider provider() {
        return AudioProvider.NO_OP;
    }

    @Deprecated
    @Value.Default
    default public AudioReceiver receiver() {
        return AudioReceiver.NO_OP;
    }

    @Value.Default
    default public VoiceSendTaskFactory sendTaskFactory() {
        return new LocalVoiceSendTaskFactory();
    }

    @Deprecated
    @Value.Default
    default public VoiceReceiveTaskFactory receiveTaskFactory() {
        return new LocalVoiceReceiveTaskFactory();
    }

    @Value.Default
    default public boolean selfDeaf() {
        return false;
    }

    @Value.Default
    default public boolean selfMute() {
        return false;
    }

    @Value.Default
    default public Duration ipDiscoveryTimeout() {
        return Duration.ofSeconds(5L);
    }

    @Value.Default
    default public RetrySpec ipDiscoveryRetrySpec() {
        return RetrySpec.maxInARow((long)1L);
    }

    @Override
    default public Function<VoiceChannel, Mono<VoiceConnection>> asRequest() {
        return voiceChannel -> {
            Logger log = Loggers.getLogger(VoiceChannelJoinSpec.class);
            GatewayDiscordClient gateway = voiceChannel.getClient();
            if (!gateway.getGatewayResources().getIntents().contains((Object)Intent.GUILD_VOICE_STATES)) {
                return Mono.error((Throwable)new IllegalArgumentException("GUILD_VOICE_STATES intent is required to establish a voice connection"));
            }
            Snowflake guildId = voiceChannel.getGuildId();
            Snowflake channelId = voiceChannel.getId();
            GatewayClientGroup clientGroup = voiceChannel.getClient().getGatewayClientGroup();
            int shardId = clientGroup.computeShardIndex(guildId);
            Mono sendVoiceStateUpdate = clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate((VoiceStateUpdate)VoiceStateUpdate.builder().guildId(guildId.asString()).channelId(channelId.asString()).selfMute(this.selfMute()).selfDeaf(this.selfDeaf()).build(), (int)shardId));
            Mono waitForVoiceStateUpdate = VoiceChannelJoinSpecGenerator.onVoiceStateUpdates(gateway, guildId).next();
            Mono<VoiceServerUpdateEvent> waitForVoiceServerUpdate = VoiceChannelJoinSpecGenerator.onVoiceServerUpdate(gateway, guildId);
            VoiceDisconnectTask disconnectTask = id -> voiceChannel.sendDisconnectVoiceState().then(gateway.getVoiceConnectionRegistry().disconnect(id));
            DefaultVoiceServerUpdateTask serverUpdateTask = new DefaultVoiceServerUpdateTask(gateway);
            VoiceStateUpdateTask stateUpdateTask = id -> VoiceChannelJoinSpecGenerator.onVoiceStateUpdates(gateway, id).map(stateUpdateEvent -> stateUpdateEvent.getCurrent().getSessionId());
            VoiceChannelRetrieveTask channelRetrieveTask = () -> gateway.getMemberById(voiceChannel.getGuildId(), gateway.getSelfId()).flatMap(PartialMember::getVoiceState).flatMap(voiceState -> Mono.justOrEmpty(voiceState.getChannelId()));
            Mono newConnection = sendVoiceStateUpdate.then(Mono.zip((Mono)waitForVoiceStateUpdate, waitForVoiceServerUpdate)).flatMap(TupleUtils.function((voiceState, voiceServer) -> {
                String session = voiceState.getCurrent().getSessionId();
                VoiceServerOptions voiceServerOptions = new VoiceServerOptions(voiceServer.getToken(), voiceServer.getEndpoint());
                VoiceGatewayOptions voiceGatewayOptions = new VoiceGatewayOptions(guildId, gateway.getSelfId(), session, voiceServerOptions, gateway.getCoreResources().getJacksonResources(), gateway.getGatewayResources().getVoiceReactorResources(), gateway.getGatewayResources().getVoiceReconnectOptions(), this.provider(), this.receiver(), this.sendTaskFactory(), this.receiveTaskFactory(), disconnectTask, serverUpdateTask, stateUpdateTask, channelRetrieveTask, this.ipDiscoveryTimeout(), this.ipDiscoveryRetrySpec());
                return gateway.getVoiceConnectionFactory().create(voiceGatewayOptions).flatMap(vc -> gateway.getVoiceConnectionRegistry().registerVoiceConnection(guildId, vc).thenReturn(vc)).doOnEach(signal -> {
                    if (signal.isOnSubscribe()) {
                        log.debug(LogUtil.format((ContextView)signal.getContextView(), (String)"Creating voice connection"));
                    }
                }).contextWrite(ctx -> ctx.put((Object)"discord4j.gateway", (Object)Integer.toHexString(gateway.hashCode())).put((Object)"discord4j.shard", (Object)shardId).put((Object)"discord4j.guild", (Object)guildId.asLong()));
            })).timeout(this.timeout()).doFinally(signal -> log.debug("Voice connection handshake to guild {} done after {}", new Object[]{guildId.asLong(), signal})).onErrorResume(TimeoutException.class, t -> gateway.getVoiceConnectionRegistry().getVoiceConnection(guildId).switchIfEmpty(voiceChannel.sendDisconnectVoiceState().then(Mono.error((Throwable)t))));
            return gateway.getVoiceConnectionRegistry().getVoiceConnection(guildId).flatMap(existing -> sendVoiceStateUpdate.then(waitForVoiceStateUpdate).thenReturn(existing)).switchIfEmpty(newConnection);
        };
    }
}

